/***************************************
  $Header: /home/amb/x/xbomb/RCS/xbomb.h 1.5 1995/02/02 18:59:40 amb Exp $

  XBomb - 'Minesweeper' game - Version 2

  Global header file.

  Written by Andrew M. Bishop

  This file Copyright 1994 1995 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef XBOMB_H
#define XBOMB_H

/* State of each square */

#define EMPTY         0
#define ACTUAL_BOMB  16
#define THINK_BOMB   32
#define UNSEEN       64
#define CORRECT     128

/* Status of game */

#define GAME_CONTINUES 0
#define GAME_WAIT      1
#define GAME_LOST      2
#define GAME_WON       3
#define GAME_READY     4

/* Status of game from the X part */

#define GAME_START     10
#define GAME_QUIT      11
#define GAME_LEVEL     12
/* Game level uses 12 -> ... */

/* The type of game */

#define GAME_TYPE     20
#define GAME_HEXAGON  20
#define GAME_SQUARE   21
#define GAME_TRIANGLE 22

/* The levels */

#define NLEVELS 3
#define MAX_SIZE 30

#define WIDTHS    { 8        ,16        ,30}
#define HEIGHTS   { 8        ,16        ,16}
#define NBOMBS    {10        ,40        ,99}
#define LEVELS    {"Easy","Medium","Difficult"}
#define LEVELSLEN 10

/* The game types */

#define NTYPES    3
#define TYPES     {"Hexagons","Squares","Triangles"}
#define TYPESLEN  10

/* The high score table */

#define HIGH_SCORE_FILENAMES {"/var/tmp/xbomb6.hi","/var/tmp/xbomb4.hi","/var/tmp/xbomb3.hi"}
#define FILENAMELEN 20

/* In hiscore.c */

void LoadHighScores(void);
void SaveHighScores(void);
void PrintHighScores(int level);
void AddHighScore(int level,int ticks);

/* In xbomb.c */

void StartGame(int level,int type);
void HideBombs(int xs,int ys);
void StopGame(void);
void DrawGrid(void);
void SelectSquare(int x,int y);
void SelectAdjacent(int x,int y);
void MarkBomb(int x,int y);
void RemoveEmpties(int x, int y);

/* In xwindow.c */

void InitialiseX(int *argc,char **argv);
void FinishUpX(void);
int ProcessXEvents(void);
void DrawSquare(int x,int y,unsigned char value);
void ScaleWindow(void);
void StartClock(int reset);
int StopClock(void);
void SetUXB(int n);

#endif
