<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup team
 * @module team_overview
 * @package team
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("team","overview");
 loadlayout();

 /**
  * display an overview of teams
  */
 class team_overview extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos,$lang;

     $result = $this->dbconn->Exec($this->q);

     $n = $result->numrows();
     if ( 0 == $n) {
       echo $this->error( $lang['Err0048'] );
       $result->free();
       return;
     }


     # Make a big array of all visible teams
     $x = 0;
     while ( $x < $n ) {
       $b = new team($this->dbconn);
       $b->read_result($result,$x);
       $x++;
       if ( ! $b->see_ok() ) {
         unset($b);
         continue;
       }
       $tlist[] = &$b;
       unset($b);
     }
     $n = count($tlist);
     if ( 0 == $n) {
       echo $this->error( $lang['Err0048'] );
       $result->free();
       return;
     }


	 echo $this->actionformStart("team_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("name",$lang['Team'],$this->link2);
     echo $this->orderHeader("",$lang['TeamManager'],$this->link2);
     echo $this->orderHeader("",$lang['TeamCount'],$this->link2);
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->start == -1 ) {
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     echo "<tbody>\n";
     $line = 0;
     while ( ($a < $n) && ($a < $end) ) {
       $t = $tlist[$a];

       echo $this->OverviewRowStart($line);
       echo " <td>". $t->getLink() ."</td>\n";
       echo " <td>". $t->owner->getLink() ."</td>\n";
       echo " <td align=\"right\">". count($t->ids) ."</td>\n";
       if ( $tutos[massupdate] == 1 ) {
         echo " <td align=\"center\">\n";
         if ( $t->mod_ok() ) {
           echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $t->id ."\">\n";
         } else {
           echo "-\n";
         }
         echo "</td>\n";
       }
       echo $this->OverviewRowEnd($line++);
       $a++;
     }
     echo "</tbody>\n";
     echo "<tfoot>\n";
     echo $this->list_navigation($this->link1,3 + $tutos[massupdate],$this->start,$a,$n);

     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart(2);
       echo sprintf($lang['withmarked'],$lang['Teams']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
       echo "</select>\n";
       echo $this->UpdateRowEnd(2);
     }

     echo "</tfoot>\n";
     echo $this->OverviewTableEnd();
	 echo $this->actionformEnd("team_overview.php");
     $result->free();
   }
   /**
    *
    */
   Function navigate() {
   }
   /**
    * do mass actions
    */
   Function action() {
     global $msg,$lang;

     @reset($_GET['mark']);
     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       while (list ($key,$val) = @each ($_GET['mark'])) {
         $obj = new team($this->dbconn);
         $obj->read($val);
         if ( $obj->id != $val ) {
           continue;
         }
         if ( $obj->del_ok() ) {
           $msg .= $lang['Delete'] ."&nbsp;". $obj->getFullName() ."<br>";
           $msg .= $obj->delete();
         } else {
           $msg .= $obj->getLink() .": ". sprintf($lang['Err0023'],$lang[$obj->getType()]) ."<br>";
         }
         unset($obj);
       }
       $this->dbconn->Commit("WORK");
     }
   }
   /**
    *
    */
   Function prepare() {
     global $lang;

     $this->name = $lang['TeamOverview'];

     $this->link1 = "team_overview.php";
     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."teams";
     $pre = " WHERE ";

     if ( isset($_GET['name']) && ($_GET['name'] != "*") && ($_GET['name'] != "") ) {
       $this->q .= $pre .  $this->dbconn->Like("name",$_GET['name']);
      $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
     }

     check_dbacl( $this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"name");

     # Menu      
     $x = team::getSelectLink($this->user,$lang['Search']);
     $this->addMenu($x);

     if ( $this->user->feature_ok(useteams,PERM_NEW) ) {
       $x = array( url => "team_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['TeamCreateI'],
                   category => array("team","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new team_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: team_overview.php,v 1.40.2.1 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->
