/***************************************************************************
                          QDBSUCHEN  -  description
                             -------------------                                         
    begin                : 28.02.2000
    version              : $Id: qdbsuchen.cpp,v 1.3 2000/11/11 15:09:04 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "qdbsuchen.h"

QDBSuchen::QDBSuchen( QWidget *parent, const char *name,
											SQLTable *tablePtr)
					: QDialog(parent,name,true){
  int i;

	table  = tablePtr;
	dialog = (QDBEingabemaske *) parent;
	ResultPos = -1;
	initDialog();
	if (dialog==0)
		QMessageBox::warning( this, "Suchen", "Programmfehler: Dialog mu bergeben werden." );
	if (table!=0) {
	 	for (i=0; (i < table->getnFields()) && (i < MAXFELDER); i++) {
			QComboBox_Feld->insertItem( table->fName( i ) );
	 	}
	} else
		QMessageBox::warning( this, "Suchen", "Programmfehler: Tabelle mu bergeben werden." );

	connect( QPushButton_Abbruch, SIGNAL(pressed()), SLOT(close()) );
	connect( QPushButton_Suchen, SIGNAL(pressed()), SLOT(fSuchen()) );
	connect( QLineEdit_Wert, SIGNAL(textChanged( const QString & )), SLOT(fButton()) );

	QPushButton_Suchen->setEnabled( false );
}

QDBSuchen::~QDBSuchen(){
	ResultPos = -1;
}

void QDBSuchen::fButton(){
	if ( strlen( QLineEdit_Wert->text() ) > 0 )
		QPushButton_Suchen->setEnabled( true );
	else
		QPushButton_Suchen->setEnabled( false );
}

void QDBSuchen::fSuchen(){
	QCString TupleWert;
	int nTuples;

	if ( ResultPos > -1 ) {
		nTuples = ResultPos+1;
	} else {
		nTuples = 0;
	}

 	for ( ;nTuples < table->getnTuples(); nTuples++ ) {
 		// Schleife durch alle Datenfelder
		TupleWert = table->getValue( nTuples, table->fNumber( QComboBox_Feld->currentText()));
		if (!QCheckBox_1->isChecked()) {
			if ( strncasecmp( QLineEdit_Wert->text(), TupleWert, strlen(QLineEdit_Wert->text()) ) == 0 ) {
				ResultPos = nTuples;
				dialog->Neue_DBPos( nTuples );
				QPushButton_Suchen->setText( "Weiter&suchen" );
				break;
			}
		} else {
			if ( strncmp( QLineEdit_Wert->text(), TupleWert, strlen(QLineEdit_Wert->text()) ) == 0 ) {
				ResultPos = nTuples;
				dialog->Neue_DBPos( nTuples );
				QPushButton_Suchen->setText( "Weiter&suchen" );
				break;
			}
		}
 	}
	if ( nTuples == table->getnTuples() ) {
		QPushButton_Suchen->setDown(false);
		QPushButton_Suchen->setText( "&Suchen" );
		ResultPos = -1;
		QMessageBox::information( this, "Suchen", "Nicht gefunden." );
	}
}
