/***************************************************************************
                     qdbeingabemaske.h  -  description
                     ---------------------------------
    begin                : 29.04.2000
    version              : $Id: qdbeingabemaske.h,v 1.10 2001/01/10 16:57:52 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : <info@bemme.de> www.bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef QDBEINGABEMASKE_H
#define QDBEINGABEMASKE_H

#include <qwidget.h>

#include "sqlquerier.h"
#include "dbobj.h"
#include "maskgenerator.h"

/**
  *@author Jrg Bemm
  */

class QDBEingabemaske : public QDBWidget  {
   Q_OBJECT
public: 
	QDBEingabemaske(QWidget *parent=0, const char *name=0,
			SQLQuerier *sql=0, SQLTable *table=0,
			const char *tableName=0, QDBTableView *TableP2_ptr=0,
			bool MakeFields=true, const char *filename=0);
	~QDBEingabemaske();
  void	Neue_DBPos( int Pos );
	bool	setValue( const char *fieldname, QString *value );

  QDBLineEdit *Feld[MAXFELDER];
	QFrame *frDfP1a; // Frame for database fields on page 1
	MaskGenerator *frMask; // Different frames for the first page.
	QDBNavigator *navP1;

	// Feldwert-Vorgaben
	// Diese Vorgaben haben nichts mit den Default-Werten der
	// SQL-Datenbank zu tun.
	QCString *Feldvorgabe[MAXFELDER];

private:
	SQLQuerier *sql; // Eigentliche Schnittstelle zur Datenbank
  SQLTable* table; // Datenbank-Abfrage (select, usw.)
	QFrame *frNavP1;					// Rahmen fr Navigator-Bar auf Seite 1
	QVBoxLayout *topLayoutP1;
	const char *sName;
  QDBTableView *TableP2;

	// This variable perhaps better in SQLTable,
	// because they have nothing to do with the visual elements.
  bool	DBmodified;
  bool	DBinserted;
	bool	DBdeleted;

  void	DBSpeichern();
	QCString *GetPrimaryKey( QCString *Key );
	void	initFields();

public slots:
	void	fNew();
	void	fRead();

private slots:
	void	fFirst();
	void	fBefore();
	void	fNext();
	void	fLast();
	void	fFind();
	void	fUpdate();
	void	fUndo();
	void	fDelete();
	void	fFieldBefore();
	void	fFieldNext();

signals:
	void	tupleChanged();
	void	posChanged();
	void	sigNew();
	void	sigUndo();
};

#endif
