/***************************************************************************
                          dbobj.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Sep 3 1999                                           
    version              : $Id: dbobj.cpp,v 1.17 2001/03/14 13:59:04 joerg_bemme Exp $
    copyright            : (C) 1999 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qheader.h>
#include <qlabel.h>
#include <qmessagebox.h>

#include "dbobj.h"
#include "qdbdialog.h"

#include "pixmaps/first.xpm"
#include "pixmaps/before.xpm"
#include "pixmaps/next.xpm"
#include "pixmaps/last.xpm"
#include "pixmaps/read.xpm"
#include "pixmaps/find.xpm"
#include "pixmaps/new.xpm"
#include "pixmaps/delete.xpm"
#include "pixmaps/update.xpm"
#include "pixmaps/undo.xpm"

QDBNavigator::QDBNavigator( QWidget * parent, int nRows, int nCols,
														int border, int autoBorder, const char * name )
  : QGridLayout( parent, nRows, nCols, border, autoBorder , name )
{
  QPixmap pmFirst  = QPixmap( first );
  QPixmap pmBefore = QPixmap( before );
  QPixmap pmNext   = QPixmap( next );
  QPixmap pmLast   = QPixmap( last );
  QPixmap pmFind   = QPixmap( find );
  QPixmap pmRead   = QPixmap( read );
  QPixmap pmUpdate = QPixmap( update );
  QPixmap pmUndo   = QPixmap( undo );
  QPixmap pmNew    = QPixmap( bnew );
  QPixmap pmDelete = QPixmap( bdelete );

	bFirst = new QPushButton( parent, "First" );
	bFirst->setPixmap( pmFirst );
  bFirst->setFixedHeight( bFirst->sizeHint().height() );
  addWidget( bFirst, 0, 0 );

	bBefore = new QPushButton( parent, "Before" );
	bBefore->setPixmap( pmBefore );
  bBefore->setFixedHeight( bBefore->sizeHint().height() );
  addWidget( bBefore, 0, 1 );

	bNext = new QPushButton( parent, "Next" );
	bNext->setPixmap( pmNext );
  bNext->setFixedHeight( bNext->sizeHint().height() );
  addWidget( bNext, 0, 2 );

	bLast = new QPushButton( parent, "Last" );
	bLast->setPixmap( pmLast );
  bLast->setFixedHeight( bLast->sizeHint().height() );
  addWidget( bLast, 0, 3 );

	bRead = new QPushButton( parent, "Read" );
	bRead->setFont( QFont( "Helvetica", 10, QFont::Normal ) );
	bRead->setText( "F2" );
	bRead->setIconSet( QIconSet( pmRead ) );
  bRead->setFixedHeight( bRead->sizeHint().height() );
  addWidget( bRead, 0, 4 );

	bFind = new QPushButton( parent, "Find" );
	bFind->setFont( QFont( "Helvetica", 10, QFont::Normal ) );
	bFind->setText( "F7" );
	bFind->setIconSet( QIconSet( pmFind ) );
  bFind->setFixedHeight( bFind->sizeHint().height() );
  addWidget( bFind, 0, 5 );

	bUpdate = new QPushButton( parent, "Update" );
	bUpdate->setFont( QFont( "Helvetica", 10, QFont::Normal ) );
	bUpdate->setText( "F10" );
	bUpdate->setIconSet( QIconSet( pmUpdate ) );
  bUpdate->setFixedHeight( bUpdate->sizeHint().height() );
  addWidget( bUpdate, 0, 6 );

	bUndo = new QPushButton( parent, "Undo" );
	bUndo->setFont( QFont( "Helvetica", 10, QFont::Normal ) );
	bUndo->setText( "ESC" );
	bUndo->setIconSet( QIconSet( pmUndo ) );
  bUndo->setFixedHeight( bUndo->sizeHint().height() );
  addWidget( bUndo, 0, 7 );

	bNew = new QPushButton( parent, "New" );
	bNew->setFont( QFont( "Helvetica", 10, QFont::Normal ) );
	bNew->setText( "Einfg" );
	bNew->setIconSet( QIconSet( pmNew ) );
  bNew->setFixedHeight( bNew->sizeHint().height() );
  addWidget( bNew, 0, 8 );

	bDelete = new QPushButton( parent, "Delete" );
	bDelete->setFont( QFont( "Helvetica", 10, QFont::Normal ) );
	bDelete->setText( "F4" );
	bDelete->setIconSet( QIconSet( pmDelete ) );
  bDelete->setFixedHeight( bDelete->sizeHint().height() );
  addWidget( bDelete, 0, 9 );

	QToolTip::add( bFirst, "Erster Datensatz [Shift+Pos1]" );
	QWhatsThis::add( bFirst, "Hiermit bewegen Sie sich zum ersten Datensatz.");
	QToolTip::add( bBefore, "Vorheriger Datensatz [Bild auf]" );
	QWhatsThis::add( bBefore, "Hiermit bewegen Sie sich einen Datensatz zurck.\n"
													"Sie knnen auch die 'Bild auf'-Taste benutzen.");
	QToolTip::add( bNext, "Nchster Datensatz [Bild ab]" );
	QWhatsThis::add( bNext, "Hiermit bewegen Sie sich einen Datensatz weiter.\n"
													"Sie knnen auch die 'Bild ab'-Taste benutzen.");
	QToolTip::add( bLast, "Letzter Datensatz [Shift+Ende]" );
	QWhatsThis::add( bLast, "Hiermit bewegen Sie sich zum letzten Datensatz.");
	QToolTip::add( bRead, "Daten neu lesen" );
	QWhatsThis::add( bRead, "Hiermit aktualisieren Sie die Anzeige mit der Datenbank.\n"
													"Das ist z. B. dann hilfreich, wenn Sie mit vielen"
													"gleichzeitig an den Daten arbeiten.");
	QToolTip::add( bFind, "Datensatz suchen" );
	QWhatsThis::add( bFind, "Hiermit suchen Sie einen Datensatz.");
	QToolTip::add( bUpdate, "Datensatznderungen speichern" );
	QWhatsThis::add( bUpdate, "Hiermit speichern Sie Ihre nderungen unwiderruflich.");
	QToolTip::add( bUndo, "nderungen verwerfen" );
	QWhatsThis::add( bUndo, "Hiermit werden Ihre nderungen gelscht<br>"
                          "<b>und nicht gespeichert</b>.");
	QToolTip::add( bNew, "Neuer Datensatz" );
	QWhatsThis::add( bNew, "Hiermit erzeugen Sie einen neuen Datensatz.");
	QToolTip::add( bDelete, "Datensatz lschen" );
	QWhatsThis::add( bDelete, "Der angezeigte Datensatz wird <b>unwiderruflich</b> gelscht.");

	connect( bNew, SIGNAL(clicked()), SLOT(sNewTuple()) );
}

void QDBNavigator::sNewTuple()
{
	// This signal is for other modules to set
	// the mask with default values.
	emit sigNewTuple();
}

void QDBNavigator::setButtonsUp()
{
	bFirst->setDown(false);
	bBefore->setDown(false);
	bNext->setDown(false);
	bLast->setDown(false);
	bRead->setDown(false);
	bFind->setDown(false);
	bUpdate->setDown(false);
	bUndo->setDown(false);
	bNew->setDown(false);
	bDelete->setDown(false);
}

QDBButtons::QDBButtons( QWidget * parent, int nRows, int nCols,
												int border, int autoBorder, const char *name )
  : QGridLayout( parent, nRows, nCols, border, autoBorder , name )
{
	b1 = new QPushButton( parent, "Anwenden" );
	b1->setText( "Anwenden" );
  addWidget( b1, 0, 0 );
	b2 = new QPushButton( parent, "Sortierung aus" );
	b2->setText( "Sortierung aus" );
  addWidget( b2, 0, 1 );
	b3 = new QPushButton( parent, "Filter aus" );
	b3->setText( "Filter aus" );
  addWidget( b3, 0, 2 );
	b4 = new QPushButton( parent, "Alles aus" );
	b4->setText( "Alles aus" );
  addWidget( b4, 0, 3 );

	QToolTip::add( b1, "Sortierung und Filter aktivieren" );
	QWhatsThis::add( b1, "Hiermit aktivieren Sie die Sortierung und den Filter.<br>"
												"Ein 'A' hinter der Sortiernummer zeigt ein bereits aktives Sortierfeld.");
	QToolTip::add( b2, "Sortierfelder ausschalten" );
	QWhatsThis::add( b2,"Hiermit schalten Sie nur die Sortierfelder aus. Die aktuelle Sortierung "
											"bleibt aktiv bis Sie 'Anwenden' drcken. Es wird nur die Anzeige "
											"zurckgesetzt.");
	QToolTip::add( b3, "Filter ausschalten" );
	QWhatsThis::add( b3,"Hiermit werden die Filter zurckgesetzt. Die Filter bleiben solange aktiv"
											"bis Sie auf 'Anwenden' drcken. Es werden nur die Anzeigefelder gelscht.");
	QToolTip::add( b4, "Sortierung und Filter ausschalten" );
	QWhatsThis::add( b4,"Sortierung und Filter werden ausgeschaltet. Die Datenstze werden so "
											"angezeigt wie sie in der Datenbank liegen. Sie mssen anschlieend noch "
											"'Anwenden' drcken um die Einstellungen zu aktivieren.");
}

QDBDate::QDBDate()
{

}

char *QDBDate::getDate( int format )
{
	QDate cd = QDate::currentDate();

	if (format == 0) // Germany
		sprintf( d, "%i.%i.%i", cd.day(), cd.month(), cd.year() );

	//printf( "%s\n", d );
	return d;
}

QDBTableView::QDBTableView( QWidget *parent, const char *name,
														SQLQuerier *sql_ptr, SQLTable* table_ptr )
  : QListView( parent, name )
{
	sql	= sql_ptr;
	table = table_ptr;
	nTuples = 0;

	setSorting(-1); // Disable Sorting

	if (table->sQuery.length() != 0)
		getColumns();
	connect( this, SIGNAL(pressedF2()), SLOT(sUpdate()) );
}

void QDBTableView::getColumns()
{
	int i;

	if ( sql->conn != NULL ) {
		// create column captions
		for (i=0; i < table->getnFields(); i++) {
			addColumn( table->fName(i) );
		}
		table->pos = table->getnTuples()-1;
		update( table );
	}
}

void QDBTableView::update( SQLTable *table, bool withDelete )
{
	int i, iPos;
	QDBListViewItem *lvi;

	// Delete old QListViewItems
	if (withDelete)
		clear();

	// Delete the QListViewItems and create new.
	if (( sql->conn != NULL ) && (table->pos > -1)) {
		iPos = table->getnTuples()-1;
		// Loop through all selected tuples
		for ( nTuples = 0; nTuples < table->getnTuples(); nTuples++ ) {
			lvi = new QDBListViewItem( this, 0, iPos );
			// Loop through all datafields
			for ( i = 0; i < table->getnFields(); i++ ) {
				lvi->setText( i, table->getValue( iPos, i ) );
			}
			iPos--;
		}

		lvi = (QDBListViewItem *) firstChild();
		for ( i = 0; i < childCount(); i++ ) {
			if ( lvi->DBPos == table->pos ) {
				setCurrentItem( lvi );
				break;
			}
			lvi = (QDBListViewItem *) lvi->itemBelow();
		}

		setSelected( currentItem(), true);
	}
}

void QDBTableView::sUpdate()
{
	// reload the database table ...
  if (table->execute() != SUCCESS_RESULTS)
		QMessageBox::warning( this, "QtTudo Tabelle neu lesen", table->ErrorText );
	// and show it
	update( table );
}

void QDBTableView::keyPressEvent( QKeyEvent *e )
{
	if ( e->key() == Key_F2 ) { // F2 for reload database table
		e->ignore();
		emit pressedF2();
	} else {
		QListView::keyPressEvent( e );
	}
}

QDBListViewItem * QDBTableView::currentItem() const
{
	return (QDBListViewItem *) QListView::currentItem();
}

QDBListViewItem::QDBListViewItem( QDBTableView *parent, const QString &text, int pos )
    : QListViewItem( parent, text )
{
	DBPos = pos;
}

QDBCheckBox::QDBCheckBox( QWidget *parent, const char *name )
  : QCheckBox( parent, name )
{
	Nummer = 0;
	Aktiv = false;
}

QDBSortFilter::QDBSortFilter( QWidget *parent, const char * name,
															SQLQuerier *sql_ptr, SQLTable* table_ptr )
  : QGridLayout( parent, 3, 1, 5, -1, name )
{
	int i;
	QLabel *l;
	QHeader *h = new QHeader( parent );

	sql	= sql_ptr;
	table = table_ptr;
	maxNr = 0;

  // Spalten-berschriften erzeugen
	if ( sql->conn != NULL ) {
		frScroll	= new QFrame( parent );
		frButtons	= new QFrame( parent );
		frScroll->setFrameStyle( QFrame::Panel | QFrame::Raised );
		frButtons->setFrameStyle( QFrame::Panel | QFrame::Raised );
		gScroll		= new QGridLayout( frScroll, table->getnFields(), 5, 5, -1, "Scroll" );

		gButtons	= new QDBButtons( frButtons );
		frButtons->setMaximumHeight( 36);

		// Spaltenberschriften erzeugen
		h->addLabel( "Datenfeld", 170 );
		h->addLabel( "Sort.", 44 );
		h->addLabel( "S." );
		h->addLabel( "F." );
		h->addLabel( "Filter", 336 );
		h->setMinimumSize( h->sizeHint() );
		h->setMovingEnabled( false );
		h->setClickEnabled( false );
		h->setResizeEnabled( false );

		svScroll = new QScrollView( parent );
		for (i=0; (i < table->getnFields()) && (i < MAXFELDER); i++) {
			l = new QLabel( frScroll );
			gScroll->addWidget( l, i, 0 );
			l->setText( table->fName( i ) );
			l->setFixedWidth( 160 );
			feld[i] = new QDBCheckBox( frScroll );
			gScroll->addWidget( feld[i], i, 1 );
			feld[i]->setFixedWidth( 38 );
			connect( feld[i], SIGNAL(clicked()), SLOT(sAnzeige()) );
			SA[i] = new QCheckBox( frScroll );
			gScroll->addWidget( SA[i], i, 2 );
			SA[i]->setFixedWidth( 14 );
			SA[i]->setEnabled( false );
			FA[i] = new QCheckBox( frScroll );
			gScroll->addWidget( FA[i], i, 3 );
			FA[i]->setFixedWidth( 14 );
			FA[i]->setEnabled( false );
			filter[i] = new QLineEdit( frScroll );
			gScroll->addWidget( filter[i], i, 4 );
			filter[i]->setMinimumWidth( 336 );
		}
		frScroll->setMinimumSize( frScroll->sizeHint() );
		svScroll->addChild( frScroll );

		addWidget( h, 0, 0 );
		addWidget( svScroll, 1, 0 );
		addWidget( frButtons, 2, 0 );

		connect( gButtons->b1, SIGNAL(pressed()), SLOT(sAnwenden()) );
		connect( gButtons->b2, SIGNAL(pressed()), SLOT(sSort_aus()) );
		connect( gButtons->b3, SIGNAL(pressed()), SLOT(sFilter_aus()) );
		connect( gButtons->b4, SIGNAL(pressed()), SLOT(sAlles_aus()) );
	}
	QWhatsThis::add( h, "<b>Datenfeld:</b> Der Name des Datenfeldes."
											"<br><b>Sort.:</b> Hier knnen Sie die Felder auswhlen "
											"nach denen die Daten sortiert werden sollen."
											"<br>Die Sortierung und die Filter sind erst aktiv nach "
											"drcken der Taste [Anwenden]. "
											"Optisch sichtbar durch [S.] und [F.]."
											"<br><b>S.:</b> Zeigt die aktiven Sortierfelder an. "
											"<br><b>F.:</b> Zeigt die aktiven Filter an. "
											"<br><b>Filter:</b> Hier knnen Sie Feldabgrenzungen "
											"eingeben. Der Syntax entspricht dem SQL-Standard. Der "
											"Datenfeldname darf nicht mit angegeben werden. Beispiele "
											"und genauere Informationen entnehmen Sie bitte dem "
											"Online-Handbuch.");
}

void QDBSortFilter::sAnzeige()
{
	int i, ii, neueNr;
	char cNummer[32];

 	for (i=0; (i < table->getnFields()) && (i < MAXFELDER); i++) {
		if ( feld[i]->isChecked() ) {
			if ( feld[i]->Nummer == 0 ) {
				maxNr++;
				sprintf(cNummer, "%i", maxNr );
				feld[i]->Nummer = maxNr;
				feld[i]->setText( cNummer );
			}
		} else {
			feld[i]->Nummer = 0;
	 		feld[i]->setText( "" );
			if (feld[i]->Aktiv)
				SA[i]->setChecked( true );
			else
				SA[i]->setChecked( false );
		}
 	}
	// Nummern neu vergeben
	neueNr = 1;
	for (ii=1; maxNr >= ii; ii++) {
		for (i=0; (i < table->getnFields()) && (i < MAXFELDER); i++) {
			if (feld[i]->Nummer == ii) {
				feld[i]->Nummer = neueNr;
				sprintf(cNummer, "%i", neueNr );
				feld[i]->setText( cNummer );
				neueNr++;
				if (feld[i]->Aktiv)
					SA[i]->setChecked( true );
				else
					SA[i]->setChecked( false );
				break;
			}
		}
	}
	maxNr = neueNr;
}

void QDBSortFilter::sAnwenden()
{
	int i, menge = 0, menge_filter = 0;
	unsigned int ii, start = 0;
	bool first = true;
	bool first_filter = true;
	QCString lQuery;

	lQuery = table->sQuery;

	// Searching for old filter und sorting
	for (ii = start; ii < strlen( lQuery ); ii++) {
		//printf( "%c", lQuery[ii] ); // only for test
		if (lQuery[ii] == ' ') // count spaces
			start++;
		if (start == 4) // End of tablename
			break;
	}
	// if found, then delete old selection and filter
	if ( ii < strlen( lQuery ) ) {
		lQuery[ii] = 0;
		//printf( "Start: %i %s\n", start, (const char *) lQuery ); // only for test
	}

	// Evtl. Filter setzen
 	for (i=0; (i < table->getnFields()) && (i < MAXFELDER); i++) {
		if (strlen(filter[i]->text()) != 0) {
			if (first_filter) {
				first_filter = false;
				lQuery.append( " WHERE " );
			} else
				lQuery.append( " AND " );
			lQuery.append( table->fName( i ) );
			lQuery.append( " " + filter[i]->text());
			menge_filter++;
			FA[i]->setChecked( true );
		} else {
			FA[i]->setChecked( false );
		}
	}
	// Evtl. Sortierung setzen
 	for (i=0; (i < table->getnFields()) && (i < MAXFELDER); i++) {
		if ( feld[i]->isChecked() ) {
			if (first) {
				first = false;
				lQuery.append( " ORDER BY " );
			} else
				lQuery.append( "," );
			lQuery.append( table->fName( i ) ); // Sortierfeld anhngen
			menge++;
			if (!feld[i]->Aktiv) {
				feld[i]->Aktiv = true;
				SA[i]->setChecked( true );
			}
		} else {
			feld[i]->Aktiv = false;
			feld[i]->setText( "" );
			SA[i]->setChecked( false );
		}
 	}
	table->sQuery = lQuery;
	// Test: If you want to see the query before the execution
	//QMessageBox::information( 0, "Test: Anwenden", table->sQuery.copy() );
	table->execute();
	// Die Anzeige mu von der aufrufenden Funktion noch aktualisiert werden.
	emit updateView();
}

void QDBSortFilter::sSort_aus()
{
 	for (int i=0; (i < table->getnFields()) && (i < MAXFELDER); i++) {
 		feld[i]->setChecked( false );
 		feld[i]->setText( "" );
		feld[i]->Nummer = 0;
 	}
	maxNr = 0;
}

void QDBSortFilter::sFilter_aus()
{
 	for (int i=0; (i < table->getnFields()) && (i < MAXFELDER); i++) {
		filter[i]->setText( "" );
 	}
}

void QDBSortFilter::sAlles_aus()
{
	sSort_aus();
	sFilter_aus();
}

QDBLineEdit::QDBLineEdit( QWidget *parent, const char *name,
													SQLQuerier *sql_ptr, SQLTable* table,
													int DatensatzNr )
  : QLineEdit( parent, name )
{
	sql	= sql_ptr;
	geaendert = false;
	screenNo = -1;
	// 'name' is the fieldname
	if ((sql->conn != NULL) && (name != 0) && (DatensatzNr>-1)) {
	  //printf("type[%d] = %d, size[%d] = %d\n", table->fNumber(name), PQftype(sql->res, DatenfeldNr), DatenfeldNr, PQfsize(sql->res, DatenfeldNr));
		if (table->getnTuples() != 0)
			switch ( table->fType(table->fNumber(name)) ) {
			// 21		=	int2
			// 23		=	int4
			// 790	=	money
			// 1043	=	varchar
			// 1184	=	datetime
			case 16: // bool
				if ( strcmp(table->getValue( DatensatzNr, table->fNumber(name)),"t") == 0 )
					setText( "ja" );
				else
					setText( "nein" );
				break;
			default:
				// Inhalt aus Feld holen
				setText( table->getValue( DatensatzNr, table->fNumber(name) ));
			}
		else
			setText( "" );
	}
	connect( this, SIGNAL(textChanged( const QString & )), SLOT(fGeaendert()) );
}

void QDBLineEdit::fGeaendert()
{
	geaendert = true;
}

QDBWidget::QDBWidget( QWidget *parent, const char *name )
  : QWidget( parent, name )
{
}

void QDBWidget::keyPressEvent( QKeyEvent *e )
{
	// Only for test
	//printf( "%i\n", e->key() );

	//if ( e->key() == Key_Return )
		//e->ignore();
	//else
	if ( (e->key() == 4112) && (e->state() == ShiftButton) ) { // Shift + Pos1/Home
		e->ignore();
		emit pressedShiftPos1();
	} else
	if ( (e->key() == 4113) && (e->state() == ShiftButton) ) { // Shift + End
		e->ignore();
		emit pressedShiftEnd();
	} else
	if ( e->key() == 4118 ) { // Page up
		e->ignore();
		emit changePosUp();
	} else
	if ( e->key() == 4119 ) { // Page down
		e->ignore();
		emit changePosDown();
	} else
	if ( e->key() == Key_Up ) { // Up
		e->ignore();
		emit pressedUp();
	} else
	if ( e->key() == Key_Down ) { // Down
		e->ignore();
		emit pressedDown();
	} else
	if ( e->key() == Key_Home ) { // Pos1/Home
		e->ignore();
		emit pressedPos1();
	} else
	if ( e->key() == Key_End ) { // End
		e->ignore();
		emit pressedEnd();
	} else
	if ( e->key() == Key_Insert ) { // Insert
		e->ignore();
		emit pressedInsert();
	} else
	if ( e->key() == Key_F2 ) { // F2 reload database table
		e->ignore();
		emit pressedF2();
	} else
	if ( e->key() == Key_F4 ) { // F4 for delete a tuple
		e->ignore();
		emit pressedF4();
	} else
	if ( e->key() == Key_F6 ) { // F6 get field value
		e->ignore();
		emit pressedF6();
	} else
	if ( e->key() == Key_F7 ) { // F7 search tuple
		e->ignore();
		emit pressedF7();
	} else
	if ( e->key() == Key_F10 ) { // F10 update tuple
		e->ignore();
		emit pressedF10();
	} else {
		if ( e->key() == Key_Escape ) {
			emit pressedEsc();
			e->accept();
		}
		QWidget::keyPressEvent( e );
	}
}
