/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"

#ifdef USE_SSL
#include <string.h>
#include <time.h>

#include "myssl.h"
#include "http.h"
#include "bufio.h"
#include "errcode.h"
#include "tools.h"

/*
Most of this code is inspired by example programs from SSLeay package
*/

void my_ssl_init()
{
	unsigned char rnd_stack_data[64],*p = NULL;
	int rv = 0;

#ifdef HAVE_RAND_EGD
	if (!RAND_status())
	{
		char random_dev[PATH_MAX + 1];
		const char *p;

		if (priv_cfg.egd_socket)
		{
			strncpy(random_dev, priv_cfg.egd_socket, PATH_MAX);
		}
		else
		{
#ifdef EGD_SOCKET_NAME
			strncpy(random_dev, EGD_SOCKET_NAME, PATH_MAX);
#else
			/* we do not have /dev/random so need to seed
			   entropy pool from an external source */
			p = RAND_file_name(random_dev, PATH_MAX + 1);
			if (!p)
			{
				xprintf(1, gettext("Failed obtaining entropy pathname\n"));
				rv = -1;
			}
#endif
		}
		if (rv != -1)
		{
			rv = RAND_egd(random_dev);
			if (rv == -1)
			{
				xprintf(1, gettext("Failed to initialize random seed for OpenSSL via EGD daemon\n"));
			}
		}
	}
#endif

	if (rv == -1)
	{
		p = rnd_stack_data;
		time((time_t *)p);
		RAND_seed(rnd_stack_data, sizeof(rnd_stack_data));
		xprintf(1, gettext("Seeding entropy pool INSECURELY!\n"));
	}
}

static int my_ssl_passwd_callback(char *buf, int num, int verify)
{
	if (verify)
		xprintf(1, "%s\n", buf);
	else
	{
		if (num > strlen(priv_cfg.ssl_cert_passwd))
		{
			strcpy(buf, priv_cfg.ssl_cert_passwd);
			return strlen(buf);
		}
	}
	return 0;
}

int my_ssl_do_connect(docp, socket, ssl_con, ssl_ctx, ssl_method, ssl_bio, parent_ssl_con)
doc *docp;
bufio *socket;
SSL **ssl_con;
SSL_CTX **ssl_ctx;
SSL_METHOD **ssl_method;
BIO **ssl_bio;
SSL *parent_ssl_con;
{
	int rv;

	my_ssl_init();

	if (priv_cfg.ssl_proxy)
	{
		if (http_dumy_proxy_connect(docp, 
			url_get_site(docp->doc_url), url_get_port(docp->doc_url),
			priv_cfg.ssl_proxy, cfg.ssl_proxy_port))
		{
			docp->errcode = ERR_PROXY_CONNECT;
			return FALSE;
		}
	}

	if (!*ssl_method)
	{
		SSL_load_error_strings();
		switch(cfg.ssl_version)
		{
			case 1:
				*ssl_method = SSLv23_client_method();
			break;
			case 2:
				*ssl_method = SSLv2_client_method();
			break;
			case 3:
				*ssl_method = SSLv3_client_method();
			break;
#ifdef WITH_SSL_TLS1
			case 4:
				*ssl_method = TLSv1_client_method();
			break;
#endif
		}
		SSLeay_add_ssl_algorithms();
	}

	if (!cfg.unique_sslid || !*ssl_ctx)
	{
		*ssl_ctx = SSL_CTX_new(*ssl_method);
		if (priv_cfg.ssl_cipher_list)
			SSL_CTX_set_cipher_list(*ssl_ctx, priv_cfg.ssl_cipher_list);
	}
	
/* SSL Certification stuff */
	if ((!cfg.unique_sslid || !*ssl_con) && priv_cfg.ssl_cert_file != NULL)
	{
		SSL *ssl;
		X509 *x509;

		if (priv_cfg.ssl_cert_passwd)
		{
			SSL_CTX_set_default_passwd_cb(*ssl_ctx , my_ssl_passwd_callback);
		}

		if (SSL_CTX_use_certificate_file(*ssl_ctx , priv_cfg.ssl_cert_file,
				SSL_FILETYPE_PEM) <= 0)
		{
			xprintf(1 , gettext("Unable to set certificate file (wrong password?)\n"));
			return FALSE;
		}

		if (priv_cfg.ssl_key_file == NULL) 
			priv_cfg.ssl_key_file = new_string(priv_cfg.ssl_cert_file);

		if (SSL_CTX_use_PrivateKey_file(*ssl_ctx , priv_cfg.ssl_key_file,
				SSL_FILETYPE_PEM) <= 0) 
		{
			xprintf(1, gettext("Unable to set public key file\n"));
			return FALSE;
		}

		ssl = SSL_new(*ssl_ctx);
	    
		x509 = SSL_get_certificate(ssl);
    
		if (x509 != NULL)
			EVP_PKEY_copy_parameters(X509_get_pubkey(x509),
			SSL_get_privatekey(ssl));

		SSL_free(ssl);

		if (!SSL_CTX_check_private_key(*ssl_ctx))
		{
			xprintf(1, gettext("Private key does not match the certificate public key\n"));
			return FALSE;
		}    
	}	
/* End SSL Certification stuff */
	
	if (!cfg.unique_sslid || !*ssl_con)
		*ssl_con = SSL_new(*ssl_ctx);
	*ssl_bio = BIO_new_socket(bufio_getfd(socket), BIO_NOCLOSE);
	SSL_set_bio(*ssl_con , *ssl_bio , *ssl_bio);
	if (parent_ssl_con)
		SSL_copy_session_id(*ssl_con, parent_ssl_con);
	SSL_set_connect_state(*ssl_con);
	SSL_do_handshake(*ssl_con);

	while((rv = SSL_in_init(*ssl_con)) && 
		SSL_get_error(*ssl_con , rv) == SSL_ERROR_WANT_CONNECT)
	{
		tl_msleep(2);
	}

	if (rv < 0)
	{
#ifdef DEBUG
		SSL_get_error(*ssl_con , -1);
		ERR_print_errors_fp(stdout);
#endif
		if (cfg.unique_sslid)
		{
			SSL_set_shutdown(*ssl_con, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN);
		}
		else
		{
			SSL_free(*ssl_con);
			SSL_CTX_free(*ssl_ctx);
			*ssl_con = NULL;
			*ssl_ctx = NULL;
		}
		return FALSE;
	}
#if 0
/*** this is broken because of non-blocking IO ***/
#ifdef DEBUG
	else if (cfg.debug)
	{
		X509* server_cert;
		char *str;

		xprintf(1 , gettext("SSL connection is using %s\n"), SSL_get_cipher(cfg.ssl_con));

		server_cert = SSL_get_peer_certificate(cfg.ssl_con);
		xprintf(1 , gettext("Server certificate:\n"));
  
		str = X509_NAME_oneline(X509_get_subject_name(server_cert) ,
					NULL , 0);
		xprintf(1 , gettext("\t subject: %s\n"), str);
		_free (str);

		str = X509_NAME_oneline(X509_get_issuer_name(server_cert) ,
					NULL , 0);
		xprintf(1 , gettext("\t issuer: %s\n"), str);
		_free (str);

		X509_free (server_cert);
	}
#endif
#endif
	return TRUE;
}

int my_ssl_read(ssl_con, buf, len)
SSL *ssl_con;
char *buf;
int len;
{
	int rv = -1;
	bool_t stopread = FALSE;

	while (!stopread)
	{
		rv = SSL_read((SSL *)ssl_con , buf , len);

		if (rv == 0) /* Nothing read */
		{
			stopread = TRUE;
			break;
		}

		switch (SSL_get_error((SSL *)ssl_con , rv))
		{
			case SSL_ERROR_WANT_READ:
			case SSL_ERROR_WANT_WRITE:
				tl_msleep(10);
				break;
			case SSL_ERROR_SSL:
				ERR_print_errors_fp(stdout);
				stopread = TRUE;
				rv = -1;
				break;
			case SSL_ERROR_SYSCALL:
				if ((errno != EWOULDBLOCK) &&
					(errno != EAGAIN))
				{
					len = 0;
					stopread = TRUE;
					rv = -1;
				}
				else
					tl_msleep(10);
			break;
			default:
				stopread = TRUE;
				break;
		}
	}

	return rv;
}

int my_ssl_write(ssl_con, buf, len)
SSL *ssl_con;
char *buf;
int len;
{
	int rv = 0;
	int pv = 0;

	while (len)
	{
		rv = SSL_write((SSL *)ssl_con , buf , len);
		switch ((pv = SSL_get_error((SSL *)ssl_con , rv)))
		{
			case SSL_ERROR_NONE:
				len -= rv;
				buf += rv;
				if (rv <= 0) len = 0;
				break;
			case SSL_ERROR_WANT_WRITE:
			case SSL_ERROR_WANT_READ:
				tl_msleep(10);
				break;
			case SSL_ERROR_SSL:
				ERR_print_errors_fp(stdout);
				rv = -1;
				break;
			case SSL_ERROR_SYSCALL:
				if ((errno != EWOULDBLOCK) &&
				    (errno != EAGAIN))
				{
					len = 0;	
					rv = -1;
				}
				else
					tl_msleep(10);
			break;
			default:
				len = 0;
				break;
		}
	}

	return rv;
}

#endif

