/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.translate.util;

import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.translate.util.InvalidParamValueException;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.relaxng.translate.util.Param;
import com.thaiopensource.relaxng.translate.util.ParamFactory;
import com.thaiopensource.relaxng.translate.util.ParamValuePresenceException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class ParamProcessor {
    private ErrorReporter er;
    private ParamFactory paramFactory;
    private final Map<String, Param> paramMap = new HashMap<String, Param>();
    private final Set<String> processedParamNames = new HashSet<String>();

    public void declare(String string, Param param) {
        this.paramMap.put(string, param);
    }

    public void setParamFactory(ParamFactory paramFactory) {
        this.paramFactory = paramFactory;
    }

    public void process(String[] stringArray, ErrorHandler errorHandler) throws InvalidParamsException, SAXException {
        this.er = new ErrorReporter(errorHandler, ParamProcessor.class);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this.processParam(stringArray[i]);
            }
            if (this.er.getHadError()) {
                throw new InvalidParamsException();
            }
        }
        catch (ErrorReporter.WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.getException();
        }
        finally {
            this.processedParamNames.clear();
            this.er = null;
        }
    }

    private void processParam(String string) {
        int n = string.indexOf(61);
        String string2 = null;
        try {
            if (n < 0) {
                if (string.startsWith("no-")) {
                    string2 = string.substring(3);
                    this.lookupParam(string2).set(false);
                } else {
                    string2 = string;
                    this.lookupParam(string2).set(true);
                }
            } else {
                string2 = string.substring(0, n);
                this.lookupParam(string2).set(string.substring(n + 1));
            }
        }
        catch (BadParamException badParamException) {
        }
        catch (LocalizedInvalidValueException localizedInvalidValueException) {
            this.er.error("invalid_param_value_detail", string2, this.er.getLocalizer().message(localizedInvalidValueException.key), null);
        }
        catch (InvalidParamValueException invalidParamValueException) {
            String string3 = invalidParamValueException.getMessage();
            if (string3 != null) {
                this.er.error("invalid_param_value_detail", string2, string3, null);
            } else if (n < 0) {
                this.er.error(string.startsWith("no-") ? "param_only_positive" : "param_only_negative", string2, null);
            } else {
                this.er.error("invalid_param_value", string2, null);
            }
        }
        catch (ParamValuePresenceException paramValuePresenceException) {
            if (n < 0) {
                this.er.error("param_value_required", string2, null);
            }
            this.er.error("param_value_not_allowed", string2, null);
        }
    }

    private Param lookupParam(String string) throws BadParamException {
        Param param = this.paramMap.get(string);
        if (param == null && this.paramFactory != null) {
            param = this.paramFactory.createParam(string);
        }
        if (param == null) {
            this.er.error("unrecognized_param", string, null);
            throw new BadParamException();
        }
        if (this.processedParamNames.contains(string)) {
            if (!param.allowRepeat()) {
                this.er.error("duplicate_param", string, null);
                throw new BadParamException();
            }
        } else {
            this.processedParamNames.add(string);
        }
        return param;
    }

    static class LocalizedInvalidValueException
    extends InvalidParamValueException {
        private final String key;

        LocalizedInvalidValueException(String string) {
            this.key = string;
        }
    }

    private static class BadParamException
    extends Exception {
        private BadParamException() {
        }
    }
}

