% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{github_releases}
\alias{github_releases}
\title{Get the tags of Github releases of a repository}
\usage{
github_releases(repo, subpath = "", pattern = "(v[0-9.]+)")
}
\arguments{
\item{repo}{The repository name of the form \code{user/repo}, e.g.,
\code{"yihui/xfun"}.}

\item{subpath}{A character string to be appended to the URL of Github
releases (i.e., \verb{https://github.com/user/repo/releases/}). For
example, you may use \code{subpath = "latest"} to get the tag of the latest
release.}

\item{pattern}{A regular expression to extract the tags from the HTML source.
It must contain a group (i.e., must have a pair of parentheses).}
}
\value{
A character vector of (GIT) tags.
}
\description{
Read the HTML source of the release page and parse the tags of the releases.
}
\examples{
if (interactive()) xfun::github_releases("yihui/xfun")
}
