/*
 * Copyright (c) 2016-2017 Leandro Nini
 *
 * The following is provided under terms of the Creative Commons
 * Attribution-NonCommercial-ShareAlike 3.0 Unported license:
 * http://creativecommons.org/licenses/by-nc-sa/3.0/
 */

#include "types.h"

// Uncomment to emulate the MOS 8580 r5 model
#define MOS8580

// Node Names
enum {
    // power
    Vcc = 0,
    _Vdd_,
    GND,
    // clock
    Phi2,
#ifndef MOS8580
    cl01,
    cl02,
    cl03,
    cl04,
    cl05,
    cl06,
    cl07,
    cl08,
    cl09,
    cl10,
    cl11,
    cl12,
    cl13,
#else
    cl01,
    cl02,
    cl03,
    cl04,
    cl10,
    cl11,
    cl12,
    cl13,
    cl14,
    cl15,
    cl16,
    cl20,
    cl21,
    cl22,
    cl23,
    cl24,
    cl25,
    cl26,
#endif
    cl_a,
    cl_b,
    sid_clk1,
    sid_clk2,
    // reset
    res,
    rst1,
    rst2,
    rst3,
    rst_ltc,
    sid_rst,
    // cs/rw
    rw,
    cs,
    rw1,
    rw2,
    rw4,
    rw5,
    _rw,
    rw10,
    rw11,
    rw12,
    write,
    rw20,
    rw21,
    rw22,
    read,
    // address pins
    A0,
    A1,
    A2,
    A3,
    A4,
    // address
    A0_1,
    A0_2,
    A0_3,
    A0_high,
    A0_5,
    A0_low,
    A1_1,
    A1_2,
    A1_3,
    A1_high,
    A1_5,
    A1_low,
    A2_1,
    A2_2,
    A2_3,
    A2_high,
    A2_5,
    A2_low,
    A3_1,
    A3_2,
    A3_3,
    A3_high,
    A3_5,
    A3_low,
    A4_1,
    A4_2,
    A4_3,
    A4_high,
    A4_5,
    A4_low,
    // address bus
    ad00,
    ad01,
    ad02,
    ad03,
    ad04,
    ad05,
    ad06,
    ad07,
    ad08,
    ad09,
    ad0a,
    ad0b,
    ad0c,
    ad0d,
    ad0e,
    ad0f,
    ad10,
    ad11,
    ad12,
    ad13,
    ad14,
    ad15,
    ad16,
    ad17,
    ad18,
    ad19,
    ad1a,
    ad1b,
    ad1c,
    // data pins
    D0,
    D1,
    D2,
    D3,
    D4,
    D5,
    D6,
    D7,
    // data write
    dw0_1,
    dw0_2,
    dw0_3,
    dw0_4,
    dw0_5,
    dw0_6,
    dw1_1,
    dw1_2,
    dw1_3,
    dw1_4,
    dw1_5,
    dw1_6,
    dw2_1,
    dw2_2,
    dw2_3,
    dw2_4,
    dw2_5,
    dw2_6,
    dw3_1,
    dw3_2,
    dw3_3,
    dw3_4,
    dw3_5,
    dw3_6,
    dw4_1,
    dw4_2,
    dw4_3,
    dw4_4,
    dw4_5,
    dw4_6,
    dw5_1,
    dw5_2,
    dw5_3,
    dw5_4,
    dw5_5,
    dw5_6,
    dw6_1,
    dw6_2,
    dw6_3,
    dw6_4,
    dw6_5,
    dw6_6,
    dw7_1,
    dw7_2,
    dw7_3,
    dw7_4,
    dw7_5,
    dw7_6,
    // data read
    dr0_1,
    dr0_2,
    dr0_3,
    dr0_4,
    dr0_5,
    dr0_6,
    dr0_7,
    dr0_8,
    dr0_9,
    dr1_1,
    dr1_2,
    dr1_3,
    dr1_4,
    dr1_5,
    dr1_6,
    dr1_7,
    dr1_8,
    dr1_9,
    dr2_1,
    dr2_2,
    dr2_3,
    dr2_4,
    dr2_5,
    dr2_6,
    dr2_7,
    dr2_8,
    dr2_9,
    dr3_1,
    dr3_2,
    dr3_3,
    dr3_4,
    dr3_5,
    dr3_6,
    dr3_7,
    dr3_8,
    dr3_9,
    dr4_1,
    dr4_2,
    dr4_3,
    dr4_4,
    dr4_5,
    dr4_6,
    dr4_7,
    dr4_8,
    dr4_9,
    dr5_1,
    dr5_2,
    dr5_3,
    dr5_4,
    dr5_5,
    dr5_6,
    dr5_7,
    dr5_8,
    dr5_9,
    dr6_1,
    dr6_2,
    dr6_3,
    dr6_4,
    dr6_5,
    dr6_6,
    dr6_7,
    dr6_8,
    dr6_9,
    dr7_1,
    dr7_2,
    dr7_3,
    dr7_4,
    dr7_5,
    dr7_6,
    dr7_7,
    dr7_8,
    dr7_9,
    // data bus
    db0,
    db1,
    db2,
    db3,
    db4,
    db5,
    db6,
    db7,
    // address lines
    reg00,
    reg01,
    reg02,
    reg03,
    reg04,
    reg05,
    reg06,
    reg07,
    reg08,
    reg09,
    reg0A,
    reg0B,
    reg0C,
    reg0D,
    reg0E,
    reg0F,
    reg10,
    reg11,
    reg12,
    reg13,
    reg14,
    reg15,
    reg16,
    reg17,
    reg18,
    reg19,
    reg1A,
    reg1B,
    reg1C,
    // Control reg 3
    ctl3_bit0_in,
    ctl3_bit0_ltc,
    ctl3_bit0_fb,
    ctl3_bit0_inv,
    ctl3_bit0_out,
    ctl3_bit1_in,
    ctl3_bit1_ltc,
    ctl3_bit1_fb,
    ctl3_bit1_inv,
    ctl3_bit1_out,
    ctl3_bit2_in,
    ctl3_bit2_ltc,
    ctl3_bit2_fb,
    ctl3_bit2_inv,
    ctl3_bit2_out,
    ctl3_bit3_in,
    ctl3_bit3_ltc,
    ctl3_bit3_fb,
    ctl3_bit3_inv,
    ctl3_bit3_out,
    ctl3_bit4_in,
    ctl3_bit4_ltc,
    ctl3_bit4_fb,
    ctl3_bit4_inv,
    ctl3_bit4_out,
    ctl3_bit5_in,
    ctl3_bit5_ltc,
    ctl3_bit5_fb,
    ctl3_bit5_inv,
    ctl3_bit5_out,
    ctl3_bit6_in,
    ctl3_bit6_ltc,
    ctl3_bit6_fb,
    ctl3_bit6_inv,
    ctl3_bit6_out,
    ctl3_bit7_in,
    ctl3_bit7_ltc,
    ctl3_bit7_fb,
    ctl3_bit7_inv,
    ctl3_bit7_out,
    // osc reset
    osc3_rst,
    osc3_rst1,
    osc3_rst2,
    osc3_rst3,
    osc3_rst4,
    osc3_rst5,
    osc3_ltc1,
    osc3_ltc2,
    // freq3
    freq3_bit0_in,
    freq3_bit0_ltc,
    freq3_bit0_fb,
    freq3_bit1_in,
    freq3_bit1_ltc,
    freq3_bit1_fb,
    freq3_bit2_in,
    freq3_bit2_ltc,
    freq3_bit2_fb,
    freq3_bit3_in,
    freq3_bit3_ltc,
    freq3_bit3_fb,
    freq3_bit4_in,
    freq3_bit4_ltc,
    freq3_bit4_fb,
    freq3_bit5_in,
    freq3_bit5_ltc,
    freq3_bit5_fb,
    freq3_bit6_in,
    freq3_bit6_ltc,
    freq3_bit6_fb,
    freq3_bit7_in,
    freq3_bit7_ltc,
    freq3_bit7_fb,
    freq3_bit8_in,
    freq3_bit8_ltc,
    freq3_bit8_fb,
    freq3_bit9_in,
    freq3_bit9_ltc,
    freq3_bit9_fb,
    freq3_bit10_in,
    freq3_bit10_ltc,
    freq3_bit10_fb,
    freq3_bit11_in,
    freq3_bit11_ltc,
    freq3_bit11_fb,
    freq3_bit12_in,
    freq3_bit12_ltc,
    freq3_bit12_fb,
    freq3_bit13_in,
    freq3_bit13_ltc,
    freq3_bit13_fb,
    freq3_bit14_in,
    freq3_bit14_ltc,
    freq3_bit14_fb,
    freq3_bit15_in,
    freq3_bit15_ltc,
    freq3_bit15_fb,
    freq3_bit16_in,
    freq3_bit16_ltc,
    freq3_bit16_fb,
    freq3_bit17_in,
    freq3_bit17_ltc,
    freq3_bit17_fb,
    freq3_bit18_in,
    freq3_bit18_ltc,
    freq3_bit18_fb,
    freq3_bit19_in,
    freq3_bit19_ltc,
    freq3_bit19_fb,
    freq3_bit20_in,
    freq3_bit20_ltc,
    freq3_bit20_fb,
    freq3_bit21_in,
    freq3_bit21_ltc,
    freq3_bit21_fb,
    freq3_bit22_in,
    freq3_bit22_ltc,
    freq3_bit22_fb,
    freq3_bit23_in,
    freq3_bit23_ltc,
    freq3_bit23_fb,
    // osc3 bit0 adder
    osc3_bit0_add1,
    osc3_bit0_add2,
    osc3_bit0_add3,
    osc3_bit0_adds,
    osc3_bit0_carry,
    osc3_bit0,
    osc3_bit0_cry1,
    osc3_bit0_cry2,
    osc3_bit0_1,
    osc3_bit0_2,
    osc3_bit0_ltc1,
    osc3_bit0_ltc2,
    // osc3 bit1 adder
    osc3_bit1_add1,
    osc3_bit1_add2,
    osc3_bit1_add3,
    osc3_bit1_adds,
    osc3_bit1_carry,
    osc3_bit1,
    osc3_bit1_cry1,
    osc3_bit1_cry2,
    osc3_bit1_1,
    osc3_bit1_2,
    osc3_bit1_ltc1,
    osc3_bit1_ltc2,
    // osc3 bit2 adder
    osc3_bit2_add1,
    osc3_bit2_add2,
    osc3_bit2_add3,
    osc3_bit2_adds,
    osc3_bit2_carry,
    osc3_bit2,
    osc3_bit2_cry1,
    osc3_bit2_cry2,
    osc3_bit2_1,
    osc3_bit2_2,
    osc3_bit2_ltc1,
    osc3_bit2_ltc2,
    // osc3 bit3 adder
    osc3_bit3_add1,
    osc3_bit3_add2,
    osc3_bit3_add3,
    osc3_bit3_adds,
    osc3_bit3_carry,
    osc3_bit3,
    osc3_bit3_cry1,
    osc3_bit3_cry2,
    osc3_bit3_1,
    osc3_bit3_2,
    osc3_bit3_ltc1,
    osc3_bit3_ltc2,
    // osc3 bit4 adder
    osc3_bit4_add1,
    osc3_bit4_add2,
    osc3_bit4_add3,
    osc3_bit4_adds,
    osc3_bit4_carry,
    osc3_bit4,
    osc3_bit4_cry1,
    osc3_bit4_cry2,
    osc3_bit4_1,
    osc3_bit4_2,
    osc3_bit4_ltc1,
    osc3_bit4_ltc2,
    // osc3 bit5 adder
    osc3_bit5_add1,
    osc3_bit5_add2,
    osc3_bit5_add3,
    osc3_bit5_adds,
    osc3_bit5_carry,
    osc3_bit5,
    osc3_bit5_cry1,
    osc3_bit5_cry2,
    osc3_bit5_1,
    osc3_bit5_2,
    osc3_bit5_ltc1,
    osc3_bit5_ltc2,
    // osc3 bit6 adder
    osc3_bit6_add1,
    osc3_bit6_add2,
    osc3_bit6_add3,
    osc3_bit6_adds,
    osc3_bit6_carry,
    osc3_bit6,
    osc3_bit6_cry1,
    osc3_bit6_cry2,
    osc3_bit6_1,
    osc3_bit6_2,
    osc3_bit6_ltc1,
    osc3_bit6_ltc2,
    // osc3 bit7 adder
    osc3_bit7_add1,
    osc3_bit7_add2,
    osc3_bit7_add3,
    osc3_bit7_adds,
    osc3_bit7_carry,
    osc3_bit7,
    osc3_bit7_cry1,
    osc3_bit7_cry2,
    osc3_bit7_1,
    osc3_bit7_2,
    osc3_bit7_ltc1,
    osc3_bit7_ltc2,
    // osc3 bit8 adder
    osc3_bit8_add1,
    osc3_bit8_add2,
    osc3_bit8_add3,
    osc3_bit8_adds,
    osc3_bit8_carry,
    osc3_bit8,
    osc3_bit8_cry1,
    osc3_bit8_cry2,
    osc3_bit8_1,
    osc3_bit8_2,
    osc3_bit8_ltc1,
    osc3_bit8_ltc2,
    // osc3 bit9 adder
    osc3_bit9_add1,
    osc3_bit9_add2,
    osc3_bit9_add3,
    osc3_bit9_adds,
    osc3_bit9_carry,
    osc3_bit9,
    osc3_bit9_cry1,
    osc3_bit9_cry2,
    osc3_bit9_1,
    osc3_bit9_2,
    osc3_bit9_ltc1,
    osc3_bit9_ltc2,
    // osc3 bit10 adder
    osc3_bit10_add1,
    osc3_bit10_add2,
    osc3_bit10_add3,
    osc3_bit10_adds,
    osc3_bit10_carry,
    osc3_bit10,
    osc3_bit10_cry1,
    osc3_bit10_cry2,
    osc3_bit10_1,
    osc3_bit10_2,
    osc3_bit10_ltc1,
    osc3_bit10_ltc2,
    // osc3 bit11 adder
    osc3_bit11_add1,
    osc3_bit11_add2,
    osc3_bit11_add3,
    osc3_bit11_adds,
    osc3_bit11_carry,
    osc3_bit11,
    osc3_bit11_cry1,
    osc3_bit11_cry2,
    osc3_bit11_1,
    osc3_bit11_2,
    osc3_bit11_ltc1,
    osc3_bit11_ltc2,
    // osc3 bit12 adder
    osc3_bit12_add1,
    osc3_bit12_add2,
    osc3_bit12_add3,
    osc3_bit12_adds,
    osc3_bit12_carry,
    osc3_bit12,
    osc3_bit12_cry1,
    osc3_bit12_cry2,
    osc3_bit12_1,
    osc3_bit12_2,
    osc3_bit12_ltc1,
    osc3_bit12_ltc2,
    // osc3 bit13 adder
    osc3_bit13_add1,
    osc3_bit13_add2,
    osc3_bit13_add3,
    osc3_bit13_adds,
    osc3_bit13_carry,
    osc3_bit13,
    osc3_bit13_cry1,
    osc3_bit13_cry2,
    osc3_bit13_1,
    osc3_bit13_2,
    osc3_bit13_ltc1,
    osc3_bit13_ltc2,
    // osc3 bit14 adder
    osc3_bit14_add1,
    osc3_bit14_add2,
    osc3_bit14_add3,
    osc3_bit14_adds,
    osc3_bit14_carry,
    osc3_bit14,
    osc3_bit14_cry1,
    osc3_bit14_cry2,
    osc3_bit14_1,
    osc3_bit14_2,
    osc3_bit14_ltc1,
    osc3_bit14_ltc2,
    // osc3 bit15 adder
    osc3_bit15_add1,
    osc3_bit15_add2,
    osc3_bit15_add3,
    osc3_bit15_adds,
    osc3_bit15_carry,
    osc3_bit15,
    osc3_bit15_cry1,
    osc3_bit15_cry2,
    osc3_bit15_1,
    osc3_bit15_2,
    osc3_bit15_ltc1,
    osc3_bit15_ltc2,
    // osc3 bit16 adder
    osc3_bit16_add1,
    osc3_bit16_add2,
    osc3_bit16_add3,
    osc3_bit16_adds,
    osc3_bit16_carry,
    osc3_bit16,
    osc3_bit16_cry1,
    osc3_bit16_cry2,
    osc3_bit16_1,
    osc3_bit16_2,
    osc3_bit16_ltc1,
    osc3_bit16_ltc2,
    // osc3 bit17 adder
    osc3_bit17_add1,
    osc3_bit17_add2,
    osc3_bit17_add3,
    osc3_bit17_adds,
    osc3_bit17_carry,
    osc3_bit17,
    osc3_bit17_cry1,
    osc3_bit17_cry2,
    osc3_bit17_1,
    osc3_bit17_2,
    osc3_bit17_ltc1,
    osc3_bit17_ltc2,
    // osc3 bit18 adder
    osc3_bit18_add1,
    osc3_bit18_add2,
    osc3_bit18_add3,
    osc3_bit18_adds,
    osc3_bit18_carry,
    osc3_bit18,
    osc3_bit18_cry1,
    osc3_bit18_cry2,
    osc3_bit18_1,
    osc3_bit18_2,
    osc3_bit18_ltc1,
    osc3_bit18_ltc2,
    // osc3 bit19 adder
    osc3_bit19_add1,
    osc3_bit19_add2,
    osc3_bit19_add3,
    osc3_bit19_adds,
    osc3_bit19_carry,
    osc3_bit19,
    osc3_bit19_cry1,
    osc3_bit19_cry2,
    osc3_bit19_1,
    osc3_bit19_2,
    osc3_bit19_ltc1,
    osc3_bit19_ltc2,
    // osc3 bit20 adder
    osc3_bit20_add1,
    osc3_bit20_add2,
    osc3_bit20_add3,
    osc3_bit20_adds,
    osc3_bit20_carry,
    osc3_bit20,
    osc3_bit20_cry1,
    osc3_bit20_cry2,
    osc3_bit20_1,
    osc3_bit20_2,
    osc3_bit20_ltc1,
    osc3_bit20_ltc2,
    // osc3 bit21 adder
    osc3_bit21_add1,
    osc3_bit21_add2,
    osc3_bit21_add3,
    osc3_bit21_adds,
    osc3_bit21_carry,
    osc3_bit21,
    osc3_bit21_cry1,
    osc3_bit21_cry2,
    osc3_bit21_1,
    osc3_bit21_2,
    osc3_bit21_ltc1,
    osc3_bit21_ltc2,
    // osc3 bit22 adder
    osc3_bit22_add1,
    osc3_bit22_add2,
    osc3_bit22_add3,
    osc3_bit22_adds,
    osc3_bit22_carry,
    osc3_bit22,
    osc3_bit22_cry1,
    osc3_bit22_cry2,
    osc3_bit22_1,
    osc3_bit22_2,
    osc3_bit22_ltc1,
    osc3_bit22_ltc2,
    // osc3 bit23 adder
    osc3_bit23_add1,
    osc3_bit23_add2,
    osc3_bit23_add3,
    osc3_bit23_adds,
    osc3_bit23_carry,
    osc3_bit23,
    osc3_bit23_cry1,
    osc3_bit23_cry2,
    osc3_bit23_1,
    osc3_bit23_2,
    osc3_bit23_ltc1,
    osc3_bit23_ltc2,
    // pw3
    pw3_bit0_in,
    pw3_bit0_ltc,
    pw3_bit0_fb,
    pw3_bit1_in,
    pw3_bit1_ltc,
    pw3_bit1_fb,
    pw3_bit2_in,
    pw3_bit2_ltc,
    pw3_bit2_fb,
    pw3_bit3_in,
    pw3_bit3_ltc,
    pw3_bit3_fb,
    pw3_bit4_in,
    pw3_bit4_ltc,
    pw3_bit4_fb,
    pw3_bit5_in,
    pw3_bit5_ltc,
    pw3_bit5_fb,
    pw3_bit6_in,
    pw3_bit6_ltc,
    pw3_bit6_fb,
    pw3_bit7_in,
    pw3_bit7_ltc,
    pw3_bit7_fb,
    pw3_bit8_in,
    pw3_bit8_ltc,
    pw3_bit8_fb,
    pw3_bit9_in,
    pw3_bit9_ltc,
    pw3_bit9_fb,
    pw3_bit10_in,
    pw3_bit10_ltc,
    pw3_bit10_fb,
    pw3_bit11_in,
    pw3_bit11_ltc,
    pw3_bit11_fb,
    // pw3 adder
    pw3_add0_1,
    pw3_add0_2,
    pw3_add0_cout,
    pw3_add1_1,
    pw3_add1_2,
    pw3_add1_3,
    pw3_add1_cout,
    pw3_add2_1,
    pw3_add2_2,
    pw3_add2_cout,
    pw3_add3_1,
    pw3_add3_2,
    pw3_add3_3,
    pw3_add3_cout,
    pw3_add4_1,
    pw3_add4_2,
    pw3_add4_cout,
    pw3_add5_1,
    pw3_add5_2,
    pw3_add5_3,
    pw3_add5_cout,
    pw3_add6_1,
    pw3_add6_2,
    pw3_add6_cout,
    pw3_add7_1,
    pw3_add7_2,
    pw3_add7_3,
    pw3_add7_cout,
    pw3_add8_1,
    pw3_add8_2,
    pw3_add8_cout,
    pw3_add9_1,
    pw3_add9_2,
    pw3_add9_3,
    pw3_add9_cout,
    pw3_add10_1,
    pw3_add10_2,
    pw3_add10_cout,
    pw3_add11_1,
    pw3_add11_2,
    pw3_add11_3,
    pw3_add11_cout,
    // Pulse
    pul3_ltc1,
    pul3_ltc2,
    pul3_1,
    pul3_2,
    pul_out,
    // Triangle XOR circuit selector
    tri3_1,
    tri3_2,
    tri3_3,
    tri3_4,
    tri3_xor,
    // Triangle
#ifndef MOS8580
    tri3_bit0_1,
    tri3_bit0_2,
    tri3_bit0_out,
    tri3_bit1_1,
    tri3_bit1_2,
    tri3_bit1_out,
    tri3_bit2_1,
    tri3_bit2_2,
    tri3_bit2_out,
    tri3_bit3_1,
    tri3_bit3_2,
    tri3_bit3_out,
    tri3_bit4_1,
    tri3_bit4_2,
    tri3_bit4_out,
    tri3_bit5_1,
    tri3_bit5_2,
    tri3_bit5_out,
    tri3_bit6_1,
    tri3_bit6_2,
    tri3_bit6_out,
    tri3_bit7_1,
    tri3_bit7_2,
    tri3_bit7_out,
    tri3_bit8_1,
    tri3_bit8_2,
    tri3_bit8_out,
    tri3_bit9_1,
    tri3_bit9_2,
    tri3_bit9_out,
    tri3_bit10_1,
    tri3_bit10_2,
    tri3_bit10_out,
#else
    tri3_bit0_1,
    tri3_bit0_2,
    tri3_bit0_3,
    tri3_bit0_4,
    tri3_bit0_5,
    tri3_bit0_ltc,
    tri3_bit0_out,
    tri3_bit1_1,
    tri3_bit1_2,
    tri3_bit1_3,
    tri3_bit1_4,
    tri3_bit1_5,
    tri3_bit1_ltc,
    tri3_bit1_out,
    tri3_bit2_1,
    tri3_bit2_2,
    tri3_bit2_3,
    tri3_bit2_4,
    tri3_bit2_5,
    tri3_bit2_ltc,
    tri3_bit2_out,
    tri3_bit3_1,
    tri3_bit3_2,
    tri3_bit3_3,
    tri3_bit3_4,
    tri3_bit3_5,
    tri3_bit3_ltc,
    tri3_bit3_out,
    tri3_bit4_1,
    tri3_bit4_2,
    tri3_bit4_3,
    tri3_bit4_4,
    tri3_bit4_5,
    tri3_bit4_ltc,
    tri3_bit4_out,
    tri3_bit5_1,
    tri3_bit5_2,
    tri3_bit5_3,
    tri3_bit5_4,
    tri3_bit5_5,
    tri3_bit5_ltc,
    tri3_bit5_out,
    tri3_bit6_1,
    tri3_bit6_2,
    tri3_bit6_3,
    tri3_bit6_4,
    tri3_bit6_5,
    tri3_bit6_ltc,
    tri3_bit6_out,
    tri3_bit7_1,
    tri3_bit7_2,
    tri3_bit7_3,
    tri3_bit7_4,
    tri3_bit7_5,
    tri3_bit7_ltc,
    tri3_bit7_out,
    tri3_bit8_1,
    tri3_bit8_2,
    tri3_bit8_3,
    tri3_bit8_4,
    tri3_bit8_5,
    tri3_bit8_ltc,
    tri3_bit8_out,
    tri3_bit9_1,
    tri3_bit9_2,
    tri3_bit9_3,
    tri3_bit9_4,
    tri3_bit9_5,
    tri3_bit9_ltc,
    tri3_bit9_out,
    tri3_bit10_1,
    tri3_bit10_2,
    tri3_bit10_3,
    tri3_bit10_4,
    tri3_bit10_5,
    tri3_bit10_ltc,
    tri3_bit10_out,
    // Sawtooth bit23
    saw3_bit23_1,
    saw3_bit23,
    saw3_bit23_ltc,
#endif
    // Noise clock
    noi3_clk_ltc1,
    noi3_clk_ltc2,
    noi3_clk_ltc3,
    noi3_clk_ltc4,
    noi3_clk1,
    noi3_clk2,
    noi3_clk3,
    noi3_clk4,
    noi3_clk,
    //
    noi3_clk10,
    noi3_clk_c1,
    noi3_clk_c2,
    noi3_clk_lc,
    noi3_clk_ltc10,
    // Noise lfsr
    noi3_bit0_1,
    noi3_bit0_out,
    noi3_bit0_ltc1,
    noi3_bit0_ltc2,
    noi3_bit0_ltc3,
    noi3_bit1_1,
    noi3_bit1_out,
    noi3_bit1_ltc1,
    noi3_bit1_ltc2,
    noi3_bit1_ltc3,
    noi3_bit2_1,
    noi3_bit2_out,
    noi3_bit2_ltc1,
    noi3_bit2_ltc2,
    noi3_bit2_ltc3,
    noi3_bit3_1,
    noi3_bit3_out,
    noi3_bit3_ltc1,
    noi3_bit3_ltc2,
    noi3_bit3_ltc3,
    noi3_bit4_1,
    noi3_bit4_out,
    noi3_bit4_ltc1,
    noi3_bit4_ltc2,
    noi3_bit4_ltc3,
    noi3_bit5_1,
    noi3_bit5_out,
    noi3_bit5_ltc1,
    noi3_bit5_ltc2,
    noi3_bit5_ltc3,
    noi3_bit6_1,
    noi3_bit6_out,
    noi3_bit6_ltc1,
    noi3_bit6_ltc2,
    noi3_bit6_ltc3,
    noi3_bit7_1,
    noi3_bit7_out,
    noi3_bit7_ltc1,
    noi3_bit7_ltc2,
    noi3_bit7_ltc3,
    noi3_bit8_1,
    noi3_bit8_out,
    noi3_bit8_ltc1,
    noi3_bit8_ltc2,
    noi3_bit8_ltc3,
    noi3_bit9_1,
    noi3_bit9_out,
    noi3_bit9_ltc1,
    noi3_bit9_ltc2,
    noi3_bit9_ltc3,
    noi3_bit10_1,
    noi3_bit10_out,
    noi3_bit10_ltc1,
    noi3_bit10_ltc2,
    noi3_bit10_ltc3,
    noi3_bit11_1,
    noi3_bit11_out,
    noi3_bit11_ltc1,
    noi3_bit11_ltc2,
    noi3_bit11_ltc3,
    noi3_bit12_1,
    noi3_bit12_out,
    noi3_bit12_ltc1,
    noi3_bit12_ltc2,
    noi3_bit12_ltc3,
    noi3_bit13_1,
    noi3_bit13_out,
    noi3_bit13_ltc1,
    noi3_bit13_ltc2,
    noi3_bit13_ltc3,
    noi3_bit14_1,
    noi3_bit14_out,
    noi3_bit14_ltc1,
    noi3_bit14_ltc2,
    noi3_bit14_ltc3,
    noi3_bit15_1,
    noi3_bit15_out,
    noi3_bit15_ltc1,
    noi3_bit15_ltc2,
    noi3_bit15_ltc3,
    noi3_bit16_1,
    noi3_bit16_out,
    noi3_bit16_ltc1,
    noi3_bit16_ltc2,
    noi3_bit16_ltc3,
    noi3_bit17_1,
    noi3_bit17_out,
    noi3_bit17_ltc1,
    noi3_bit17_ltc2,
    noi3_bit17_ltc3,
    noi3_bit18_1,
    noi3_bit18_out,
    noi3_bit18_ltc1,
    noi3_bit18_ltc2,
    noi3_bit18_ltc3,
    noi3_bit19_1,
    noi3_bit19_out,
    noi3_bit19_ltc1,
    noi3_bit19_ltc2,
    noi3_bit19_ltc3,
    noi3_bit20_1,
    noi3_bit20_out,
    noi3_bit20_ltc1,
    noi3_bit20_ltc2,
    noi3_bit20_ltc3,
    noi3_bit21_1,
    noi3_bit21_out,
    noi3_bit21_ltc1,
    noi3_bit21_ltc2,
    noi3_bit21_ltc3,
    noi3_bit22_1,
    noi3_bit22_out,
    noi3_bit22_ltc1,
    noi3_bit22_ltc2,
    noi3_bit22_ltc3,
    noi3_bit23_1,
    noi3_bit23_out,
    noi3_bit23_ltc1,
    noi3_bit23_ltc2,
    noi3_bit23_ltc3,
    // Noise XOR
    noi3_xor_ltc1,
    noi3_xor_ltc2,
    noi3_xor_1,
    noi3_xor_2,
    noi3_xor_3,
    noi3_xor_4,
    noi3_xor_out,
    // Waveform selector
    voi3_bit0,
    voi3_bit1,
    voi3_bit2,
    voi3_bit3,
    voi3_bit4,
    voi3_bit5,
    voi3_bit6,
    voi3_bit7,
    voi3_bit8,
    voi3_bit9,
    voi3_bit10,
    voi3_bit11,
    // Waveform output
    wav3_bit0_1,
    wav3_bit0_2,
    wav3_bit0_out,
    wav3_bit1_1,
    wav3_bit1_2,
    wav3_bit1_out,
    wav3_bit2_1,
    wav3_bit2_2,
    wav3_bit2_out,
    wav3_bit3_1,
    wav3_bit3_2,
    wav3_bit3_out,
    wav3_bit4_1,
    wav3_bit4_2,
    wav3_bit4_out,
    wav3_bit5_1,
    wav3_bit5_2,
    wav3_bit5_out,
    wav3_bit6_1,
    wav3_bit6_2,
    wav3_bit6_out,
    wav3_bit7_1,
    wav3_bit7_2,
    wav3_bit7_out,
    wav3_bit8_1,
    wav3_bit8_2,
    wav3_bit8_out,
    wav3_bit9_1,
    wav3_bit9_2,
    wav3_bit9_out,
    wav3_bit10_1,
    wav3_bit10_2,
    wav3_bit10_out,
    wav3_bit11_1,
    wav3_bit11_2,
    wav3_bit11_out,
    // OSC3 register
    reg_osc3_bit0_ltc1,
    reg_osc3_bit0_1,
    reg_osc3_bit0_2,
    reg_osc3_bit0_3,
    reg_osc3_bit1_ltc1,
    reg_osc3_bit1_1,
    reg_osc3_bit1_2,
    reg_osc3_bit1_3,
    reg_osc3_bit2_ltc1,
    reg_osc3_bit2_1,
    reg_osc3_bit2_2,
    reg_osc3_bit2_3,
    reg_osc3_bit3_ltc1,
    reg_osc3_bit3_1,
    reg_osc3_bit3_2,
    reg_osc3_bit3_3,
    reg_osc3_bit4_ltc1,
    reg_osc3_bit4_1,
    reg_osc3_bit4_2,
    reg_osc3_bit4_3,
    reg_osc3_bit5_ltc1,
    reg_osc3_bit5_1,
    reg_osc3_bit5_2,
    reg_osc3_bit5_3,
    reg_osc3_bit6_ltc1,
    reg_osc3_bit6_1,
    reg_osc3_bit6_2,
    reg_osc3_bit6_3,
    reg_osc3_bit7_ltc1,
    reg_osc3_bit7_1,
    reg_osc3_bit7_2,
    reg_osc3_bit7_3,

    // Envelope

    // counting direction
    env3_cd01,
    env3_cd02,
    env3_cd03,
    env3_cd04,
    env3_cd05,
    env3_cd06,
    env3_cd07,
    env3_cd10,
    env3_cd11,
    env3_cd12,
    env3_cd13,
    env3_cd14,
    env3_cd15,
    env3_gate_cur,
    env3_gate_prev_inv,
    env3_cnt_dir,
    
    env3_cd20,
    env3_cd21,
    env3_cd22,
    env3_cd23,
    env3_cd24,
    env3_cd25,
    env3_cd26,
    env3_cd27,
    env3_cd28,
    env3_cd30,
    env3_cd31,
    env3_cd40,
    env3_cd41,
    env3_cd42,
    env3_cd50,
    env3_r0,
    env3_cnt_clk_inv,
    env3_cnt_clk,
    env3_cnt_up,
    env3_cnt_down,

    env3_ce01,
    env3_ce02,
    env3_ce03,
    env3_ce04,
    env3_ce05,
    env3_ce06,
    env3_ce07,
    env3_ce08,
    env3_ce10,
    env3_ce11,
    env3_ce12,
    env3_ce13,
    env3_cnt_ena,
    env3_cnt_cry0,
    // counter
    env3_bit0_Cout,
    env3_bit0_add1,
    env3_bit0_add2,
    env3_bit0_add3,
    env3_bit0_add4,
    env3_bit0_add5,
    env3_bit0_add6,
    env3_bit0_xor1,
    env3_bit0_xor2,
    env3_bit0_cnt,
    env3_bit0_ltc,
    env3_bit0_out,
    env3_bit0_out_inv,
    env3_bit1_Cout,
    env3_bit1_add1,
    env3_bit1_add2,
    env3_bit1_add3,
    env3_bit1_add4,
    env3_bit1_add5,
    env3_bit1_add6,
    env3_bit1_add7,
    env3_bit1_xor1,
    env3_bit1_xor2,
    env3_bit1_cnt,
    env3_bit1_ltc,
    env3_bit1_out,
    env3_bit1_out_inv,
    env3_bit2_Cout,
    env3_bit2_add1,
    env3_bit2_add2,
    env3_bit2_add3,
    env3_bit2_add4,
    env3_bit2_add5,
    env3_bit2_add6,
    env3_bit2_xor1,
    env3_bit2_xor2,
    env3_bit2_cnt,
    env3_bit2_ltc,
    env3_bit2_out,
    env3_bit2_out_inv,
    env3_bit3_Cout,
    env3_bit3_add1,
    env3_bit3_add2,
    env3_bit3_add3,
    env3_bit3_add4,
    env3_bit3_add5,
    env3_bit3_add6,
    env3_bit3_add7,
    env3_bit3_xor1,
    env3_bit3_xor2,
    env3_bit3_cnt,
    env3_bit3_ltc,
    env3_bit3_out,
    env3_bit3_out_inv,
    env3_bit4_Cout,
    env3_bit4_add1,
    env3_bit4_add2,
    env3_bit4_add3,
    env3_bit4_add4,
    env3_bit4_add5,
    env3_bit4_add6,
    env3_bit4_xor1,
    env3_bit4_xor2,
    env3_bit4_cnt,
    env3_bit4_ltc,
    env3_bit4_out,
    env3_bit4_out_inv,
    env3_bit5_Cout,
    env3_bit5_add1,
    env3_bit5_add2,
    env3_bit5_add3,
    env3_bit5_add4,
    env3_bit5_add5,
    env3_bit5_add6,
    env3_bit5_add7,
    env3_bit5_xor1,
    env3_bit5_xor2,
    env3_bit5_cnt,
    env3_bit5_ltc,
    env3_bit5_out,
    env3_bit5_out_inv,
    env3_bit6_Cout,
    env3_bit6_add1,
    env3_bit6_add2,
    env3_bit6_add3,
    env3_bit6_add4,
    env3_bit6_add5,
    env3_bit6_add6,
    env3_bit6_xor1,
    env3_bit6_xor2,
    env3_bit6_cnt,
    env3_bit6_ltc,
    env3_bit6_out,
    env3_bit6_out_inv,
    env3_bit7_Cout,
    env3_bit7_add1,
    env3_bit7_add2,
    env3_bit7_add3,
    env3_bit7_add4,
    env3_bit7_add5,
    env3_bit7_add6,
    env3_bit7_add7,
    env3_bit7_xor1,
    env3_bit7_xor2,
    env3_bit7_cnt,
    env3_bit7_ltc,
    env3_bit7_out,
    env3_bit7_out_inv,

    env3_0x00,
    env3_0x06,
    env3_0x0E,
    env3_0x1A,
    env3_0x36,
    env3_0x5D,
    env3_0xFF,

    // ADSR gates
    env3_dcy_gate,
    env3_rel_gate,
    // ADSR registers
    env3_d0_1,
    env3_d0_2,
    env3_d0_3,
    env3_d0_4,
    env3_d0_5,
    env3_d1_1,
    env3_d1_2,
    env3_d1_3,
    env3_d1_4,
    env3_d1_5,
    env3_d2_1,
    env3_d2_2,
    env3_d2_3,
    env3_d2_4,
    env3_d2_5,
    env3_d3_1,
    env3_d3_2,
    env3_d3_3,
    env3_d3_4,
    env3_d3_5,
    env3_a0_1,
    env3_a0_2,
    env3_a0_3,
    env3_a0_4,
    env3_a0_5,
    env3_a1_1,
    env3_a1_2,
    env3_a1_3,
    env3_a1_4,
    env3_a1_5,
    env3_a2_1,
    env3_a2_2,
    env3_a2_3,
    env3_a2_4,
    env3_a2_5,
    env3_a3_1,
    env3_a3_2,
    env3_a3_3,
    env3_a3_4,
    env3_a3_5,
    env3_r0_1,
    env3_r0_2,
    env3_r0_3,
    env3_r0_4,
    env3_r0_5,
    env3_r1_1,
    env3_r1_2,
    env3_r1_3,
    env3_r1_4,
    env3_r1_5,
    env3_r2_1,
    env3_r2_2,
    env3_r2_3,
    env3_r2_4,
    env3_r2_5,
    env3_r3_1,
    env3_r3_2,
    env3_r3_3,
    env3_r3_4,
    env3_r3_5,
    env3_s0_1,
    env3_s0_2,
    env3_s0_3,
    env3_s0_out,
    env3_s0_5,
    env3_s1_1,
    env3_s1_2,
    env3_s1_3,
    env3_s1_out,
    env3_s1_5,
    env3_s2_1,
    env3_s2_2,
    env3_s2_3,
    env3_s2_out,
    env3_s2_5,
    env3_s3_1,
    env3_s3_2,
    env3_s3_3,
    env3_s3_out,
    env3_s3_5,

    env3_adr0_out,
    env3_adr1_out,
    env3_adr2_out,
    env3_adr3_out,
    // ADR to LUT
    env3_adr_00_inv,
    env3_adr_00_out,
    env3_adr_01_inv,
    env3_adr_01_out,
    env3_adr_02_inv,
    env3_adr_02_out,
    env3_adr_03_inv,
    env3_adr_03_out,
    // sustain comparator
    env3_cnt_sus,
    env3_bit0_cmp01,
    env3_bit0_cmp02,
    env3_bit0_cmp03,
    env3_bit0_cmp04,
    env3_bit1_cmp01,
    env3_bit1_cmp02,
    env3_bit1_cmp03,
    env3_bit1_cmp04,
    env3_bit2_cmp01,
    env3_bit2_cmp02,
    env3_bit2_cmp03,
    env3_bit2_cmp04,
    env3_bit3_cmp01,
    env3_bit3_cmp02,
    env3_bit3_cmp03,
    env3_bit3_cmp04,
    env3_bit4_cmp01,
    env3_bit4_cmp02,
    env3_bit4_cmp03,
    env3_bit4_cmp04,
    env3_bit5_cmp01,
    env3_bit5_cmp02,
    env3_bit5_cmp03,
    env3_bit5_cmp04,
    env3_bit6_cmp01,
    env3_bit6_cmp02,
    env3_bit6_cmp03,
    env3_bit6_cmp04,
    env3_bit7_cmp01,
    env3_bit7_cmp02,
    env3_bit7_cmp03,
    env3_bit7_cmp04,
    // fixpoint found
    env3_fixpoint,

    env3_ff0_fix,
    env3_ff0_sel,
    env3_ff0_X,
    env3_ff0_Y,
    env3_ff0_Z,
    env3_ff1_fix,
    env3_ff1_sel,
    env3_ff1_X,
    env3_ff1_Y,
    env3_ff1_Z,
    env3_ff2_fix,
    env3_ff2_sel,
    env3_ff2_X,
    env3_ff2_Y,
    env3_ff2_Z,
    env3_ff3_fix,
    env3_ff3_sel,
    env3_ff3_X,
    env3_ff3_Y,
    env3_ff3_Z,
    env3_ff4_fix,
    env3_ff4_sel,
    env3_ff4_X,
    env3_ff4_Y,
    env3_ff4_Z,
    // LFSR 15
    env3_lfsrA_fbk01,
    env3_lfsrA_fbk02,
    env3_lfsrA_fbk_out,

    env3_lfsrA_bit00_01,
    env3_lfsrA_bit00_02,
    env3_lfsrA_bit00_03,
    env3_lfsrA_bit00_val,
    env3_lfsrA_bit00_out,
    env3_lfsrA_bit00_out_inv,
    env3_lfsrA_bit01_01,
    env3_lfsrA_bit01_02,
    env3_lfsrA_bit01_03,
    env3_lfsrA_bit01_val,
    env3_lfsrA_bit01_out,
    env3_lfsrA_bit01_out_inv,
    env3_lfsrA_bit02_01,
    env3_lfsrA_bit02_02,
    env3_lfsrA_bit02_03,
    env3_lfsrA_bit02_val,
    env3_lfsrA_bit02_out,
    env3_lfsrA_bit02_out_inv,
    env3_lfsrA_bit03_01,
    env3_lfsrA_bit03_02,
    env3_lfsrA_bit03_03,
    env3_lfsrA_bit03_val,
    env3_lfsrA_bit03_out,
    env3_lfsrA_bit03_out_inv,
    env3_lfsrA_bit04_01,
    env3_lfsrA_bit04_02,
    env3_lfsrA_bit04_03,
    env3_lfsrA_bit04_val,
    env3_lfsrA_bit04_out,
    env3_lfsrA_bit04_out_inv,
    env3_lfsrA_bit05_01,
    env3_lfsrA_bit05_02,
    env3_lfsrA_bit05_03,
    env3_lfsrA_bit05_val,
    env3_lfsrA_bit05_out,
    env3_lfsrA_bit05_out_inv,
    env3_lfsrA_bit06_01,
    env3_lfsrA_bit06_02,
    env3_lfsrA_bit06_03,
    env3_lfsrA_bit06_val,
    env3_lfsrA_bit06_out,
    env3_lfsrA_bit06_out_inv,
    env3_lfsrA_bit07_01,
    env3_lfsrA_bit07_02,
    env3_lfsrA_bit07_03,
    env3_lfsrA_bit07_val,
    env3_lfsrA_bit07_out,
    env3_lfsrA_bit07_out_inv,
    env3_lfsrA_bit08_01,
    env3_lfsrA_bit08_02,
    env3_lfsrA_bit08_03,
    env3_lfsrA_bit08_val,
    env3_lfsrA_bit08_out,
    env3_lfsrA_bit08_out_inv,
    env3_lfsrA_bit09_01,
    env3_lfsrA_bit09_02,
    env3_lfsrA_bit09_03,
    env3_lfsrA_bit09_val,
    env3_lfsrA_bit09_out,
    env3_lfsrA_bit09_out_inv,
    env3_lfsrA_bit10_01,
    env3_lfsrA_bit10_02,
    env3_lfsrA_bit10_03,
    env3_lfsrA_bit10_val,
    env3_lfsrA_bit10_out,
    env3_lfsrA_bit10_out_inv,
    env3_lfsrA_bit11_01,
    env3_lfsrA_bit11_02,
    env3_lfsrA_bit11_03,
    env3_lfsrA_bit11_val,
    env3_lfsrA_bit11_out,
    env3_lfsrA_bit11_out_inv,
    env3_lfsrA_bit12_01,
    env3_lfsrA_bit12_02,
    env3_lfsrA_bit12_03,
    env3_lfsrA_bit12_val,
    env3_lfsrA_bit12_out,
    env3_lfsrA_bit12_out_inv,
    env3_lfsrA_bit13_01,
    env3_lfsrA_bit13_02,
    env3_lfsrA_bit13_03,
    env3_lfsrA_bit13_val,
    env3_lfsrA_bit13_out,
    env3_lfsrA_bit13_out_inv,
    env3_lfsrA_bit14_01,
    env3_lfsrA_bit14_02,
    env3_lfsrA_bit14_03,
    env3_lfsrA_bit14_val,
    env3_lfsrA_bit14_out,
    env3_lfsrA_bit14_out_inv,
    // reset
    env3_lfsrA_rst01,
    env3_lfsrA_rst02,
    env3_lfsrA_rst03,
    env3_lfsrA_rst04,
    env3_lfsrA_rst05,
    env3_lfsrA_rst_A,
    env3_lfsrA_rst_B,
    // LUT
    env3_0x500E,
    env3_0x0A93,
    env3_0x3800,
    env3_0x7625,
    env3_0x6755,
    env3_0x77E2,
    env3_0x20C0,
    env3_0x3840,
    env3_0x0330,
    env3_0x59B8,
    env3_0x003C,
    env3_0x1848,
    env3_0x0006,
    env3_0x0222,
    env3_0x7F00,
    env3_0x1212,

    // LFSR 5
    env3_lfsrB_fbk01,
    env3_lfsrB_fbk02,
    env3_lfsrB_fbk_out,

    env3_lfsrB_bit00_01,
    env3_lfsrB_bit00_02,
    env3_lfsrB_bit00_03,
    env3_lfsrB_bit00_val,
    env3_lfsrB_bit00_out,
    env3_lfsrB_bit00_out_inv,
    env3_lfsrB_bit01_01,
    env3_lfsrB_bit01_02,
    env3_lfsrB_bit01_03,
    env3_lfsrB_bit01_val,
    env3_lfsrB_bit01_out,
    env3_lfsrB_bit01_out_inv,
    env3_lfsrB_bit02_01,
    env3_lfsrB_bit02_02,
    env3_lfsrB_bit02_03,
    env3_lfsrB_bit02_val,
    env3_lfsrB_bit02_out,
    env3_lfsrB_bit02_out_inv,
    env3_lfsrB_bit03_01,
    env3_lfsrB_bit03_02,
    env3_lfsrB_bit03_03,
    env3_lfsrB_bit03_val,
    env3_lfsrB_bit03_out,
    env3_lfsrB_bit03_out_inv,
    env3_lfsrB_bit04_01,
    env3_lfsrB_bit04_02,
    env3_lfsrB_bit04_03,
    env3_lfsrB_bit04_val,
    env3_lfsrB_bit04_out,
    env3_lfsrB_bit04_out_inv,
    // reset
    env3_lfsrB_rst01,
    env3_lfsrB_rst02,
    env3_lfsrB_rst03,
    env3_lfsrB_rst04,
    env3_lfsrB_rst05,
    env3_lfsrB_rst,
    env3_lfsrB_rst_rel,
    // clock
    env3_lfsrB_clk01,
    env3_lfsrB_clk02,
    env3_lfsrB_clk03,
    env3_lfsrB_clk04,
    env3_lfsrB_clk_shift,
    env3_lfsrB_clk_hold,
    // LUT
    env3_0x1B,
    env3_0x0F,
    env3_0x11,
    env3_0x08,
    env3_0x1C,

    // ENV3 register
    reg_env3_bit0_ltc1,
    reg_env3_bit0_1,
    reg_env3_bit0_2,
    reg_env3_bit0_3,
    reg_env3_bit1_ltc1,
    reg_env3_bit1_1,
    reg_env3_bit1_2,
    reg_env3_bit1_3,
    reg_env3_bit2_ltc1,
    reg_env3_bit2_1,
    reg_env3_bit2_2,
    reg_env3_bit2_3,
    reg_env3_bit3_ltc1,
    reg_env3_bit3_1,
    reg_env3_bit3_2,
    reg_env3_bit3_3,
    reg_env3_bit4_ltc1,
    reg_env3_bit4_1,
    reg_env3_bit4_2,
    reg_env3_bit4_3,
    reg_env3_bit5_ltc1,
    reg_env3_bit5_1,
    reg_env3_bit5_2,
    reg_env3_bit5_3,
    reg_env3_bit6_ltc1,
    reg_env3_bit6_1,
    reg_env3_bit6_2,
    reg_env3_bit6_3,
    reg_env3_bit7_ltc1,
    reg_env3_bit7_1,
    reg_env3_bit7_2,
    reg_env3_bit7_3,

    // Aliases
    Vdd = Vcc,
    ctl3_gate  = ctl3_bit0_out,
    ctl3_sync  = ctl3_bit1_out,
    ctl3_ring  = ctl3_bit2_out,
    ctl3_test  = ctl3_bit3_out,
    ctl3_tri   = ctl3_bit4_out,
    ctl3_saw   = ctl3_bit5_out,
    ctl3_pulse = ctl3_bit6_out,
    ctl3_noise = ctl3_bit7_out,
    v2_bit23 = GND, // TODO remove

    env3_r1_inv = env3_cd01,
    env3_atk_gate = env3_r0,
};

/*
 * Every node can either be neutral, or be a pullup, the latter means
 * that the node will behave as if it was connected to VCC whenever
 * the path through this node is otherwise floating, i.e. not connected
 * to VCC or GND (or an external pulldown).
 *
 * http://www.pagetable.com?p=401
 */

BOOL
netlist_6581_node_is_pullup[] = {
    // power
    0, 0, 0,
    // clock
    0,
#ifndef MOS8580
    1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1,
#else
    1, 1, 1, 0,
    1, 0, 1, 0, 1, 0, 0,
    1, 0, 1, 0, 1, 0, 0,
#endif    
    0, 0,
#ifndef MOS8580
    0, 0,
#else
    1, 1,
#endif
    // reset
    0, 1, 0, 1, 0, 1,
    // cs/rw
    0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0,
    // address pins
    0, 0, 0, 0, 0,
    // address
    1, 0, 1, 0, 1, 0, // bit0
    1, 0, 1, 0, 1, 0, // bit1
    1, 0, 1, 0, 1, 0, // bit2
    1, 0, 1, 0, 1, 0, // bit3
    1, 0, 1, 0, 1, 0, // bit4
    // address bus
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1,
    // data pins
    0, 0, 0, 0, 0, 0, 0, 0,
    // data write
    1, 0, 1, 1, 1, 1, // bit0
    1, 0, 1, 1, 1, 1, // bit1
    1, 0, 1, 1, 1, 1, // bit2
    1, 0, 1, 1, 1, 1, // bit3
    1, 0, 1, 1, 1, 1, // bit4
    1, 0, 1, 1, 1, 1, // bit5
    1, 0, 1, 1, 1, 1, // bit6
    1, 0, 1, 1, 1, 1, // bit7
    // data read
    1, 1, 1, 0, 1, 1, 1, 0, 0, // bit0
    1, 1, 1, 0, 1, 1, 1, 0, 0, // bit1
    1, 1, 1, 0, 1, 1, 1, 0, 0, // bit2
    1, 1, 1, 0, 1, 1, 1, 0, 0, // bit3
    1, 1, 1, 0, 1, 1, 1, 0, 0, // bit4
    1, 1, 1, 0, 1, 1, 1, 0, 0, // bit5
    1, 1, 1, 0, 1, 1, 1, 0, 0, // bit6
    1, 1, 1, 0, 1, 1, 1, 0, 0, // bit7
    // data bus
    0, 0, 0, 0, 0, 0, 0, 0,
    // address lines
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0,
    // Control reg 3
    0, 1, 1, 0, 1, // bit0
    0, 1, 1, 0, 1, // bit1
    0, 1, 1, 0, 1, // bit2
    0, 1, 1, 0, 1, // bit3
    0, 1, 1, 0, 1, // bit4
    0, 1, 1, 0, 1, // bit5
    0, 1, 1, 0, 1, // bit6
    0, 1, 1, 0, 1, // bit7
    // osc reset
    1, 0, 1, 1, 1, 1, 0, 0,
    // freq3
    0, 1, 1, // bit0
    0, 1, 1, // bit1
    0, 1, 1, // bit2
    0, 1, 1, // bit3
    0, 1, 1, // bit4
    0, 1, 1, // bit5
    0, 1, 1, // bit6
    0, 1, 1, // bit7
    0, 1, 1, // bit8
    0, 1, 1, // bit9
    0, 1, 1, // bit10
    0, 1, 1, // bit11
    0, 1, 1, // bit12
    0, 1, 1, // bit13
    0, 1, 1, // bit14
    0, 1, 1, // bit15
    0, 1, 1, // bit16
    0, 1, 1, // bit17
    0, 1, 1, // bit18
    0, 1, 1, // bit19
    0, 1, 1, // bit20
    0, 1, 1, // bit21
    0, 1, 1, // bit22
    0, 1, 1, // bit23
    // osc3 adder
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit0
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit1
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit2
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit3
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit4
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit5
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit6
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit7
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit8
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit9
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit10
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit11
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit12
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit13
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit14
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit15
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit16
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit17
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit18
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit19
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit20
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit21
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit22
    0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, // bit23
    // pw3
    0, 1, 1, // bit0
    0, 1, 1, // bit1
    0, 1, 1, // bit2
    0, 1, 1, // bit3
    0, 1, 1, // bit4
    0, 1, 1, // bit5
    0, 1, 1, // bit6
    0, 1, 1, // bit7
    0, 1, 1, // bit8
    0, 1, 1, // bit9
    0, 1, 1, // bit10
    0, 1, 1, // bit11
    // pw3 adder
    0, 0, 1,    // bit0
    0, 0, 1, 1, // bit1
    0, 0, 1,    // bit2
    0, 0, 1, 1, // bit3
    0, 0, 1,    // bit4
    0, 0, 1, 1, // bit5
    0, 0, 1,    // bit6
    0, 0, 1, 1, // bit7
    0, 0, 1,    // bit8
    0, 0, 1, 1, // bit9
    0, 0, 1,    // bit10
    0, 0, 1, 1, // bit11
    // Pulse
    0, 0, 1, 1, 0,
    // Triangle XOR circuit selector
    1, 1, 1, 0, 1,
    // Triangle
#ifndef MOS8580
    1, 0, 1, // bit0
    1, 0, 1, // bit1
    1, 0, 1, // bit2
    1, 0, 1, // bit3
    1, 0, 1, // bit4
    1, 0, 1, // bit5
    1, 0, 1, // bit6
    1, 0, 1, // bit7
    1, 0, 1, // bit8
    1, 0, 1, // bit9
    1, 0, 1, // bit10
#else
    1, 1, 0, 0, 1, 0, 1, // bit0
    1, 1, 0, 0, 1, 0, 1, // bit1
    1, 1, 0, 0, 1, 0, 1, // bit2
    1, 1, 0, 0, 1, 0, 1, // bit3
    1, 1, 0, 0, 1, 0, 1, // bit4
    1, 1, 0, 0, 1, 0, 1, // bit5
    1, 1, 0, 0, 1, 0, 1, // bit6
    1, 1, 0, 0, 1, 0, 1, // bit7
    1, 1, 0, 0, 1, 0, 1, // bit8
    1, 1, 0, 0, 1, 0, 1, // bit9
    1, 1, 0, 0, 1, 0, 1, // bit10
    // Sawtooth bit23
    1, 1, 0,
#endif
    // Noise clock
    0, 0, 0, 0, 1, 1, 1, 0, 1,
    1, 1, 1, 1, 0,
    // Noise lfsr
    1, 1, 0, 0, 0, // bit0
    1, 1, 0, 0, 0, // bit1
    1, 1, 0, 0, 0, // bit2
    1, 1, 0, 0, 0, // bit3
    1, 1, 0, 0, 0, // bit4
    1, 1, 0, 0, 0, // bit5
    1, 1, 0, 0, 0, // bit6
    1, 1, 0, 0, 0, // bit7
    1, 1, 0, 0, 0, // bit8
    1, 1, 0, 0, 0, // bit9
    1, 1, 0, 0, 0, // bit10
    1, 1, 0, 0, 0, // bit11
    1, 1, 0, 0, 0, // bit12
    1, 1, 0, 0, 0, // bit13
    1, 1, 0, 0, 0, // bit14
    1, 1, 0, 0, 0, // bit15
    1, 1, 0, 0, 0, // bit16
    1, 1, 0, 0, 0, // bit17
    1, 1, 0, 0, 0, // bit18
    1, 1, 0, 0, 0, // bit19
    1, 1, 0, 0, 0, // bit20
    1, 1, 0, 0, 0, // bit21
    1, 1, 0, 0, 0, // bit22
    1, 1, 0, 0, 0, // bit23
    // Noise XOR
    0, 0, 1, 1, 1, 0, 1,
    // Waveform selector
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    // Waveform output
    1, 1, 0, // bit0
    1, 1, 0, // bit1
    1, 1, 0, // bit2
    1, 1, 0, // bit3
    1, 1, 0, // bit4
    1, 1, 0, // bit5
    1, 1, 0, // bit6
    1, 1, 0, // bit7
    1, 1, 0, // bit8
    1, 1, 0, // bit9
    1, 1, 0, // bit10
    1, 1, 0, // bit11
    // OSC3 register
    0, 1, 1, 0, // bit0
    0, 1, 1, 0, // bit1
    0, 1, 1, 0, // bit2
    0, 1, 1, 0, // bit3
    0, 1, 1, 0, // bit4
    0, 1, 1, 0, // bit5
    0, 1, 1, 0, // bit6
    0, 1, 1, 0, // bit7
    // Envelope
    // counting direction
    1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1,
    0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0,
    0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1,
    // counter
    1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1,    // bit0
    1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, // bit1
    1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1,    // bit2
    1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, // bit3
    1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1,    // bit4
    1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, // bit5
    1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1,    // bit6
    1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, // bit7
    //
    1, 1, 1, 1, 1, 1, 1,
    // ADSR gates
    1, 1,
    // ADSR registers
    0, 1, 1, 1, 0, // AD bit0
    0, 1, 1, 1, 0, // AD bit1
    0, 1, 1, 1, 0, // AD bit2
    0, 1, 1, 1, 0, // AD bit3
    0, 1, 1, 1, 0, // AD bit4
    0, 1, 1, 1, 0, // AD bit5
    0, 1, 1, 1, 0, // AD bit6
    0, 1, 1, 1, 0, // AD bit7
    0, 1, 1, 1, 0, // SR bit0
    0, 1, 1, 1, 0, // SR bit1
    0, 1, 1, 1, 0, // SR bit2
    0, 1, 1, 1, 0, // SR bit3
    0, 1, 1, 1, 0, // SR bit4
    0, 1, 1, 1, 0, // SR bit5
    0, 1, 1, 1, 0, // SR bit6
    0, 1, 1, 1, 0, // SR bit7
    0, 0, 0, 0,
    // ADR to LUT
    1, 1, // bit0
    1, 1, // bit1
    1, 1, // bit2
    1, 1, // bit3
    // sustain comparator
    1,
    0, 1, 1, 0, // bit0
    0, 1, 1, 0, // bit1
    0, 1, 1, 0, // bit2
    0, 1, 1, 0, // bit3
    0, 1, 1, 0, // bit4
    0, 1, 1, 0, // bit5
    0, 1, 1, 0, // bit6
    0, 1, 1, 0, // bit7
    // fixpoint found
    1,
    1, 1, 0, 0, 0, // bit0
    1, 1, 0, 0, 0, // bit1
    1, 1, 0, 0, 0, // bit2
    1, 1, 0, 0, 0, // bit3
    1, 1, 0, 0, 0, // bit4
    // LFSR 15
    1, 0, 1,
    0, 1, 0, 1, 1, 1, // bit00
    0, 1, 0, 1, 1, 1, // bit01
    0, 1, 0, 1, 1, 1, // bit02
    0, 1, 0, 1, 1, 1, // bit03
    0, 1, 0, 1, 1, 1, // bit04
    0, 1, 0, 1, 1, 1, // bit05
    0, 1, 0, 1, 1, 1, // bit06
    0, 1, 0, 1, 1, 1, // bit07
    0, 1, 0, 1, 1, 1, // bit08
    0, 1, 0, 1, 1, 1, // bit09
    0, 1, 0, 1, 1, 1, // bit10
    0, 1, 0, 1, 1, 1, // bit11
    0, 1, 0, 1, 1, 1, // bit12
    0, 1, 0, 1, 1, 1, // bit13
    0, 1, 0, 1, 1, 1, // bit14
    // reset
    1, 0, 1, 1, 0, 0, 1,
    // LUT
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    // LFSR 5
    1, 0, 1,
    0, 1, 0, 1, 1, 1, // bit00
    0, 1, 0, 1, 1, 1, // bit01
    0, 1, 0, 1, 1, 1, // bit02
    0, 1, 0, 1, 1, 1, // bit03
    0, 1, 0, 1, 1, 1, // bit04
    // reset
    1, 0, 1, 0, 0, 0, 1,
    // clock
    1, 1, 0, 0, 0, 0,
    // LUT
    1, 1, 1, 1, 1,
    // ENV3 register
    0, 1, 1, 0, // bit0
    0, 1, 1, 0, // bit1
    0, 1, 1, 0, // bit2
    0, 1, 1, 0, // bit3
    0, 1, 1, 0, // bit4
    0, 1, 1, 0, // bit5
    0, 1, 1, 0, // bit6
    0, 1, 1, 0, // bit7
};

// enhancement-mode (pull-down and pass) transistors
// gate, source and drain nodes
netlist_transdefs
netlist_6581_transdefs[] = {
    // clock
    {GND, Phi2, GND},
    {Phi2, cl01, GND},
    {cl01, Vcc, cl_a},
    {Phi2, cl_a, GND},
    {Phi2, cl02, GND},
    {cl02, Vcc, cl_b},
    {Phi2, cl_b, GND},
#ifndef MOS8580
    {cl_b, cl03, GND},
    {cl_b, cl04, GND},
    {sid_clk1, cl04, GND},
    {cl03, cl05, GND},
    {sid_clk2, cl05, GND},
    {cl04, cl06, GND},
    {cl05, cl07, GND},
    {cl06, cl08, GND},
    {cl07, cl09, GND},
    {cl08, Vdd, cl10},
    {cl06, cl10, GND},
    {cl09, Vdd, cl11},
    {cl07, cl11, GND},
    {cl10, cl12, GND},
    {cl11, cl13, GND},
    {cl10, Vcc, sid_clk2},
    {cl12, sid_clk2, GND},
    {cl11, Vcc, sid_clk1},
    {cl13, sid_clk1, GND},
#else
    {cl_b, cl03, GND},
    {cl03, Vcc, cl04},
    {cl_b, cl04, GND},

    {cl04, cl10, GND},
    {cl10, Vcc, cl11},
    {cl04, cl11, GND},
    {cl16, Vcc, cl12},
    {cl11, cl12, GND},
    {sid_clk1, cl12, GND},
    {cl04, Vcc, cl13},
    {cl11, cl13, GND},
    {cl13, cl14, GND},
    {cl14, Vcc, cl12},
    {Vcc, Vcc, cl15}, // Enhancement-mode transistor
    {cl15, cl12, cl16},
    {cl11, cl16, GND},
    {sid_clk1, cl16, GND},
    {cl16, Vcc, sid_clk2},
    {cl11, sid_clk2, GND},
    {sid_clk1, sid_clk2, GND},

    {cl11, cl20, GND},
    {cl20, Vcc, cl21},
    {cl11, cl21, GND},
    {cl26, Vcc, cl22},
    {cl21, cl22, GND},
    {sid_clk2, cl22, GND},
    {cl11, Vcc, cl23},
    {cl21, cl23, GND},
    {cl23, cl24, GND},
    {cl24, Vcc, cl22},
    {Vcc, Vcc, cl25}, // Enhancement-mode transistor
    {cl25, cl22, cl26},
    {cl21, cl26, GND},
    {sid_clk2, cl26, GND},
    {cl04, cl26, GND},
    {cl26, Vcc, sid_clk1},
    {cl21, sid_clk1, GND},
    {sid_clk2, sid_clk1, GND},
    {cl04, sid_clk1, GND},
#endif
    // reset
    {GND, res, GND},
    {res, rst1, GND},
    {rst1, Vcc, rst2},
    {res, rst2, GND},
    {sid_clk1, rst2, rst_ltc},
    {rst_ltc, rst3, GND},
    {rst3, sid_rst, GND},
    // cs/rw
    {GND, rw, GND},
    {rw, rw1, GND},
    {rw1, Vcc, rw2},
    {rw, rw2, GND},
    {rw2, rw4, GND},
    {rw4, rw5, GND},
    {rw5, _rw, GND},
    {rw, rw10, GND},
    {cl_b, rw10, GND},
    {cs, rw10, GND},
    {_rw, rw10, GND},
    {rw10, Vcc, rw11},
    {rw, rw11, GND},
    {cl_b, rw11, GND},
    {cs, rw11, GND},
    {_rw, rw11, GND},
    {rw11, rw12, GND},
    {sid_rst, rw12, GND},
    {rw12, Vcc, write},
    {rw11, write, GND},
    {sid_rst, write, GND},
    {GND, cs, GND},
    {cs, rw20, GND},
    {cl_b, rw20, GND},
    {rw2, rw20, GND},
    {rw20, Vcc, rw21},
    {cs, rw21, GND},
    {cl_b, rw21, GND},
    {rw2, rw21, GND},
    {rw21, rw22, GND},
    {rw22, Vcc, read},
    {rw21, read, GND},
    // address decoder
    {GND, A0, GND},
    {A0, A0_1, GND},
    {A0_1, Vcc, A0_2},
    {A0, A0_2, GND},
    {A0_2, A0_3, GND},
    {sid_rst, A0_3, GND},
    {A0_3, Vcc, A0_high},
    {A0_2, A0_high, GND},
    {sid_rst, A0_high, GND},
    {A0_high, A0_5, GND},
    {sid_rst, A0_5, GND},
    {A0_5, Vcc, A0_low},
    {A0_high, A0_low, GND},
    {sid_rst, A0_low, GND},
    {GND, A1, GND},
    {A1, A1_1, GND},
    {A1_1, Vcc, A1_2},
    {A1, A1_2, GND},
    {A1_2, A1_3, GND},
    {sid_rst, A1_3, GND},
    {A1_3, Vcc, A1_high},
    {A1_2, A1_high, GND},
    {sid_rst, A1_high, GND},
    {A1_high, A1_5, GND},
    {sid_rst, A1_5, GND},
    {A1_5, Vcc, A1_low},
    {A1_high, A1_low, GND},
    {sid_rst, A1_low, GND},
    {GND, A2, GND},
    {A2, A2_1, GND},
    {A2_1, Vcc, A2_2},
    {A2, A2_2, GND},
    {A2_2, A2_3, GND},
    {sid_rst, A2_3, GND},
    {A2_3, Vcc, A2_high},
    {A2_2, A2_high, GND},
    {sid_rst, A2_high, GND},
    {A2_high, A2_5, GND},
    {sid_rst, A2_5, GND},
    {A2_5, Vcc, A2_low},
    {A2_high, A2_low, GND},
    {sid_rst, A2_low, GND},
    {GND, A3, GND},
    {A3, A3_1, GND},
    {A3_1, Vcc, A3_2},
    {A3, A3_2, GND},
    {A3_2, A3_3, GND},
    {sid_rst, A3_3, GND},
    {A3_3, Vcc, A3_high},
    {A3_2, A3_high, GND},
    {sid_rst, A3_high, GND},
    {A3_high, A3_5, GND},
    {sid_rst, A3_5, GND},
    {A3_5, Vcc, A3_low},
    {A3_high, A3_low, GND},
    {sid_rst, A3_low, GND},
    {GND, A4, GND},
    {A4, A4_1, GND},
    {A4_1, Vcc, A4_2},
    {A4, A4_2, GND},
    {A4_2, A4_3, GND},
    {sid_rst, A4_3, GND},
    {A4_3, Vcc, A4_high},
    {A4_2, A4_high, GND},
    {sid_rst, A4_high, GND},
    {A4_high, A4_5, GND},
    {sid_rst, A4_5, GND},
    {A4_5, Vcc, A4_low},
    {A4_high, A4_low, GND},
    {sid_rst, A4_low, GND},
    // reg $00
    {GND, ad00, reg00},
    {ad00, Vcc, reg00},
    {write, reg00, GND},
    {A0_high, reg00, GND},
    {A1_high, reg00, GND},
    {A2_high, reg00, GND},
    {A3_high, reg00, GND},
    {A4_high, reg00, GND},
    // reg $01
    {GND, ad01, reg01},
    {ad01, Vcc, reg01},
    {write, reg01, GND},
    {A0_low, reg01, GND},
    {A1_high, reg01, GND},
    {A2_high, reg01, GND},
    {A3_high, reg01, GND},
    {A4_high, reg01, GND},
    // reg $02
    {GND, ad02, reg02},
    {ad02, Vcc, reg02},
    {write, reg02, GND},
    {A0_high, reg02, GND},
    {A1_low, reg02, GND},
    {A2_high, reg02, GND},
    {A3_high, reg02, GND},
    {A4_high, reg02, GND},
    // reg $03
    {GND, ad03, reg03},
    {ad03, Vcc, reg03},
    {write, reg03, GND},
    {A0_low, reg03, GND},
    {A1_low, reg03, GND},
    {A2_high, reg03, GND},
    {A3_high, reg03, GND},
    {A4_high, reg03, GND},
    // reg $04
    {GND, ad04, reg04},
    {ad04, Vcc, reg04},
    {write, reg04, GND},
    {A0_high, reg04, GND},
    {A1_high, reg04, GND},
    {A2_low, reg04, GND},
    {A3_high, reg04, GND},
    {A4_high, reg04, GND},
    // reg $05
    {GND, ad05, reg05},
    {ad05, Vcc, reg05},
    {write, reg05, GND},
    {A0_low, reg05, GND},
    {A1_high, reg05, GND},
    {A2_low, reg05, GND},
    {A3_high, reg05, GND},
    {A4_high, reg05, GND},
    // reg $06
    {GND, ad06, reg06},
    {ad06, Vcc, reg06},
    {write, reg06, GND},
    {A0_high, reg06, GND},
    {A1_low, reg06, GND},
    {A2_low, reg06, GND},
    {A3_high, reg06, GND},
    {A4_high, reg06, GND},
    // reg $07
    {GND, ad07, reg07},
    {ad07, Vcc, reg07},
    {write, reg05, GND},
    {A0_low, reg07, GND},
    {A1_low, reg07, GND},
    {A2_low, reg07, GND},
    {A3_high, reg07, GND},
    {A4_high, reg07, GND},
    // reg $08
    {GND, ad08, reg08},
    {ad08, Vcc, reg08},
    {write, reg08, GND},
    {A0_high, reg08, GND},
    {A1_high, reg08, GND},
    {A2_high, reg08, GND},
    {A3_low, reg08, GND},
    {A4_high, reg08, GND},
    // reg $09
    {GND, ad09, reg09},
    {ad09, Vcc, reg09},
    {write, reg09, GND},
    {A0_low, reg09, GND},
    {A1_high, reg09, GND},
    {A2_high, reg09, GND},
    {A3_low, reg09, GND},
    {A4_high, reg09, GND},
    // reg $0A
    {GND, ad0a, reg0A},
    {ad0a, Vcc, reg0A},
    {write, reg0A, GND},
    {A0_high, reg0A, GND},
    {A1_low, reg0A, GND},
    {A2_high, reg0A, GND},
    {A3_low, reg0A, GND},
    {A4_high, reg0A, GND},
    // reg $0B
    {GND, ad0b, reg0B},
    {ad0b, Vcc, reg0B},
    {write, reg0B, GND},
    {A0_low, reg0B, GND},
    {A1_low, reg0B, GND},
    {A2_high, reg0B, GND},
    {A3_low, reg0B, GND},
    {A4_high, reg0B, GND},
    // reg $0C
    {GND, ad0c, reg0C},
    {ad0c, Vcc, reg0C},
    {write, reg0C, GND},
    {A0_high, reg0C, GND},
    {A1_high, reg0C, GND},
    {A2_low, reg0C, GND},
    {A3_low, reg0C, GND},
    {A4_high, reg0C, GND},
    // reg $0D
    {GND, ad0d, reg0D},
    {ad0d, Vcc, reg0D},
    {write, reg0D, GND},
    {A0_low, reg0D, GND},
    {A1_high, reg0D, GND},
    {A2_low, reg0D, GND},
    {A3_low, reg0D, GND},
    {A4_high, reg0D, GND},
    // reg $0E
    {GND, ad0e, reg0E},
    {ad0e, Vcc, reg0E},
    {write, reg0E, GND},
    {A0_high, reg0E, GND},
    {A1_low, reg0E, GND},
    {A2_low, reg0E, GND},
    {A3_low, reg0E, GND},
    {A4_high, reg0E, GND},
    // reg $0F
    {GND, ad0f, reg0F},
    {ad0f, Vcc, reg0F},
    {write, reg0F, GND},
    {A0_low, reg0F, GND},
    {A1_low, reg0F, GND},
    {A2_low, reg0F, GND},
    {A3_low, reg0F, GND},
    {A4_high, reg0F, GND},
    // reg $10
    {GND, ad10, reg10},
    {ad10, Vcc, reg10},
    {write, reg10, GND},
    {A0_high, reg10, GND},
    {A1_high, reg10, GND},
    {A2_high, reg10, GND},
    {A3_high, reg10, GND},
    {A4_low, reg10, GND},
    // reg $11
    {GND, ad11, reg11},
    {ad11, Vcc, reg11},
    {write, reg11, GND},
    {A0_low, reg11, GND},
    {A1_high, reg11, GND},
    {A2_high, reg11, GND},
    {A3_high, reg11, GND},
    {A4_low, reg11, GND},
    // reg $12
    {GND, ad12, reg12},
    {ad12, Vcc, reg12},
    {write, reg12, GND},
    {A0_high, reg12, GND},
    {A1_low, reg12, GND},
    {A2_high, reg12, GND},
    {A3_high, reg12, GND},
    {A4_low, reg12, GND},
    // reg $13
    {GND, ad13, reg13},
    {ad13, Vcc, reg13},
    {write, reg13, GND},
    {A0_low, reg13, GND},
    {A1_low, reg13, GND},
    {A2_high, reg13, GND},
    {A3_high, reg13, GND},
    {A4_low, reg13, GND},
    // reg $14
    {GND, ad14, reg14},
    {ad14, Vcc, reg14},
    {write, reg14, GND},
    {A0_high, reg14, GND},
    {A1_high, reg14, GND},
    {A2_low, reg14, GND},
    {A3_high, reg14, GND},
    {A4_low, reg14, GND},
    // reg $15
    {GND, ad15, reg15},
    {ad15, Vcc, reg15},
    {write, reg15, GND},
    {A0_low, reg15, GND},
    {A1_high, reg15, GND},
    {A2_low, reg15, GND},
    {A3_high, reg15, GND},
    {A4_low, reg15, GND},
    // reg $16
    {GND, ad16, reg16},
    {ad16, Vcc, reg16},
    {write, reg16, GND},
    {A0_high, reg16, GND},
    {A1_low, reg16, GND},
    {A2_low, reg16, GND},
    {A3_high, reg16, GND},
    {A4_low, reg16, GND},
    // reg $17
    {GND, ad17, reg17},
    {ad17, Vcc, reg17},
    {write, reg17, GND},
    {A0_low, reg17, GND},
    {A1_low, reg17, GND},
    {A2_low, reg17, GND},
    {A3_high, reg17, GND},
    {A4_low, reg17, GND},
    // reg $18
    {GND, ad18, reg18},
    {ad18, Vcc, reg18},
    {read, reg18, GND},
    {A0_high, reg18, GND},
    {A1_high, reg18, GND},
    {A2_high, reg18, GND},
    {A3_low, reg18, GND},
    {A4_low, reg18, GND},
    // reg $19
    {GND, ad19, reg19},
    {ad19, Vcc, reg19},
    {read, reg19, GND},
    {A0_low, reg19, GND},
    {A1_high, reg19, GND},
    {A2_high, reg19, GND},
    {A3_low, reg19, GND},
    {A4_low, reg19, GND},
    // reg $1A
    {GND, ad1a, reg1A},
    {ad1a, Vcc, reg1A},
    {read, reg1A, GND},
    {A0_high, reg1A, GND},
    {A1_low, reg1A, GND},
    {A2_high, reg1A, GND},
    {A3_low, reg1A, GND},
    {A4_low, reg1A, GND},
    // reg $1B
    {GND, ad1b, reg1B},
    {ad1b, Vcc, reg1B},
    {read, reg1B, GND},
    {A0_low, reg1B, GND},
    {A1_low, reg1B, GND},
    {A2_high, reg1B, GND},
    {A3_low, reg1B, GND},
    {A4_low, reg1B, GND},
    // reg $1C
    {GND, ad1c, reg1C},
    {ad1c, Vcc, reg1C},
    {read, reg1C, GND},
    {A0_high, reg1C, GND},
    {A1_high, reg1C, GND},
    {A2_low, reg1C, GND},
    {A3_low, reg1C, GND},
    {A4_low, reg1C, GND},
    // data pin write
    {GND, D0, GND},
    {D0, dw0_1, GND},
    {dw0_1, Vcc, dw0_2},
    {D0, dw0_2, GND},
    {dw0_2, dw0_3, GND},
    {sid_rst, dw0_3, GND},
    {dw0_3, dw0_4, GND},
    {write, dw0_4, GND},
    {dw0_3, dw0_5, GND},
    {dw0_5, dw0_6, GND},
    {write, dw0_6, GND},
    {dw0_4, db0, GND},
    {dw0_6, Vcc, db0},
    {GND, D1, GND},
    {D1, dw1_1, GND},
    {dw1_1, Vcc, dw1_2},
    {D1, dw1_2, GND},
    {dw1_2, dw1_3, GND},
    {sid_rst, dw1_3, GND},
    {dw1_3, dw1_4, GND},
    {write, dw1_4, GND},
    {dw1_3, dw1_5, GND},
    {dw1_5, dw1_6, GND},
    {write, dw1_6, GND},
    {dw1_4, db1, GND},
    {dw1_6, Vcc, db1},
    {GND, D2, GND},
    {D2, dw2_1, GND},
    {dw2_1, Vcc, dw2_2},
    {D2, dw2_2, GND},
    {dw2_2, dw2_3, GND},
    {sid_rst, dw2_3, GND},
    {dw2_3, dw2_4, GND},
    {write, dw2_4, GND},
    {dw2_3, dw2_5, GND},
    {dw2_5, dw2_6, GND},
    {write, dw2_6, GND},
    {dw2_4, db2, GND},
    {dw2_6, Vcc, db2},
    {GND, D3, GND},
    {D3, dw3_1, GND},
    {dw3_1, Vcc, dw3_2},
    {D3, dw3_2, GND},
    {dw3_2, dw3_3, GND},
    {sid_rst, dw3_3, GND},
    {dw3_3, dw3_4, GND},
    {write, dw3_4, GND},
    {dw3_3, dw3_5, GND},
    {dw3_5, dw3_6, GND},
    {write, dw3_6, GND},
    {dw3_4, db3, GND},
    {dw3_6, Vcc, db3},
    {GND, D4, GND},
    {D4, dw4_1, GND},
    {dw4_1, Vcc, dw4_2},
    {D4, dw4_2, GND},
    {dw4_2, dw4_3, GND},
    {sid_rst, dw4_3, GND},
    {dw4_3, dw4_4, GND},
    {write, dw4_4, GND},
    {dw4_3, dw4_5, GND},
    {dw4_5, dw4_6, GND},
    {write, dw4_6, GND},
    {dw4_4, db4, GND},
    {dw4_6, Vcc, db4},
    {GND, D5, GND},
    {D5, dw5_1, GND},
    {dw5_1, Vcc, dw5_2},
    {D5, dw5_2, GND},
    {dw5_2, dw5_3, GND},
    {sid_rst, dw5_3, GND},
    {dw5_3, dw5_4, GND},
    {write, dw5_4, GND},
    {dw5_3, dw5_5, GND},
    {dw5_5, dw5_6, GND},
    {write, dw5_6, GND},
    {dw5_4, db5, GND},
    {dw5_6, Vcc, db5},
    {GND, D6, GND},
    {D6, dw6_1, GND},
    {dw6_1, Vcc, dw6_2},
    {D6, dw6_2, GND},
    {dw6_2, dw6_3, GND},
    {sid_rst, dw6_3, GND},
    {dw6_3, dw6_4, GND},
    {write, dw6_4, GND},
    {dw6_3, dw6_5, GND},
    {dw6_5, dw6_6, GND},
    {write, dw6_6, GND},
    {dw6_4, db6, GND},
    {dw6_6, Vcc, db6},
    {GND, D7, GND},
    {D7, dw7_1, GND},
    {dw7_1, Vcc, dw7_2},
    {D7, dw7_2, GND},
    {dw7_2, dw7_3, GND},
    {sid_rst, dw7_3, GND},
    {dw7_3, dw7_4, GND},
    {write, dw7_4, GND},
    {dw7_3, dw7_5, GND},
    {dw7_5, dw7_6, GND},
    {write, dw7_6, GND},
    {dw7_4, db7, GND},
    {dw7_6, Vcc, db7},
    // data pin read
    {db0, dr0_1, GND},
    {dr0_1, dr0_2, dr0_4},
    {read, dr0_3, GND},
    {dr0_3, dr0_4, GND},
    {db0, dr0_5, dr0_4},
    {dr0_5, dr0_6, GND},
    {dr0_2, dr0_7, GND},
    {dr0_6, Vcc, dr0_8},
    {dr0_5, dr0_8, GND},
    {dr0_7, Vcc, dr0_9},
    {dr0_2, dr0_9, GND},
    {dr0_8, Vcc, D0},
    {dr0_9, D0, GND},
    {db1, dr1_1, GND},
    {dr1_1, dr1_2, dr1_4},
    {read, dr1_3, GND},
    {dr1_3, dr1_4, GND},
    {db1, dr1_5, dr1_4},
    {dr1_5, dr1_6, GND},
    {dr1_2, dr1_7, GND},
    {dr1_6, Vcc, dr1_8},
    {dr1_5, dr1_8, GND},
    {dr1_7, Vcc, dr1_9},
    {dr1_2, dr1_9, GND},
    {dr1_8, Vcc, D1},
    {dr1_9, D1, GND},
    {db2, dr2_1, GND},
    {dr2_1, dr2_2, dr2_4},
    {read, dr2_3, GND},
    {dr2_3, dr2_4, GND},
    {db2, dr2_5, dr2_4},
    {dr2_5, dr2_6, GND},
    {dr2_2, dr2_7, GND},
    {dr2_6, Vcc, dr2_8},
    {dr2_5, dr2_8, GND},
    {dr2_7, Vcc, dr2_9},
    {dr2_2, dr2_9, GND},
    {dr2_8, Vcc, D2},
    {dr2_9, D2, GND},
    {db3, dr3_1, GND},
    {dr3_1, dr3_2, dr3_4},
    {read, dr3_3, GND},
    {dr3_3, dr3_4, GND},
    {db3, dr3_5, dr3_4},
    {dr3_5, dr3_6, GND},
    {dr3_2, dr3_7, GND},
    {dr3_6, Vcc, dr3_8},
    {dr3_5, dr3_8, GND},
    {dr3_7, Vcc, dr3_9},
    {dr3_2, dr3_9, GND},
    {dr3_8, Vcc, D3},
    {dr3_9, D3, GND},
    {db4, dr4_1, GND},
    {dr4_1, dr4_2, dr4_4},
    {read, dr4_3, GND},
    {dr4_3, dr4_4, GND},
    {db4, dr4_5, dr4_4},
    {dr4_5, dr4_6, GND},
    {dr4_2, dr4_7, GND},
    {dr4_6, Vcc, dr4_8},
    {dr4_5, dr4_8, GND},
    {dr4_7, Vcc, dr4_9},
    {dr4_2, dr4_9, GND},
    {dr4_8, Vcc, D4},
    {dr4_9, D4, GND},
    {db5, dr5_1, GND},
    {dr5_1, dr5_2, dr5_4},
    {read, dr5_3, GND},
    {dr5_3, dr5_4, GND},
    {db5, dr5_5, dr5_4},
    {dr5_5, dr5_6, GND},
    {dr5_2, dr5_7, GND},
    {dr5_6, Vcc, dr5_8},
    {dr5_5, dr5_8, GND},
    {dr5_7, Vcc, dr5_9},
    {dr5_2, dr5_9, GND},
    {dr5_8, Vcc, D5},
    {dr5_9, D5, GND},
    {db6, dr6_1, GND},
    {dr6_1, dr6_2, dr6_4},
    {read, dr6_3, GND},
    {dr6_3, dr6_4, GND},
    {db6, dr6_5, dr6_4},
    {dr6_5, dr6_6, GND},
    {dr6_2, dr6_7, GND},
    {dr6_6, Vcc, dr6_8},
    {dr6_5, dr6_8, GND},
    {dr6_7, Vcc, dr6_9},
    {dr6_2, dr6_9, GND},
    {dr6_8, Vcc, D6},
    {dr6_9, D6, GND},
    {db7, dr7_1, GND},
    {dr7_1, dr7_2, dr7_4},
    {read, dr7_3, GND},
    {dr7_3, dr7_4, GND},
    {db7, dr7_5, dr7_4},
    {dr7_5, dr7_6, GND},
    {dr7_2, dr7_7, GND},
    {dr7_6, Vcc, dr7_8},
    {dr7_5, dr7_8, GND},
    {dr7_7, Vcc, dr7_9},
    {dr7_2, dr7_9, GND},
    {dr7_8, Vcc, D7},
    {dr7_9, D7, GND},
    //*********************************************
    // Voice 3
    //*********************************************
    // ctl 3
    {reg12, db0, ctl3_bit0_in},
    {ctl3_bit0_in, ctl3_bit0_ltc, GND},
    {ctl3_bit0_ltc, ctl3_bit0_fb, GND},
    {sid_clk1, ctl3_bit0_fb, ctl3_bit0_in},
    {sid_clk1, ctl3_bit0_ltc, ctl3_bit0_inv},
    {ctl3_bit0_inv, ctl3_bit0_out, GND},

    {reg12, db1, ctl3_bit1_in},
    {ctl3_bit1_in, ctl3_bit1_ltc, GND},
    {ctl3_bit1_ltc, ctl3_bit1_fb, GND},
    {sid_clk1, ctl3_bit1_fb, ctl3_bit1_in},
    {sid_clk1, ctl3_bit1_ltc, ctl3_bit1_inv},
    {ctl3_bit1_inv, ctl3_bit1_out, GND},

    {reg12, db2, ctl3_bit2_in},
    {ctl3_bit2_in, ctl3_bit2_ltc, GND},
    {ctl3_bit2_ltc, ctl3_bit2_fb, GND},
    {sid_clk1, ctl3_bit2_fb, ctl3_bit2_in},
    {sid_clk1, ctl3_bit2_ltc, ctl3_bit2_inv},
    {ctl3_bit2_inv, ctl3_bit2_out, GND},

    {reg12, db3, ctl3_bit3_in},
    {ctl3_bit3_in, ctl3_bit3_ltc, GND},
    {ctl3_bit3_ltc, ctl3_bit3_fb, GND},
    {sid_clk1, ctl3_bit3_fb, ctl3_bit3_in},
    {sid_clk1, ctl3_bit3_ltc, ctl3_bit3_inv},
    {ctl3_bit3_inv, ctl3_bit3_out, GND},

    {reg12, db4, ctl3_bit4_in},
    {ctl3_bit4_in, ctl3_bit4_ltc, GND},
    {ctl3_bit4_ltc, ctl3_bit4_fb, GND},
    {sid_clk1, ctl3_bit4_fb, ctl3_bit4_in},
    {sid_clk1, ctl3_bit4_ltc, ctl3_bit4_inv},
    {ctl3_bit4_inv, ctl3_bit4_out, GND},

    {reg12, db5, ctl3_bit5_in},
    {ctl3_bit5_in, ctl3_bit5_ltc, GND},
    {ctl3_bit5_ltc, ctl3_bit5_fb, GND},
    {sid_clk1, ctl3_bit5_fb, ctl3_bit5_in},
    {sid_clk1, ctl3_bit5_ltc, ctl3_bit5_inv},
    {ctl3_bit5_inv, ctl3_bit5_out, GND},

    {reg12, db6, ctl3_bit6_in},
    {ctl3_bit6_in, ctl3_bit6_ltc, GND},
    {ctl3_bit6_ltc, ctl3_bit6_fb, GND},
    {sid_clk1, ctl3_bit6_fb, ctl3_bit6_in},
    {sid_clk1, ctl3_bit6_ltc, ctl3_bit6_inv},
    {ctl3_bit6_inv, ctl3_bit6_out, GND},

    {reg12, db7, ctl3_bit7_in},
    {ctl3_bit7_in, ctl3_bit7_ltc, GND},
    {ctl3_bit7_ltc, ctl3_bit7_fb, GND},
    {sid_clk1, ctl3_bit7_fb, ctl3_bit7_in},
    {sid_clk1, ctl3_bit7_ltc, ctl3_bit7_inv},
    {ctl3_bit7_inv, ctl3_bit7_out, GND},
    // freq 3
    {reg0E, db0, freq3_bit0_in},
    {freq3_bit0_in, freq3_bit0_ltc, GND},
    {freq3_bit0_ltc, freq3_bit0_fb, GND},
    {sid_clk1, freq3_bit0_fb, freq3_bit0_in},

    {reg0E, db1, freq3_bit1_in},
    {freq3_bit1_in, freq3_bit1_ltc, GND},
    {freq3_bit1_ltc, freq3_bit1_fb, GND},
    {sid_clk1, freq3_bit1_fb, freq3_bit1_in},

    {reg0E, db2, freq3_bit2_in},
    {freq3_bit2_in, freq3_bit2_ltc, GND},
    {freq3_bit2_ltc, freq3_bit2_fb, GND},
    {sid_clk1, freq3_bit2_fb, freq3_bit2_in},

    {reg0E, db3, freq3_bit3_in},
    {freq3_bit3_in, freq3_bit3_ltc, GND},
    {freq3_bit3_ltc, freq3_bit3_fb, GND},
    {sid_clk1, freq3_bit3_fb, freq3_bit3_in},

    {reg0E, db4, freq3_bit4_in},
    {freq3_bit4_in, freq3_bit4_ltc, GND},
    {freq3_bit4_ltc, freq3_bit4_fb, GND},
    {sid_clk1, freq3_bit4_fb, freq3_bit4_in},

    {reg0E, db5, freq3_bit5_in},
    {freq3_bit5_in, freq3_bit5_ltc, GND},
    {freq3_bit5_ltc, freq3_bit5_fb, GND},
    {sid_clk1, freq3_bit5_fb, freq3_bit5_in},

    {reg0E, db6, freq3_bit6_in},
    {freq3_bit6_in, freq3_bit6_ltc, GND},
    {freq3_bit6_ltc, freq3_bit6_fb, GND},
    {sid_clk1, freq3_bit6_fb, freq3_bit6_in},

    {reg0E, db7, freq3_bit7_in},
    {freq3_bit7_in, freq3_bit7_ltc, GND},
    {freq3_bit7_ltc, freq3_bit7_fb, GND},
    {sid_clk1, freq3_bit7_fb, freq3_bit7_in},

    {reg0F, db0, freq3_bit8_in},
    {freq3_bit8_in, freq3_bit8_ltc, GND},
    {freq3_bit8_ltc, freq3_bit8_fb, GND},
    {sid_clk1, freq3_bit8_fb, freq3_bit8_in},

    {reg0F, db1, freq3_bit9_in},
    {freq3_bit9_in, freq3_bit9_ltc, GND},
    {freq3_bit9_ltc, freq3_bit9_fb, GND},
    {sid_clk1, freq3_bit9_fb, freq3_bit9_in},

    {reg0F, db2, freq3_bit10_in},
    {freq3_bit10_in, freq3_bit10_ltc, GND},
    {freq3_bit10_ltc, freq3_bit10_fb, GND},
    {sid_clk1, freq3_bit10_fb, freq3_bit10_in},

    {reg0F, db3, freq3_bit11_in},
    {freq3_bit11_in, freq3_bit11_ltc, GND},
    {freq3_bit11_ltc, freq3_bit11_fb, GND},
    {sid_clk1, freq3_bit11_fb, freq3_bit11_in},

    {reg0F, db4, freq3_bit12_in},
    {freq3_bit12_in, freq3_bit12_ltc, GND},
    {freq3_bit12_ltc, freq3_bit12_fb, GND},
    {sid_clk1, freq3_bit12_fb, freq3_bit12_in},

    {reg0F, db5, freq3_bit13_in},
    {freq3_bit13_in, freq3_bit13_ltc, GND},
    {freq3_bit13_ltc, freq3_bit13_fb, GND},
    {sid_clk1, freq3_bit13_fb, freq3_bit13_in},

    {reg0F, db6, freq3_bit14_in},
    {freq3_bit14_in, freq3_bit14_ltc, GND},
    {freq3_bit14_ltc, freq3_bit14_fb, GND},
    {sid_clk1, freq3_bit14_fb, freq3_bit14_in},

    {reg0F, db7, freq3_bit15_in},
    {freq3_bit15_in, freq3_bit15_ltc, GND},
    {freq3_bit15_ltc, freq3_bit15_fb, GND},
    {sid_clk1, freq3_bit15_fb, freq3_bit15_in},

    {reg0F, GND, freq3_bit16_in},
    {freq3_bit16_in, freq3_bit16_ltc, GND},
    {freq3_bit16_ltc, freq3_bit16_fb, GND},
    {sid_clk1, freq3_bit16_fb, freq3_bit16_in},

    {reg0F, GND, freq3_bit17_in},
    {freq3_bit17_in, freq3_bit17_ltc, GND},
    {freq3_bit17_ltc, freq3_bit17_fb, GND},
    {sid_clk1, freq3_bit17_fb, freq3_bit17_in},

    {reg0F, GND, freq3_bit18_in},
    {freq3_bit18_in, freq3_bit18_ltc, GND},
    {freq3_bit18_ltc, freq3_bit18_fb, GND},
    {sid_clk1, freq3_bit18_fb, freq3_bit18_in},

    {reg0F, GND, freq3_bit19_in},
    {freq3_bit19_in, freq3_bit19_ltc, GND},
    {freq3_bit19_ltc, freq3_bit19_fb, GND},
    {sid_clk1, freq3_bit19_fb, freq3_bit19_in},

    {reg0F, GND, freq3_bit20_in},
    {freq3_bit20_in, freq3_bit20_ltc, GND},
    {freq3_bit20_ltc, freq3_bit20_fb, GND},
    {sid_clk1, freq3_bit20_fb, freq3_bit20_in},

    {reg0F, GND, freq3_bit21_in},
    {freq3_bit21_in, freq3_bit21_ltc, GND},
    {freq3_bit21_ltc, freq3_bit21_fb, GND},
    {sid_clk1, freq3_bit21_fb, freq3_bit21_in},

    {reg0F, GND, freq3_bit22_in},
    {freq3_bit22_in, freq3_bit22_ltc, GND},
    {freq3_bit22_ltc, freq3_bit22_fb, GND},
    {sid_clk1, freq3_bit22_fb, freq3_bit22_in},

    {reg0F, GND, freq3_bit23_in},
    {freq3_bit23_in, freq3_bit23_ltc, GND},
    {freq3_bit23_ltc, freq3_bit23_fb, GND},
    {sid_clk1, freq3_bit23_fb, freq3_bit23_in},
    // osc3 reset
    {ctl3_test, osc3_rst5, GND},
    {osc3_rst5, osc3_rst, osc3_rst1},
    {ctl3_sync, osc3_rst4, GND},
    {osc3_rst4, osc3_rst1, GND},
    {osc3_rst2, osc3_rst1, GND},
    {osc3_ltc1, osc3_rst1, GND},
    {v2_bit23, osc3_rst2, GND},
    {sid_clk2, osc3_rst2, osc3_ltc2},
    {osc3_ltc2, osc3_rst3, GND},
    {sid_clk1, osc3_rst3, osc3_ltc1},
    // osc3 bit0 adder
    {freq3_bit0_fb, osc3_bit0_adds, osc3_bit0_add1},
    {GND, osc3_bit0_add1, osc3_bit0_add2},
    {osc3_bit0, osc3_bit0_add2, GND},
    {osc3_bit0_carry, osc3_bit0_adds, osc3_bit0_add3},
    {osc3_bit0, osc3_bit0_add3, GND},
    {freq3_bit0_fb, osc3_bit0_add3, GND},
    {GND, osc3_bit0_add3, GND},

    {osc3_bit0, osc3_bit0_carry, osc3_bit0_cry1},
    {freq3_bit0_fb, osc3_bit0_cry1, GND},
    {GND, osc3_bit0_carry, osc3_bit0_cry2},
    {osc3_bit0, osc3_bit0_cry2, GND},
    {freq3_bit0_fb, osc3_bit0_cry2, GND},

    {sid_clk2, osc3_bit0_adds, osc3_bit0_ltc1},
    {osc3_bit0_ltc1, osc3_bit0_1, GND},
    {osc3_bit0_1, osc3_bit0_2, GND},
    {sid_clk1, osc3_bit0_2, osc3_bit0_ltc2},
    {osc3_bit0_ltc2, osc3_bit0, GND},
    {osc3_rst, osc3_bit0, GND},
    // osc3 bit1 adder
    {freq3_bit1_ltc, osc3_bit1_adds, osc3_bit1_add1},
    {osc3_bit0_carry, osc3_bit1_add1, osc3_bit1_add2},
    {osc3_bit1, osc3_bit1_add2, GND},
    {osc3_bit1_carry, osc3_bit1_adds, osc3_bit1_add3},
    {osc3_bit1, osc3_bit1_add3, GND},
    {freq3_bit1_ltc, osc3_bit1_add3, GND},
    {osc3_bit0_carry, osc3_bit1_add3, GND},

    {osc3_bit1, osc3_bit1_carry, osc3_bit1_cry1},
    {freq3_bit1_ltc, osc3_bit1_cry1, GND},
    {osc3_bit0_carry, osc3_bit1_carry, osc3_bit1_cry2},
    {osc3_bit1, osc3_bit1_cry2, GND},
    {freq3_bit1_ltc, osc3_bit1_cry2, GND},

    {sid_clk2, osc3_bit1_adds, osc3_bit1_ltc1},
    {osc3_bit1_ltc1, osc3_bit1_2, GND},
    {sid_clk1, osc3_bit1_2, osc3_bit1_ltc2},
    {osc3_bit1_ltc2, osc3_bit1_1, GND},
    {osc3_rst, osc3_bit1_1, GND},
    {osc3_bit1_1, osc3_bit1, GND},
    // osc3 bit2 adder
    {freq3_bit2_fb, osc3_bit2_adds, osc3_bit2_add1},
    {osc3_bit1_carry, osc3_bit2_add1, osc3_bit2_add2},
    {osc3_bit2, osc3_bit2_add2, GND},
    {osc3_bit2_carry, osc3_bit2_adds, osc3_bit2_add3},
    {osc3_bit2, osc3_bit2_add3, GND},
    {freq3_bit2_fb, osc3_bit2_add3, GND},
    {osc3_bit1_carry, osc3_bit2_add3, GND},

    {osc3_bit2, osc3_bit2_carry, osc3_bit2_cry1},
    {freq3_bit2_fb, osc3_bit2_cry1, GND},
    {osc3_bit1_carry, osc3_bit2_carry, osc3_bit2_cry2},
    {osc3_bit2, osc3_bit2_cry2, GND},
    {freq3_bit2_fb, osc3_bit2_cry2, GND},

    {sid_clk2, osc3_bit2_adds, osc3_bit2_ltc1},
    {osc3_bit2_ltc1, osc3_bit2_1, GND},
    {osc3_bit2_1, osc3_bit2_2, GND},
    {sid_clk1, osc3_bit2_2, osc3_bit2_ltc2},
    {osc3_bit2_ltc2, osc3_bit2, GND},
    {osc3_rst, osc3_bit2, GND},
    // osc3 bit3 adder
    {freq3_bit3_ltc, osc3_bit3_adds, osc3_bit3_add1},
    {osc3_bit2_carry, osc3_bit3_add1, osc3_bit3_add2},
    {osc3_bit3, osc3_bit3_add2, GND},
    {osc3_bit3_carry, osc3_bit3_adds, osc3_bit3_add3},
    {osc3_bit3, osc3_bit3_add3, GND},
    {freq3_bit3_ltc, osc3_bit3_add3, GND},
    {osc3_bit2_carry, osc3_bit3_add3, GND},

    {osc3_bit3, osc3_bit3_carry, osc3_bit3_cry1},
    {freq3_bit3_ltc, osc3_bit3_cry1, GND},
    {osc3_bit2_carry, osc3_bit3_carry, osc3_bit3_cry2},
    {osc3_bit3, osc3_bit3_cry2, GND},
    {freq3_bit3_ltc, osc3_bit3_cry2, GND},

    {sid_clk2, osc3_bit3_adds, osc3_bit3_ltc1},
    {osc3_bit3_ltc1, osc3_bit3_2, GND},
    {sid_clk1, osc3_bit3_2, osc3_bit3_ltc2},
    {osc3_bit3_ltc2, osc3_bit3_1, GND},
    {osc3_rst, osc3_bit3_1, GND},
    {osc3_bit3_1, osc3_bit3, GND},
    // osc3 bit4 adder
    {freq3_bit4_fb, osc3_bit4_adds, osc3_bit4_add1},
    {osc3_bit3_carry, osc3_bit4_add1, osc3_bit4_add2},
    {osc3_bit4, osc3_bit4_add2, GND},
    {osc3_bit4_carry, osc3_bit4_adds, osc3_bit4_add3},
    {osc3_bit4, osc3_bit4_add3, GND},
    {freq3_bit4_fb, osc3_bit4_add3, GND},
    {osc3_bit3_carry, osc3_bit4_add3, GND},

    {osc3_bit4, osc3_bit4_carry, osc3_bit4_cry1},
    {freq3_bit4_fb, osc3_bit4_cry1, GND},
    {osc3_bit3_carry, osc3_bit4_carry, osc3_bit4_cry2},
    {osc3_bit4, osc3_bit4_cry2, GND},
    {freq3_bit4_fb, osc3_bit4_cry2, GND},

    {sid_clk2, osc3_bit4_adds, osc3_bit4_ltc1},
    {osc3_bit4_ltc1, osc3_bit4_1, GND},
    {osc3_bit4_1, osc3_bit4_2, GND},
    {sid_clk1, osc3_bit4_2, osc3_bit4_ltc2},
    {osc3_bit4_ltc2, osc3_bit4, GND},
    {osc3_rst, osc3_bit4, GND},
    // osc3 bit5 adder
    {freq3_bit5_ltc, osc3_bit5_adds, osc3_bit5_add1},
    {osc3_bit4_carry, osc3_bit5_add1, osc3_bit5_add2},
    {osc3_bit5, osc3_bit5_add2, GND},
    {osc3_bit5_carry, osc3_bit5_adds, osc3_bit5_add3},
    {osc3_bit5, osc3_bit5_add3, GND},
    {freq3_bit5_ltc, osc3_bit5_add3, GND},
    {osc3_bit4_carry, osc3_bit5_add3, GND},

    {osc3_bit5, osc3_bit5_carry, osc3_bit5_cry1},
    {freq3_bit5_ltc, osc3_bit5_cry1, GND},
    {osc3_bit4_carry, osc3_bit5_carry, osc3_bit5_cry2},
    {osc3_bit5, osc3_bit5_cry2, GND},
    {freq3_bit5_ltc, osc3_bit5_cry2, GND},

    {sid_clk2, osc3_bit5_adds, osc3_bit5_ltc1},
    {osc3_bit5_ltc1, osc3_bit5_2, GND},
    {sid_clk1, osc3_bit5_2, osc3_bit5_ltc2},
    {osc3_bit5_ltc2, osc3_bit5_1, GND},
    {osc3_rst, osc3_bit5_1, GND},
    {osc3_bit5_1, osc3_bit5, GND},
    // osc3 bit6 adder
    {freq3_bit6_fb, osc3_bit6_adds, osc3_bit6_add1},
    {osc3_bit5_carry, osc3_bit6_add1, osc3_bit6_add2},
    {osc3_bit6, osc3_bit6_add2, GND},
    {osc3_bit6_carry, osc3_bit6_adds, osc3_bit6_add3},
    {osc3_bit6, osc3_bit6_add3, GND},
    {freq3_bit6_fb, osc3_bit6_add3, GND},
    {osc3_bit5_carry, osc3_bit6_add3, GND},

    {osc3_bit6, osc3_bit6_carry, osc3_bit6_cry1},
    {freq3_bit6_fb, osc3_bit6_cry1, GND},
    {osc3_bit5_carry, osc3_bit6_carry, osc3_bit6_cry2},
    {osc3_bit6, osc3_bit6_cry2, GND},
    {freq3_bit6_fb, osc3_bit6_cry2, GND},

    {sid_clk2, osc3_bit6_adds, osc3_bit6_ltc1},
    {osc3_bit6_ltc1, osc3_bit6_1, GND},
    {osc3_bit6_1, osc3_bit6_2, GND},
    {sid_clk1, osc3_bit6_2, osc3_bit6_ltc2},
    {osc3_bit6_ltc2, osc3_bit6, GND},
    {osc3_rst, osc3_bit6, GND},
    // osc3 bit7 adder
    {freq3_bit7_ltc, osc3_bit7_adds, osc3_bit7_add1},
    {osc3_bit6_carry, osc3_bit7_add1, osc3_bit7_add2},
    {osc3_bit7, osc3_bit7_add2, GND},
    {osc3_bit7_carry, osc3_bit7_adds, osc3_bit7_add3},
    {osc3_bit7, osc3_bit7_add3, GND},
    {freq3_bit7_ltc, osc3_bit7_add3, GND},
    {osc3_bit6_carry, osc3_bit7_add3, GND},

    {osc3_bit7, osc3_bit7_carry, osc3_bit7_cry1},
    {freq3_bit7_ltc, osc3_bit7_cry1, GND},
    {osc3_bit6_carry, osc3_bit7_carry, osc3_bit7_cry2},
    {osc3_bit7, osc3_bit7_cry2, GND},
    {freq3_bit7_ltc, osc3_bit7_cry2, GND},

    {sid_clk2, osc3_bit7_adds, osc3_bit7_ltc1},
    {osc3_bit7_ltc1, osc3_bit7_2, GND},
    {sid_clk1, osc3_bit7_2, osc3_bit7_ltc2},
    {osc3_bit7_ltc2, osc3_bit7_1, GND},
    {osc3_rst, osc3_bit7_1, GND},
    {osc3_bit7_1, osc3_bit7, GND},
    // osc3 bit8 adder
    {freq3_bit8_fb, osc3_bit8_adds, osc3_bit8_add1},
    {osc3_bit7_carry, osc3_bit8_add1, osc3_bit8_add2},
    {osc3_bit8, osc3_bit8_add2, GND},
    {osc3_bit8_carry, osc3_bit8_adds, osc3_bit8_add3},
    {osc3_bit8, osc3_bit8_add3, GND},
    {freq3_bit8_fb, osc3_bit8_add3, GND},
    {osc3_bit7_carry, osc3_bit8_add3, GND},

    {osc3_bit8, osc3_bit8_carry, osc3_bit8_cry1},
    {freq3_bit8_fb, osc3_bit8_cry1, GND},
    {osc3_bit7_carry, osc3_bit8_carry, osc3_bit8_cry2},
    {osc3_bit8, osc3_bit8_cry2, GND},
    {freq3_bit8_fb, osc3_bit8_cry2, GND},

    {sid_clk2, osc3_bit8_adds, osc3_bit8_ltc1},
    {osc3_bit8_ltc1, osc3_bit8_1, GND},
    {osc3_bit8_1, osc3_bit8_2, GND},
    {sid_clk1, osc3_bit8_2, osc3_bit8_ltc2},
    {osc3_bit8_ltc2, osc3_bit8, GND},
    {osc3_rst, osc3_bit8, GND},
    // osc3 bit9 adder
    {freq3_bit9_ltc, osc3_bit9_adds, osc3_bit9_add1},
    {osc3_bit8_carry, osc3_bit9_add1, osc3_bit9_add2},
    {osc3_bit9, osc3_bit9_add2, GND},
    {osc3_bit9_carry, osc3_bit9_adds, osc3_bit9_add3},
    {osc3_bit9, osc3_bit9_add3, GND},
    {freq3_bit9_ltc, osc3_bit9_add3, GND},
    {osc3_bit8_carry, osc3_bit9_add3, GND},

    {osc3_bit9, osc3_bit9_carry, osc3_bit9_cry1},
    {freq3_bit9_ltc, osc3_bit9_cry1, GND},
    {osc3_bit8_carry, osc3_bit9_carry, osc3_bit9_cry2},
    {osc3_bit9, osc3_bit9_cry2, GND},
    {freq3_bit9_ltc, osc3_bit9_cry2, GND},

    {sid_clk2, osc3_bit9_adds, osc3_bit9_ltc1},
    {osc3_bit9_ltc1, osc3_bit9_2, GND},
    {sid_clk1, osc3_bit9_2, osc3_bit9_ltc2},
    {osc3_bit9_ltc2, osc3_bit9_1, GND},
    {osc3_rst, osc3_bit9_1, GND},
    {osc3_bit9_1, osc3_bit9, GND},
    // osc3 bit10 adder
    {freq3_bit10_fb, osc3_bit10_adds, osc3_bit10_add1},
    {osc3_bit9_carry, osc3_bit10_add1, osc3_bit10_add2},
    {osc3_bit10, osc3_bit10_add2, GND},
    {osc3_bit10_carry, osc3_bit10_adds, osc3_bit10_add3},
    {osc3_bit10, osc3_bit10_add3, GND},
    {freq3_bit10_fb, osc3_bit10_add3, GND},
    {osc3_bit9_carry, osc3_bit10_add3, GND},

    {osc3_bit10, osc3_bit10_carry, osc3_bit10_cry1},
    {freq3_bit10_fb, osc3_bit10_cry1, GND},
    {osc3_bit9_carry, osc3_bit10_carry, osc3_bit10_cry2},
    {osc3_bit10, osc3_bit10_cry2, GND},
    {freq3_bit10_fb, osc3_bit10_cry2, GND},

    {sid_clk2, osc3_bit10_adds, osc3_bit10_ltc1},
    {osc3_bit10_ltc1, osc3_bit10_1, GND},
    {osc3_bit10_1, osc3_bit10_2, GND},
    {sid_clk1, osc3_bit10_2, osc3_bit10_ltc2},
    {osc3_bit10_ltc2, osc3_bit10, GND},
    {osc3_rst, osc3_bit10, GND},
    // osc3 bit11 adder
    {freq3_bit11_ltc, osc3_bit11_adds, osc3_bit11_add1},
    {osc3_bit10_carry, osc3_bit11_add1, osc3_bit11_add2},
    {osc3_bit11, osc3_bit11_add2, GND},
    {osc3_bit11_carry, osc3_bit11_adds, osc3_bit11_add3},
    {osc3_bit11, osc3_bit11_add3, GND},
    {freq3_bit11_ltc, osc3_bit11_add3, GND},
    {osc3_bit10_carry, osc3_bit11_add3, GND},

    {osc3_bit11, osc3_bit11_carry, osc3_bit11_cry1},
    {freq3_bit11_ltc, osc3_bit11_cry1, GND},
    {osc3_bit10_carry, osc3_bit11_carry, osc3_bit11_cry2},
    {osc3_bit11, osc3_bit11_cry2, GND},
    {freq3_bit11_ltc, osc3_bit11_cry2, GND},

    {sid_clk2, osc3_bit11_adds, osc3_bit11_ltc1},
    {osc3_bit11_ltc1, osc3_bit11_2, GND},
    {sid_clk1, osc3_bit11_2, osc3_bit11_ltc2},
    {osc3_bit11_ltc2, osc3_bit11_1, GND},
    {osc3_rst, osc3_bit11_1, GND},
    {osc3_bit11_1, osc3_bit11, GND},
    // osc3 bit12 adder
    {freq3_bit12_fb, osc3_bit12_adds, osc3_bit12_add1},
    {osc3_bit11_carry, osc3_bit12_add1, osc3_bit12_add2},
    {osc3_bit12, osc3_bit12_add2, GND},
    {osc3_bit12_carry, osc3_bit12_adds, osc3_bit12_add3},
    {osc3_bit12, osc3_bit12_add3, GND},
    {freq3_bit12_fb, osc3_bit12_add3, GND},
    {osc3_bit11_carry, osc3_bit12_add3, GND},

    {osc3_bit12, osc3_bit12_carry, osc3_bit12_cry1},
    {freq3_bit12_fb, osc3_bit12_cry1, GND},
    {osc3_bit11_carry, osc3_bit12_carry, osc3_bit12_cry2},
    {osc3_bit12, osc3_bit12_cry2, GND},
    {freq3_bit12_fb, osc3_bit12_cry2, GND},

    {sid_clk2, osc3_bit12_adds, osc3_bit12_ltc1},
    {osc3_bit12_ltc1, osc3_bit12_1, GND},
    {osc3_bit12_1, osc3_bit12_2, GND},
    {sid_clk1, osc3_bit12_2, osc3_bit12_ltc2},
    {osc3_bit12_ltc2, osc3_bit12, GND},
    {osc3_rst, osc3_bit12, GND},
    // osc3 bit13 adder
    {freq3_bit13_ltc, osc3_bit13_adds, osc3_bit13_add1},
    {osc3_bit12_carry, osc3_bit13_add1, osc3_bit13_add2},
    {osc3_bit13, osc3_bit13_add2, GND},
    {osc3_bit13_carry, osc3_bit13_adds, osc3_bit13_add3},
    {osc3_bit13, osc3_bit13_add3, GND},
    {freq3_bit13_ltc, osc3_bit13_add3, GND},
    {osc3_bit12_carry, osc3_bit13_add3, GND},

    {osc3_bit13, osc3_bit13_carry, osc3_bit13_cry1},
    {freq3_bit13_ltc, osc3_bit13_cry1, GND},
    {osc3_bit12_carry, osc3_bit13_carry, osc3_bit13_cry2},
    {osc3_bit13, osc3_bit13_cry2, GND},
    {freq3_bit13_ltc, osc3_bit13_cry2, GND},

    {sid_clk2, osc3_bit13_adds, osc3_bit13_ltc1},
    {osc3_bit13_ltc1, osc3_bit13_2, GND},
    {sid_clk1, osc3_bit13_2, osc3_bit13_ltc2},
    {osc3_bit13_ltc2, osc3_bit13_1, GND},
    {osc3_rst, osc3_bit13_1, GND},
    {osc3_bit13_1, osc3_bit13, GND},

    // osc3 bit14 adder
    {freq3_bit14_fb, osc3_bit14_adds, osc3_bit14_add1},
    {osc3_bit13_carry, osc3_bit14_add1, osc3_bit14_add2},
    {osc3_bit14, osc3_bit14_add2, GND},
    {osc3_bit14_carry, osc3_bit14_adds, osc3_bit14_add3},
    {osc3_bit14, osc3_bit14_add3, GND},
    {freq3_bit14_fb, osc3_bit14_add3, GND},
    {osc3_bit13_carry, osc3_bit14_add3, GND},

    {osc3_bit14, osc3_bit14_carry, osc3_bit14_cry1},
    {freq3_bit14_fb, osc3_bit14_cry1, GND},
    {osc3_bit13_carry, osc3_bit14_carry, osc3_bit14_cry2},
    {osc3_bit14, osc3_bit14_cry2, GND},
    {freq3_bit14_fb, osc3_bit14_cry2, GND},

    {sid_clk2, osc3_bit14_adds, osc3_bit14_ltc1},
    {osc3_bit14_ltc1, osc3_bit14_1, GND},
    {osc3_bit14_1, osc3_bit14_2, GND},
    {sid_clk1, osc3_bit14_2, osc3_bit14_ltc2},
    {osc3_bit14_ltc2, osc3_bit14, GND},
    {osc3_rst, osc3_bit14, GND},
    // osc3 bit15 adder
    {freq3_bit15_ltc, osc3_bit15_adds, osc3_bit15_add1},
    {osc3_bit14_carry, osc3_bit15_add1, osc3_bit15_add2},
    {osc3_bit15, osc3_bit15_add2, GND},
    {osc3_bit15_carry, osc3_bit15_adds, osc3_bit15_add3},
    {osc3_bit15, osc3_bit15_add3, GND},
    {freq3_bit15_ltc, osc3_bit15_add3, GND},
    {osc3_bit14_carry, osc3_bit15_add3, GND},

    {osc3_bit15, osc3_bit15_carry, osc3_bit15_cry1},
    {freq3_bit15_ltc, osc3_bit15_cry1, GND},
    {osc3_bit14_carry, osc3_bit15_carry, osc3_bit15_cry2},
    {osc3_bit15, osc3_bit15_cry2, GND},
    {freq3_bit15_ltc, osc3_bit15_cry2, GND},

    {sid_clk2, osc3_bit15_adds, osc3_bit15_ltc1},
    {osc3_bit15_ltc1, osc3_bit15_2, GND},
    {sid_clk1, osc3_bit15_2, osc3_bit15_ltc2},
    {osc3_bit15_ltc2, osc3_bit15_1, GND},
    {osc3_rst, osc3_bit15_1, GND},
    {osc3_bit15_1, osc3_bit15, GND},
    // osc3 bit16 adder
    {freq3_bit16_fb, osc3_bit16_adds, osc3_bit16_add1},
    {osc3_bit15_carry, osc3_bit16_add1, osc3_bit16_add2},
    {osc3_bit16, osc3_bit16_add2, GND},
    {osc3_bit16_carry, osc3_bit16_adds, osc3_bit16_add3},
    {osc3_bit16, osc3_bit16_add3, GND},
    {freq3_bit16_fb, osc3_bit16_add3, GND},
    {osc3_bit15_carry, osc3_bit16_add3, GND},

    {osc3_bit16, osc3_bit16_carry, osc3_bit16_cry1},
    {freq3_bit16_fb, osc3_bit16_cry1, GND},
    {osc3_bit15_carry, osc3_bit16_carry, osc3_bit16_cry2},
    {osc3_bit16, osc3_bit16_cry2, GND},
    {freq3_bit16_fb, osc3_bit16_cry2, GND},

    {sid_clk2, osc3_bit16_adds, osc3_bit16_ltc1},
    {osc3_bit16_ltc1, osc3_bit16_1, GND},
    {osc3_bit16_1, osc3_bit16_2, GND},
    {sid_clk1, osc3_bit16_2, osc3_bit16_ltc2},
    {osc3_bit16_ltc2, osc3_bit16, GND},
    {osc3_rst, osc3_bit16, GND},
    // osc3 bit17 adder
    {freq3_bit17_ltc, osc3_bit17_adds, osc3_bit17_add1},
    {osc3_bit16_carry, osc3_bit17_add1, osc3_bit17_add2},
    {osc3_bit17, osc3_bit17_add2, GND},
    {osc3_bit17_carry, osc3_bit17_adds, osc3_bit17_add3},
    {osc3_bit17, osc3_bit17_add3, GND},
    {freq3_bit17_ltc, osc3_bit17_add3, GND},
    {osc3_bit16_carry, osc3_bit17_add3, GND},

    {osc3_bit17, osc3_bit17_carry, osc3_bit17_cry1},
    {freq3_bit17_ltc, osc3_bit17_cry1, GND},
    {osc3_bit16_carry, osc3_bit17_carry, osc3_bit17_cry2},
    {osc3_bit17, osc3_bit17_cry2, GND},
    {freq3_bit17_ltc, osc3_bit17_cry2, GND},

    {sid_clk2, osc3_bit17_adds, osc3_bit17_ltc1},
    {osc3_bit17_ltc1, osc3_bit17_2, GND},
    {sid_clk1, osc3_bit17_2, osc3_bit17_ltc2},
    {osc3_bit17_ltc2, osc3_bit17_1, GND},
    {osc3_rst, osc3_bit17_1, GND},
    {osc3_bit17_1, osc3_bit17, GND},
    // osc3 bit18 adder
    {freq3_bit18_fb, osc3_bit18_adds, osc3_bit18_add1},
    {osc3_bit17_carry, osc3_bit18_add1, osc3_bit18_add2},
    {osc3_bit18, osc3_bit18_add2, GND},
    {osc3_bit18_carry, osc3_bit18_adds, osc3_bit18_add3},
    {osc3_bit18, osc3_bit18_add3, GND},
    {freq3_bit18_fb, osc3_bit18_add3, GND},
    {osc3_bit17_carry, osc3_bit18_add3, GND},

    {osc3_bit18, osc3_bit18_carry, osc3_bit18_cry1},
    {freq3_bit18_fb, osc3_bit18_cry1, GND},
    {osc3_bit17_carry, osc3_bit18_carry, osc3_bit18_cry2},
    {osc3_bit18, osc3_bit18_cry2, GND},
    {freq3_bit18_fb, osc3_bit18_cry2, GND},

    {sid_clk2, osc3_bit18_adds, osc3_bit18_ltc1},
    {osc3_bit18_ltc1, osc3_bit18_1, GND},
    {osc3_bit18_1, osc3_bit18_2, GND},
    {sid_clk1, osc3_bit18_2, osc3_bit18_ltc2},
    {osc3_bit18_ltc2, osc3_bit18, GND},
    {osc3_rst, osc3_bit18, GND},
    // osc3 bit19 adder
    {freq3_bit19_ltc, osc3_bit19_adds, osc3_bit19_add1},
    {osc3_bit18_carry, osc3_bit19_add1, osc3_bit19_add2},
    {osc3_bit19, osc3_bit19_add2, GND},
    {osc3_bit19_carry, osc3_bit19_adds, osc3_bit19_add3},
    {osc3_bit19, osc3_bit19_add3, GND},
    {freq3_bit19_ltc, osc3_bit19_add3, GND},
    {osc3_bit18_carry, osc3_bit19_add3, GND},

    {osc3_bit19, osc3_bit19_carry, osc3_bit19_cry1},
    {freq3_bit19_ltc, osc3_bit19_cry1, GND},
    {osc3_bit18_carry, osc3_bit19_carry, osc3_bit19_cry2},
    {osc3_bit19, osc3_bit19_cry2, GND},
    {freq3_bit19_ltc, osc3_bit19_cry2, GND},

    {sid_clk2, osc3_bit19_adds, osc3_bit19_ltc1},
    {osc3_bit19_ltc1, osc3_bit19_2, GND},
    {sid_clk1, osc3_bit19_2, osc3_bit19_ltc2},
    {osc3_bit19_ltc2, osc3_bit19_1, GND},
    {osc3_rst, osc3_bit19_1, GND},
    {osc3_bit19_1, osc3_bit19, GND},

    // osc3 bit20 adder
    {freq3_bit20_fb, osc3_bit20_adds, osc3_bit20_add1},
    {osc3_bit19_carry, osc3_bit20_add1, osc3_bit20_add2},
    {osc3_bit20, osc3_bit20_add2, GND},
    {osc3_bit20_carry, osc3_bit20_adds, osc3_bit20_add3},
    {osc3_bit20, osc3_bit20_add3, GND},
    {freq3_bit20_fb, osc3_bit20_add3, GND},
    {osc3_bit19_carry, osc3_bit20_add3, GND},

    {osc3_bit20, osc3_bit20_carry, osc3_bit20_cry1},
    {freq3_bit20_fb, osc3_bit20_cry1, GND},
    {osc3_bit19_carry, osc3_bit20_carry, osc3_bit20_cry2},
    {osc3_bit20, osc3_bit20_cry2, GND},
    {freq3_bit20_fb, osc3_bit20_cry2, GND},

    {sid_clk2, osc3_bit20_adds, osc3_bit20_ltc1},
    {osc3_bit20_ltc1, osc3_bit20_1, GND},
    {osc3_bit20_1, osc3_bit20_2, GND},
    {sid_clk1, osc3_bit20_2, osc3_bit20_ltc2},
    {osc3_bit20_ltc2, osc3_bit20, GND},
    {osc3_rst, osc3_bit20, GND},
    // osc3 bit21 adder
    {freq3_bit21_ltc, osc3_bit21_adds, osc3_bit21_add1},
    {osc3_bit20_carry, osc3_bit21_add1, osc3_bit21_add2},
    {osc3_bit21, osc3_bit21_add2, GND},
    {osc3_bit21_carry, osc3_bit21_adds, osc3_bit21_add3},
    {osc3_bit21, osc3_bit21_add3, GND},
    {freq3_bit21_ltc, osc3_bit21_add3, GND},
    {osc3_bit20_carry, osc3_bit21_add3, GND},

    {osc3_bit21, osc3_bit21_carry, osc3_bit21_cry1},
    {freq3_bit21_ltc, osc3_bit21_cry1, GND},
    {osc3_bit20_carry, osc3_bit21_carry, osc3_bit21_cry2},
    {osc3_bit21, osc3_bit21_cry2, GND},
    {freq3_bit21_ltc, osc3_bit21_cry2, GND},

    {sid_clk2, osc3_bit21_adds, osc3_bit21_ltc1},
    {osc3_bit21_ltc1, osc3_bit21_2, GND},
    {sid_clk1, osc3_bit21_2, osc3_bit21_ltc2},
    {osc3_bit21_ltc2, osc3_bit21_1, GND},
    {osc3_rst, osc3_bit21_1, GND},
    {osc3_bit21_1, osc3_bit21, GND},

    // osc3 bit22 adder
    {freq3_bit22_fb, osc3_bit22_adds, osc3_bit22_add1},
    {osc3_bit21_carry, osc3_bit22_add1, osc3_bit22_add2},
    {osc3_bit22, osc3_bit22_add2, GND},
    {osc3_bit22_carry, osc3_bit22_adds, osc3_bit22_add3},
    {osc3_bit22, osc3_bit22_add3, GND},
    {freq3_bit22_fb, osc3_bit22_add3, GND},
    {osc3_bit21_carry, osc3_bit22_add3, GND},

    {osc3_bit22, osc3_bit22_carry, osc3_bit22_cry1},
    {freq3_bit22_fb, osc3_bit22_cry1, GND},
    {osc3_bit21_carry, osc3_bit22_carry, osc3_bit22_cry2},
    {osc3_bit22, osc3_bit22_cry2, GND},
    {freq3_bit22_fb, osc3_bit22_cry2, GND},

    {sid_clk2, osc3_bit22_adds, osc3_bit22_ltc1},
    {osc3_bit22_ltc1, osc3_bit22_1, GND},
    {osc3_bit22_1, osc3_bit22_2, GND},
    {sid_clk1, osc3_bit22_2, osc3_bit22_ltc2},
    {osc3_bit22_ltc2, osc3_bit22, GND},
    {osc3_rst, osc3_bit22, GND},
    // osc3 bit23 adder
    {freq3_bit23_ltc, osc3_bit23_adds, osc3_bit23_add1},
    {osc3_bit22_carry, osc3_bit23_add1, osc3_bit23_add2},
    {osc3_bit23, osc3_bit23_add2, GND},
    {osc3_bit23_carry, osc3_bit23_adds, osc3_bit23_add3},
    {osc3_bit23, osc3_bit23_add3, GND},
    {freq3_bit23_ltc, osc3_bit23_add3, GND},
    {osc3_bit22_carry, osc3_bit23_add3, GND},

    {osc3_bit23, osc3_bit23_carry, osc3_bit23_cry1},
    {freq3_bit23_ltc, osc3_bit23_cry1, GND},
    {osc3_bit22_carry, osc3_bit23_carry, osc3_bit23_cry2},
    {osc3_bit23, osc3_bit23_cry2, GND},
    {freq3_bit23_ltc, osc3_bit23_cry2, GND},

    {sid_clk2, osc3_bit23_adds, osc3_bit23_ltc1},
    {osc3_bit23_ltc1, osc3_bit23_2, GND},
    {sid_clk1, osc3_bit23_2, osc3_bit23_ltc2},
    {osc3_bit23_ltc2, osc3_bit23_1, GND},
    {osc3_rst, osc3_bit23_1, GND},
    {osc3_bit23_1, osc3_bit23, GND},
    // pw3
    {reg10, db0, pw3_bit0_in},
    {pw3_bit0_in, pw3_bit0_ltc, GND},
    {pw3_bit0_ltc, pw3_bit0_fb, GND},
    {sid_clk1, pw3_bit0_fb, pw3_bit0_in},

    {reg10, db1, pw3_bit1_in},
    {pw3_bit1_in, pw3_bit1_ltc, GND},
    {pw3_bit1_ltc, pw3_bit1_fb, GND},
    {sid_clk1, pw3_bit1_fb, pw3_bit1_in},

    {reg10, db2, pw3_bit2_in},
    {pw3_bit2_in, pw3_bit2_ltc, GND},
    {pw3_bit2_ltc, pw3_bit2_fb, GND},
    {sid_clk1, pw3_bit2_fb, pw3_bit2_in},

    {reg10, db3, pw3_bit3_in},
    {pw3_bit3_in, pw3_bit3_ltc, GND},
    {pw3_bit3_ltc, pw3_bit3_fb, GND},
    {sid_clk1, pw3_bit3_fb, pw3_bit3_in},

    {reg10, db4, pw3_bit4_in},
    {pw3_bit4_in, pw3_bit4_ltc, GND},
    {pw3_bit4_ltc, pw3_bit4_fb, GND},
    {sid_clk1, pw3_bit4_fb, pw3_bit4_in},

    {reg10, db5, pw3_bit5_in},
    {pw3_bit5_in, pw3_bit5_ltc, GND},
    {pw3_bit5_ltc, pw3_bit5_fb, GND},
    {sid_clk1, pw3_bit5_fb, pw3_bit5_in},

    {reg10, db6, pw3_bit6_in},
    {pw3_bit6_in, pw3_bit6_ltc, GND},
    {pw3_bit6_ltc, pw3_bit6_fb, GND},
    {sid_clk1, pw3_bit6_fb, pw3_bit6_in},

    {reg10, db7, pw3_bit7_in},
    {pw3_bit7_in, pw3_bit7_ltc, GND},
    {pw3_bit7_ltc, pw3_bit7_fb, GND},
    {sid_clk1, pw3_bit7_fb, pw3_bit7_in},

    {reg11, db0, pw3_bit8_in},
    {pw3_bit8_in, pw3_bit8_ltc, GND},
    {pw3_bit8_ltc, pw3_bit8_fb, GND},
    {sid_clk1, pw3_bit8_fb, pw3_bit8_in},

    {reg11, db1, pw3_bit9_in},
    {pw3_bit9_in, pw3_bit9_ltc, GND},
    {pw3_bit9_ltc, pw3_bit9_fb, GND},
    {sid_clk1, pw3_bit9_fb, pw3_bit9_in},

    {reg11, db2, pw3_bit10_in},
    {pw3_bit10_in, pw3_bit10_ltc, GND},
    {pw3_bit10_ltc, pw3_bit10_fb, GND},
    {sid_clk1, pw3_bit10_fb, pw3_bit10_in},

    {reg11, db3, pw3_bit11_in},
    {pw3_bit11_in, pw3_bit11_ltc, GND},
    {pw3_bit11_ltc, pw3_bit11_fb, GND},
    {sid_clk1, pw3_bit11_fb, pw3_bit11_in},
    // pw3 adder
    {osc3_bit12, pw3_add0_cout, pw3_add0_1},
    {pw3_bit0_ltc, pw3_add0_1, GND},
    {Vcc, pw3_add0_cout, pw3_add0_2},
    {pw3_bit0_ltc, pw3_add0_2, GND},
    {osc3_bit12, pw3_add0_2, GND},

    {osc3_bit13_1, pw3_add1_3, GND},
    {pw3_add1_3, pw3_add1_cout, pw3_add1_1},
    {pw3_bit1_fb, pw3_add1_1, GND},
    {pw3_add0_cout, pw3_add1_cout, pw3_add1_2},
    {pw3_bit1_fb, pw3_add1_2, GND},
    {pw3_add1_3, pw3_add1_2, GND},

    {osc3_bit14, pw3_add2_cout, pw3_add2_1},
    {pw3_bit2_ltc, pw3_add2_1, GND},
    {pw3_add1_cout, pw3_add2_cout, pw3_add2_2},
    {pw3_bit2_ltc, pw3_add2_2, GND},
    {osc3_bit14, pw3_add2_2, GND},

    {osc3_bit15_1, pw3_add3_3, GND},
    {pw3_add3_3, pw3_add3_cout, pw3_add3_1},
    {pw3_bit3_fb, pw3_add3_1, GND},
    {pw3_add2_cout, pw3_add3_cout, pw3_add3_2},
    {pw3_bit3_fb, pw3_add3_2, GND},
    {pw3_add3_3, pw3_add3_2, GND},

    {osc3_bit16, pw3_add4_cout, pw3_add4_1},
    {pw3_bit4_ltc, pw3_add4_1, GND},
    {pw3_add3_cout, pw3_add4_cout, pw3_add4_2},
    {pw3_bit4_ltc, pw3_add4_2, GND},
    {osc3_bit16, pw3_add4_2, GND},

    {osc3_bit17_1, pw3_add5_3, GND},
    {pw3_add5_3, pw3_add5_cout, pw3_add5_1},
    {pw3_bit5_fb, pw3_add5_1, GND},
    {pw3_add4_cout, pw3_add5_cout, pw3_add5_2},
    {pw3_bit5_fb, pw3_add5_2, GND},
    {pw3_add5_3, pw3_add5_2, GND},

    {osc3_bit18, pw3_add6_cout, pw3_add6_1},
    {pw3_bit6_ltc, pw3_add6_1, GND},
    {pw3_add5_cout, pw3_add6_cout, pw3_add6_2},
    {pw3_bit6_ltc, pw3_add6_2, GND},
    {osc3_bit18, pw3_add6_2, GND},

    {osc3_bit19_1, pw3_add7_3, GND},
    {pw3_add7_3, pw3_add7_cout, pw3_add7_1},
    {pw3_bit7_fb, pw3_add7_1, GND},
    {pw3_add6_cout, pw3_add7_cout, pw3_add7_2},
    {pw3_bit7_fb, pw3_add7_2, GND},
    {pw3_add7_3, pw3_add7_2, GND},

    {osc3_bit20, pw3_add8_cout, pw3_add8_1},
    {pw3_bit8_ltc, pw3_add8_1, GND},
    {pw3_add7_cout, pw3_add8_cout, pw3_add8_2},
    {pw3_bit8_ltc, pw3_add8_2, GND},
    {osc3_bit20, pw3_add8_2, GND},

    {osc3_bit21_1, pw3_add9_3, GND},
    {pw3_add9_3, pw3_add9_cout, pw3_add9_1},
    {pw3_bit9_fb, pw3_add9_1, GND},
    {pw3_add8_cout, pw3_add9_cout, pw3_add9_2},
    {pw3_bit9_fb, pw3_add9_2, GND},
    {pw3_add9_3, pw3_add9_2, GND},

    {osc3_bit22, pw3_add10_cout, pw3_add10_1},
    {pw3_bit10_ltc, pw3_add10_1, GND},
    {pw3_add9_cout, pw3_add10_cout, pw3_add10_2},
    {pw3_bit10_ltc, pw3_add10_2, GND},
    {osc3_bit22, pw3_add10_2, GND},

    {osc3_bit23_1, pw3_add11_3, GND},
    {pw3_add11_3, pw3_add11_cout, pw3_add11_1},
    {pw3_bit11_fb, pw3_add11_1, GND},
    {pw3_add10_cout, pw3_add11_cout, pw3_add11_2},
    {pw3_bit11_fb, pw3_add11_2, GND},
    {pw3_add11_3, pw3_add11_2, GND},

    // Pulse
    {sid_clk2, pw3_add11_cout, pul3_ltc1},
    {pul3_ltc1, pul3_1, GND},
    {ctl3_test, pul3_1, GND},
    {sid_clk1, pul3_1, pul3_ltc2},
    {pul3_ltc2, pul3_2, GND},
    {pul3_2, Vcc, pul_out},
    {pul3_ltc2, pul_out, GND},

    // Triangle XOR circuit selector
    {osc3_bit23_1, tri3_1, GND},
    {tri3_2, tri3_1, GND},
    {v2_bit23, tri3_2, GND},
    {tri3_3, tri3_2, GND},
    {ctl3_ring, tri3_3, GND},
    {tri3_1, tri3_xor, GND},
    {ctl3_saw, tri3_xor, GND},
    {osc3_bit23_1, tri3_xor, tri3_4},
    {tri3_2, tri3_4, GND},

    // Triangle
#ifndef MOS8580
    {tri3_xor, tri3_bit0_out, tri3_bit0_2},
    {osc3_bit12, tri3_bit0_2, GND},
    {tri3_bit0_1, tri3_bit0_out, GND},
    {tri3_xor, tri3_bit0_1, GND},
    {osc3_bit12, tri3_bit0_1, GND},

    {tri3_xor, tri3_bit1_out, tri3_bit1_2},
    {osc3_bit13_1, tri3_bit1_2, GND},
    {tri3_bit1_1, tri3_bit1_out, GND},
    {tri3_xor, tri3_bit1_1, GND},
    {osc3_bit13_1, tri3_bit1_1, GND},

    {tri3_xor, tri3_bit2_out, tri3_bit2_2},
    {osc3_bit14, tri3_bit2_2, GND},
    {tri3_bit2_1, tri3_bit2_out, GND},
    {tri3_xor, tri3_bit2_1, GND},
    {osc3_bit14, tri3_bit2_1, GND},

    {tri3_xor, tri3_bit3_out, tri3_bit3_2},
    {osc3_bit15_1, tri3_bit3_2, GND},
    {tri3_bit3_1, tri3_bit3_out, GND},
    {tri3_xor, tri3_bit3_1, GND},
    {osc3_bit15_1, tri3_bit3_1, GND},

    {tri3_xor, tri3_bit4_out, tri3_bit4_2},
    {osc3_bit16, tri3_bit4_2, GND},
    {tri3_bit4_1, tri3_bit4_out, GND},
    {tri3_xor, tri3_bit4_1, GND},
    {osc3_bit16, tri3_bit4_1, GND},

    {tri3_xor, tri3_bit5_out, tri3_bit5_2},
    {osc3_bit17_1, tri3_bit5_2, GND},
    {tri3_bit5_1, tri3_bit5_out, GND},
    {tri3_xor, tri3_bit5_1, GND},
    {osc3_bit17_1, tri3_bit5_1, GND},

    {tri3_xor, tri3_bit6_out, tri3_bit6_2},
    {osc3_bit18, tri3_bit6_2, GND},
    {tri3_bit6_1, tri3_bit6_out, GND},
    {tri3_xor, tri3_bit6_1, GND},
    {osc3_bit18, tri3_bit6_1, GND},

    {tri3_xor, tri3_bit7_out, tri3_bit7_2},
    {osc3_bit19_1, tri3_bit7_2, GND},
    {tri3_bit7_1, tri3_bit7_out, GND},
    {tri3_xor, tri3_bit7_1, GND},
    {osc3_bit19_1, tri3_bit7_1, GND},

    {tri3_xor, tri3_bit8_out, tri3_bit8_2},
    {osc3_bit20, tri3_bit8_2, GND},
    {tri3_bit8_1, tri3_bit8_out, GND},
    {tri3_xor, tri3_bit8_1, GND},
    {osc3_bit20, tri3_bit8_1, GND},

    {tri3_xor, tri3_bit9_out, tri3_bit9_2},
    {osc3_bit21_1, tri3_bit9_2, GND},
    {tri3_bit9_1, tri3_bit9_out, GND},
    {tri3_xor, tri3_bit9_1, GND},
    {osc3_bit21_1, tri3_bit9_1, GND},

    {tri3_xor, tri3_bit10_out, tri3_bit10_2},
    {osc3_bit22, tri3_bit10_2, GND},
    {tri3_bit10_1, tri3_bit10_out, GND},
    {tri3_xor, tri3_bit10_1, GND},
    {osc3_bit22, tri3_bit10_1, GND},
#else
    {osc3_bit12, tri3_bit0_1, GND},
    {tri3_xor, tri3_bit0_5, GND},
    {tri3_bit0_1, tri3_bit0_2, tri3_bit0_3},
    {tri3_xor, tri3_bit0_3, GND},
    {osc3_bit12, tri3_bit0_2, tri3_bit0_4},
    {tri3_bit0_5, tri3_bit0_4, GND},
    {sid_clk2, tri3_bit0_2, tri3_bit0_ltc},
    {tri3_bit0_ltc, tri3_bit0_out, GND},

    {osc3_bit13_1, tri3_bit1_1, GND},
    {tri3_xor, tri3_bit1_5, GND},
    {tri3_bit1_1, tri3_bit1_2, tri3_bit1_3},
    {tri3_xor, tri3_bit1_3, GND},
    {osc3_bit13_1, tri3_bit1_2, tri3_bit1_4},
    {tri3_bit1_5, tri3_bit1_4, GND},
    {sid_clk2, tri3_bit1_2, tri3_bit1_ltc},
    {tri3_bit1_ltc, tri3_bit1_out, GND},

    {osc3_bit14, tri3_bit2_1, GND},
    {tri3_xor, tri3_bit2_5, GND},
    {tri3_bit2_1, tri3_bit2_2, tri3_bit2_3},
    {tri3_xor, tri3_bit2_3, GND},
    {osc3_bit14, tri3_bit2_2, tri3_bit2_4},
    {tri3_bit2_5, tri3_bit2_4, GND},
    {sid_clk2, tri3_bit2_2, tri3_bit2_ltc},
    {tri3_bit2_ltc, tri3_bit2_out, GND},

    {osc3_bit15_1, tri3_bit3_1, GND},
    {tri3_xor, tri3_bit3_5, GND},
    {tri3_bit3_1, tri3_bit3_2, tri3_bit3_3},
    {tri3_xor, tri3_bit3_3, GND},
    {osc3_bit15_1, tri3_bit3_2, tri3_bit3_4},
    {tri3_bit3_5, tri3_bit3_4, GND},
    {sid_clk2, tri3_bit3_2, tri3_bit3_ltc},
    {tri3_bit3_ltc, tri3_bit3_out, GND},

    {osc3_bit16, tri3_bit4_1, GND},
    {tri3_xor, tri3_bit4_5, GND},
    {tri3_bit4_1, tri3_bit4_2, tri3_bit4_3},
    {tri3_xor, tri3_bit4_3, GND},
    {osc3_bit16, tri3_bit4_2, tri3_bit4_4},
    {tri3_bit4_5, tri3_bit4_4, GND},
    {sid_clk2, tri3_bit4_2, tri3_bit4_ltc},
    {tri3_bit4_ltc, tri3_bit4_out, GND},

    {osc3_bit17_1, tri3_bit5_1, GND},
    {tri3_xor, tri3_bit5_5, GND},
    {tri3_bit5_1, tri3_bit5_2, tri3_bit5_3},
    {tri3_xor, tri3_bit5_3, GND},
    {osc3_bit17_1, tri3_bit5_2, tri3_bit5_4},
    {tri3_bit5_5, tri3_bit5_4, GND},
    {sid_clk2, tri3_bit5_2, tri3_bit5_ltc},
    {tri3_bit5_ltc, tri3_bit5_out, GND},

    {osc3_bit18, tri3_bit6_1, GND},
    {tri3_xor, tri3_bit6_5, GND},
    {tri3_bit6_1, tri3_bit6_2, tri3_bit6_3},
    {tri3_xor, tri3_bit6_3, GND},
    {osc3_bit18, tri3_bit6_2, tri3_bit6_4},
    {tri3_bit6_5, tri3_bit6_4, GND},
    {sid_clk2, tri3_bit6_2, tri3_bit6_ltc},
    {tri3_bit6_ltc, tri3_bit6_out, GND},

    {osc3_bit19_1, tri3_bit7_1, GND},
    {tri3_xor, tri3_bit7_5, GND},
    {tri3_bit7_1, tri3_bit7_2, tri3_bit7_3},
    {tri3_xor, tri3_bit7_3, GND},
    {osc3_bit19_1, tri3_bit7_2, tri3_bit7_4},
    {tri3_bit7_5, tri3_bit7_4, GND},
    {sid_clk2, tri3_bit7_2, tri3_bit7_ltc},
    {tri3_bit7_ltc, tri3_bit7_out, GND},

    {osc3_bit20, tri3_bit8_1, GND},
    {tri3_xor, tri3_bit8_5, GND},
    {tri3_bit8_1, tri3_bit8_2, tri3_bit8_3},
    {tri3_xor, tri3_bit8_3, GND},
    {osc3_bit20, tri3_bit8_2, tri3_bit8_4},
    {tri3_bit8_5, tri3_bit8_4, GND},
    {sid_clk2, tri3_bit8_2, tri3_bit8_ltc},
    {tri3_bit8_ltc, tri3_bit8_out, GND},

    {osc3_bit21_1, tri3_bit9_1, GND},
    {tri3_xor, tri3_bit9_5, GND},
    {tri3_bit9_1, tri3_bit9_2, tri3_bit9_3},
    {tri3_xor, tri3_bit9_3, GND},
    {osc3_bit21_1, tri3_bit9_2, tri3_bit9_4},
    {tri3_bit9_5, tri3_bit9_4, GND},
    {sid_clk2, tri3_bit9_2, tri3_bit9_ltc},
    {tri3_bit9_ltc, tri3_bit9_out, GND},

    {osc3_bit22, tri3_bit10_1, GND},
    {tri3_xor, tri3_bit10_5, GND},
    {tri3_bit10_1, tri3_bit10_2, tri3_bit10_3},
    {tri3_xor, tri3_bit10_3, GND},
    {osc3_bit22, tri3_bit10_2, tri3_bit10_4},
    {tri3_bit10_5, tri3_bit10_4, GND},
    {sid_clk2, tri3_bit10_2, tri3_bit10_ltc},
    {tri3_bit10_ltc, tri3_bit10_out, GND},

    // Sawtooth bit23
    {osc3_bit23_1, saw3_bit23_1, GND},
    {sid_clk2, saw3_bit23_1, saw3_bit23_ltc},
    {saw3_bit23_ltc, saw3_bit23, GND},
#endif
    // Noise clock
    {sid_clk2, osc3_bit19_1, noi3_clk_ltc1},
    {noi3_clk_ltc1, noi3_clk1, GND},
    {sid_clk1, noi3_clk1, noi3_clk_ltc2},
    {noi3_clk_ltc2, noi3_clk2, GND},
    {sid_clk2, noi3_clk2, noi3_clk_ltc3},
    {noi3_clk_ltc3, noi3_clk3, GND},
    {sid_clk1, noi3_clk3, noi3_clk_ltc4},
    {noi3_clk_ltc4, noi3_clk, noi3_clk4},
    {noi3_clk2, noi3_clk4, GND},
    {sid_rst, noi3_clk, GND},

    {noi3_clk, noi3_clk10, GND},
    {sid_clk2, noi3_clk10, noi3_clk_ltc10},
    {noi3_clk_ltc10, noi3_clk_c2, GND},
    {noi3_clk10, noi3_clk_c2, GND},
    {noi3_clk10, noi3_clk_c1, GND},
    {noi3_clk_lc, noi3_clk_c1, GND},
    {noi3_clk_c1, noi3_clk_lc, GND},
    {noi3_clk, noi3_clk_lc, GND},

    {ctl3_test, noi3_clk, GND},

    // Noise lfsr
    {noi3_clk_lc, noi3_xor_out, noi3_bit0_ltc1},
    {noi3_bit0_ltc1, noi3_bit0_1, GND},
    {noi3_clk_c1, noi3_bit0_1, noi3_bit0_ltc2},
    {noi3_bit0_ltc2, noi3_bit0_out, GND},
    {noi3_clk_c2, noi3_bit0_out, noi3_bit0_ltc1},

    {noi3_clk_lc, noi3_bit0_out, noi3_bit1_ltc1},
    {noi3_bit1_ltc1, noi3_bit1_1, GND},
    {noi3_clk_c1, noi3_bit1_1, noi3_bit1_ltc2},
    {noi3_bit1_ltc2, noi3_bit1_out, GND},
    {noi3_clk_c2, noi3_bit1_out, noi3_bit1_ltc1},

    {noi3_clk_lc, noi3_bit1_out, noi3_bit2_ltc1},
    {noi3_bit2_ltc1, noi3_bit2_1, GND},
    {noi3_clk_c1, noi3_bit2_1, noi3_bit2_ltc2},
    {noi3_bit2_ltc2, noi3_bit2_out, GND},
    {noi3_clk_c2, noi3_bit2_out, noi3_bit2_ltc1},

    {noi3_clk_lc, noi3_bit2_out, noi3_bit3_ltc1},
    {noi3_bit3_ltc1, noi3_bit3_1, GND},
    {noi3_clk_c1, noi3_bit3_1, noi3_bit3_ltc2},
    {noi3_bit3_ltc2, noi3_bit3_out, GND},
    {noi3_clk_c2, noi3_bit3_out, noi3_bit3_ltc1},

    {noi3_clk_lc, noi3_bit3_out, noi3_bit4_ltc1},
    {noi3_bit4_ltc1, noi3_bit4_1, GND},
    {noi3_clk_c1, noi3_bit4_1, noi3_bit4_ltc2},
    {noi3_bit4_ltc2, noi3_bit4_out, GND},
    {noi3_clk_c2, noi3_bit4_out, noi3_bit4_ltc1},

    {noi3_clk_lc, noi3_bit4_out, noi3_bit5_ltc1},
    {noi3_bit5_ltc1, noi3_bit5_1, GND},
    {noi3_clk_c1, noi3_bit5_1, noi3_bit5_ltc2},
    {noi3_bit5_ltc2, noi3_bit5_out, GND},
    {noi3_clk_c2, noi3_bit5_out, noi3_bit5_ltc1},

    {noi3_clk_lc, noi3_bit5_out, noi3_bit6_ltc1},
    {noi3_bit6_ltc1, noi3_bit6_1, GND},
    {noi3_clk_c1, noi3_bit6_1, noi3_bit6_ltc2},
    {noi3_bit6_ltc2, noi3_bit6_out, GND},
    {noi3_clk_c2, noi3_bit6_out, noi3_bit6_ltc1},

    {noi3_clk_lc, noi3_bit6_out, noi3_bit7_ltc1},
    {noi3_bit7_ltc1, noi3_bit7_1, GND},
    {noi3_clk_c1, noi3_bit7_1, noi3_bit7_ltc2},
    {noi3_bit7_ltc2, noi3_bit7_out, GND},
    {noi3_clk_c2, noi3_bit7_out, noi3_bit7_ltc1},

    {noi3_clk_lc, noi3_bit7_out, noi3_bit8_ltc1},
    {noi3_bit8_ltc1, noi3_bit8_1, GND},
    {noi3_clk_c1, noi3_bit8_1, noi3_bit8_ltc2},
    {noi3_bit8_ltc2, noi3_bit8_out, GND},
    {noi3_clk_c2, noi3_bit8_out, noi3_bit8_ltc1},

    {noi3_clk_lc, noi3_bit8_out, noi3_bit9_ltc1},
    {noi3_bit9_ltc1, noi3_bit9_1, GND},
    {noi3_clk_c1, noi3_bit9_1, noi3_bit9_ltc2},
    {noi3_bit9_ltc2, noi3_bit9_out, GND},
    {noi3_clk_c2, noi3_bit9_out, noi3_bit9_ltc1},

    {noi3_clk_lc, noi3_bit9_out, noi3_bit10_ltc1},
    {noi3_bit10_ltc1, noi3_bit10_1, GND},
    {noi3_clk_c1, noi3_bit10_1, noi3_bit10_ltc2},
    {noi3_bit10_ltc2, noi3_bit10_out, GND},
    {noi3_clk_c2, noi3_bit10_out, noi3_bit10_ltc1},

    {noi3_clk_lc, noi3_bit10_out, noi3_bit11_ltc1},
    {noi3_bit11_ltc1, noi3_bit11_1, GND},
    {noi3_clk_c1, noi3_bit11_1, noi3_bit11_ltc2},
    {noi3_bit11_ltc2, noi3_bit11_out, GND},
    {noi3_clk_c2, noi3_bit11_out, noi3_bit11_ltc1},

    {noi3_clk_lc, noi3_bit11_out, noi3_bit12_ltc1},
    {noi3_bit12_ltc1, noi3_bit12_1, GND},
    {noi3_clk_c1, noi3_bit12_1, noi3_bit12_ltc2},
    {noi3_bit12_ltc2, noi3_bit12_out, GND},
    {noi3_clk_c2, noi3_bit12_out, noi3_bit12_ltc1},

    {noi3_clk_lc, noi3_bit12_out, noi3_bit13_ltc1},
    {noi3_bit13_ltc1, noi3_bit13_1, GND},
    {noi3_clk_c1, noi3_bit13_1, noi3_bit13_ltc2},
    {noi3_bit13_ltc2, noi3_bit13_out, GND},
    {noi3_clk_c2, noi3_bit13_out, noi3_bit13_ltc1},

    {noi3_clk_lc, noi3_bit13_out, noi3_bit14_ltc1},
    {noi3_bit14_ltc1, noi3_bit14_1, GND},
    {noi3_clk_c1, noi3_bit14_1, noi3_bit14_ltc2},
    {noi3_bit14_ltc2, noi3_bit14_out, GND},
    {noi3_clk_c2, noi3_bit14_out, noi3_bit14_ltc1},

    {noi3_clk_lc, noi3_bit14_out, noi3_bit15_ltc1},
    {noi3_bit15_ltc1, noi3_bit15_1, GND},
    {noi3_clk_c1, noi3_bit15_1, noi3_bit15_ltc2},
    {noi3_bit15_ltc2, noi3_bit15_out, GND},
    {noi3_clk_c2, noi3_bit15_out, noi3_bit15_ltc1},

    {noi3_clk_lc, noi3_bit15_out, noi3_bit16_ltc1},
    {noi3_bit16_ltc1, noi3_bit16_1, GND},
    {noi3_clk_c1, noi3_bit16_1, noi3_bit16_ltc2},
    {noi3_bit16_ltc2, noi3_bit16_out, GND},
    {noi3_clk_c2, noi3_bit16_out, noi3_bit16_ltc1},

    {noi3_clk_lc, noi3_bit16_out, noi3_bit17_ltc1},
    {noi3_bit17_ltc1, noi3_bit17_1, GND},
    {noi3_clk_c1, noi3_bit17_1, noi3_bit17_ltc2},
    {noi3_bit17_ltc2, noi3_bit17_out, GND},
    {noi3_clk_c2, noi3_bit17_out, noi3_bit17_ltc1},

    {noi3_clk_lc, noi3_bit17_out, noi3_bit18_ltc1},
    {noi3_bit18_ltc1, noi3_bit18_1, GND},
    {noi3_clk_c1, noi3_bit18_1, noi3_bit18_ltc2},
    {noi3_bit18_ltc2, noi3_bit18_out, GND},
    {noi3_clk_c2, noi3_bit18_out, noi3_bit18_ltc1},

    {noi3_clk_lc, noi3_bit18_out, noi3_bit19_ltc1},
    {noi3_bit19_ltc1, noi3_bit19_1, GND},
    {noi3_clk_c1, noi3_bit19_1, noi3_bit19_ltc2},
    {noi3_bit19_ltc2, noi3_bit19_out, GND},
    {noi3_clk_c2, noi3_bit19_out, noi3_bit19_ltc1},

    {noi3_clk_lc, noi3_bit19_out, noi3_bit20_ltc1},
    {noi3_bit20_ltc1, noi3_bit20_1, GND},
    {noi3_clk_c1, noi3_bit20_1, noi3_bit20_ltc2},
    {noi3_bit20_ltc2, noi3_bit20_out, GND},
    {noi3_clk_c2, noi3_bit20_out, noi3_bit20_ltc1},

    {noi3_clk_lc, noi3_bit20_out, noi3_bit21_ltc1},
    {noi3_bit21_ltc1, noi3_bit21_1, GND},
    {noi3_clk_c1, noi3_bit21_1, noi3_bit21_ltc2},
    {noi3_bit21_ltc2, noi3_bit21_out, GND},
    {noi3_clk_c2, noi3_bit21_out, noi3_bit21_ltc1},

    {noi3_clk_lc, noi3_bit21_out, noi3_bit22_ltc1},
    {noi3_bit22_ltc1, noi3_bit22_1, GND},
    {noi3_clk_c1, noi3_bit22_1, noi3_bit22_ltc2},
    {noi3_bit22_ltc2, noi3_bit22_out, GND},
    {noi3_clk_c2, noi3_bit22_out, noi3_bit22_ltc1},

    {noi3_clk_lc, noi3_bit22_out, noi3_bit23_ltc1},
    {noi3_bit23_ltc1, noi3_bit23_1, GND},
    {noi3_clk_c1, noi3_bit23_1, noi3_bit23_ltc2},
    {noi3_bit23_ltc2, noi3_bit23_out, GND},
    {noi3_clk_c2, noi3_bit23_out, noi3_bit23_ltc1},

    // Noise XOR
    {sid_clk2, sid_rst, noi3_xor_ltc1},
    {sid_clk2, ctl3_test, noi3_xor_ltc2},
    {noi3_xor_ltc1, noi3_xor_1, GND},
    {noi3_xor_ltc2, noi3_xor_1, GND},
    {noi3_bit22_out, noi3_xor_1, GND},
    {noi3_xor_1, noi3_xor_2, GND},
    {noi3_xor_2, noi3_xor_3, GND},
    {noi3_bit17_out, noi3_xor_3, GND},
    {noi3_xor_3, noi3_xor_out, GND},
    {noi3_bit17_out, noi3_xor_out, noi3_xor_4},
    {noi3_xor_2, noi3_xor_4, GND},

    // Waveform selector
    {ctl3_tri, GND, voi3_bit0},
    {ctl3_noise, GND, voi3_bit0},
    {ctl3_pulse, pul_out, voi3_bit0},
    {ctl3_saw, tri3_bit0_out, voi3_bit0},

    {ctl3_tri, tri3_bit0_out, voi3_bit1},
    {ctl3_noise, GND, voi3_bit1},
    {ctl3_pulse, pul_out, voi3_bit1},
    {ctl3_saw, tri3_bit1_out, voi3_bit1},

    {ctl3_tri, tri3_bit1_out, voi3_bit2},
    {ctl3_noise, GND, voi3_bit2},
    {ctl3_pulse, pul_out, voi3_bit2},
    {ctl3_saw, tri3_bit2_out, voi3_bit2},

    {ctl3_tri, tri3_bit2_out, voi3_bit3},
    {ctl3_noise, GND, voi3_bit3},
    {ctl3_pulse, pul_out, voi3_bit3},
    {ctl3_saw, tri3_bit3_out, voi3_bit3},

    {ctl3_tri, tri3_bit3_out, voi3_bit4},
    {ctl3_noise, noi3_bit0_out, voi3_bit4},
    {ctl3_pulse, pul_out, voi3_bit4},
    {ctl3_saw, tri3_bit4_out, voi3_bit4},

    {ctl3_tri, tri3_bit4_out, voi3_bit5},
    {ctl3_noise, noi3_bit2_out, voi3_bit5},
    {ctl3_pulse, pul_out, voi3_bit5},
    {ctl3_saw, tri3_bit5_out, voi3_bit5},

    {ctl3_tri, tri3_bit5_out, voi3_bit6},
    {ctl3_noise, noi3_bit5_out, voi3_bit6},
    {ctl3_pulse, pul_out, voi3_bit6},
    {ctl3_saw, tri3_bit6_out, voi3_bit6},

    {ctl3_tri, tri3_bit6_out, voi3_bit7},
    {ctl3_noise, noi3_bit9_out, voi3_bit7},
    {ctl3_pulse, pul_out, voi3_bit7},
    {ctl3_saw, tri3_bit7_out, voi3_bit7},

    {ctl3_tri, tri3_bit7_out, voi3_bit8},
    {ctl3_noise, noi3_bit11_out, voi3_bit8},
    {ctl3_pulse, pul_out, voi3_bit8},
    {ctl3_saw, tri3_bit8_out, voi3_bit8},

    {ctl3_tri, tri3_bit8_out, voi3_bit9},
    {ctl3_noise, noi3_bit14_out, voi3_bit9},
    {ctl3_pulse, pul_out, voi3_bit9},
    {ctl3_saw, tri3_bit9_out, voi3_bit9},

    {ctl3_tri, tri3_bit9_out, voi3_bit10},
    {ctl3_noise, noi3_bit18_out, voi3_bit10},
    {ctl3_pulse, pul_out, voi3_bit10},
    {ctl3_saw, tri3_bit10_out, voi3_bit10},

    {ctl3_tri, tri3_bit10_out, voi3_bit11},
    {ctl3_noise, noi3_bit20_out, voi3_bit11},
    {ctl3_pulse, pul_out, voi3_bit11},
    {ctl3_saw, osc3_bit23_1, voi3_bit11},

    // Waveform output
    {voi3_bit0, wav3_bit0_1, GND},
    {wav3_bit0_1, wav3_bit0_2, GND},
    {wav3_bit0_2, Vcc, wav3_bit0_out},
    {wav3_bit0_1, wav3_bit0_out, GND},

    {voi3_bit1, wav3_bit1_1, GND},
    {wav3_bit1_1, wav3_bit1_2, GND},
    {wav3_bit1_2, Vcc, wav3_bit1_out},
    {wav3_bit1_1, wav3_bit1_out, GND},

    {voi3_bit2, wav3_bit2_1, GND},
    {wav3_bit2_1, wav3_bit2_2, GND},
    {wav3_bit2_2, Vcc, wav3_bit2_out},
    {wav3_bit2_1, wav3_bit2_out, GND},

    {voi3_bit3, wav3_bit3_1, GND},
    {wav3_bit3_1, wav3_bit3_2, GND},
    {wav3_bit3_2, Vcc, wav3_bit3_out},
    {wav3_bit3_1, wav3_bit3_out, GND},

    {voi3_bit4, wav3_bit4_1, GND},
    {wav3_bit4_1, wav3_bit4_2, GND},
    {wav3_bit4_2, Vcc, wav3_bit4_out},
    {wav3_bit4_1, wav3_bit4_out, GND},

    {voi3_bit5, wav3_bit5_1, GND},
    {wav3_bit5_1, wav3_bit5_2, GND},
    {wav3_bit5_2, Vcc, wav3_bit5_out},
    {wav3_bit5_1, wav3_bit5_out, GND},

    {voi3_bit6, wav3_bit6_1, GND},
    {wav3_bit6_1, wav3_bit6_2, GND},
    {wav3_bit6_2, Vcc, wav3_bit6_out},
    {wav3_bit6_1, wav3_bit6_out, GND},

    {voi3_bit7, wav3_bit7_1, GND},
    {wav3_bit7_1, wav3_bit7_2, GND},
    {wav3_bit7_2, Vcc, wav3_bit7_out},
    {wav3_bit7_1, wav3_bit7_out, GND},

    {voi3_bit8, wav3_bit8_1, GND},
    {wav3_bit8_1, wav3_bit8_2, GND},
    {wav3_bit8_2, Vcc, wav3_bit8_out},
    {wav3_bit8_1, wav3_bit8_out, GND},

    {voi3_bit9, wav3_bit9_1, GND},
    {wav3_bit9_1, wav3_bit9_2, GND},
    {wav3_bit9_2, Vcc, wav3_bit9_out},
    {wav3_bit9_1, wav3_bit9_out, GND},

    {voi3_bit10, wav3_bit10_1, GND},
    {wav3_bit10_1, wav3_bit10_2, GND},
    {wav3_bit10_2, Vcc, wav3_bit10_out},
    {wav3_bit10_1, wav3_bit10_out, GND},

    {voi3_bit11, wav3_bit11_1, GND},
    {wav3_bit11_1, wav3_bit11_2, GND},
    {wav3_bit11_2, Vcc, wav3_bit11_out},
    {wav3_bit11_1, wav3_bit11_out, GND},

    // OSC3 register
    {sid_clk1, wav3_bit4_out, reg_osc3_bit0_ltc1},
    {reg_osc3_bit0_ltc1, reg_osc3_bit0_1, GND},
    {reg_osc3_bit0_1, reg_osc3_bit0_2, GND},
    {reg_osc3_bit0_2, Vcc, reg_osc3_bit0_3},
    {reg_osc3_bit0_1, reg_osc3_bit0_3, GND},
    {reg1B, reg_osc3_bit0_3, db0},

    {sid_clk1, wav3_bit5_out, reg_osc3_bit1_ltc1},
    {reg_osc3_bit1_ltc1, reg_osc3_bit1_1, GND},
    {reg_osc3_bit1_1, reg_osc3_bit1_2, GND},
    {reg_osc3_bit1_2, Vcc, reg_osc3_bit1_3},
    {reg_osc3_bit1_1, reg_osc3_bit1_3, GND},
    {reg1B, reg_osc3_bit1_3, db1},

    {sid_clk1, wav3_bit6_out, reg_osc3_bit2_ltc1},
    {reg_osc3_bit2_ltc1, reg_osc3_bit2_1, GND},
    {reg_osc3_bit2_1, reg_osc3_bit2_2, GND},
    {reg_osc3_bit2_2, Vcc, reg_osc3_bit2_3},
    {reg_osc3_bit2_1, reg_osc3_bit2_3, GND},
    {reg1B, reg_osc3_bit2_3, db2},

    {sid_clk1, wav3_bit7_out, reg_osc3_bit3_ltc1},
    {reg_osc3_bit3_ltc1, reg_osc3_bit3_1, GND},
    {reg_osc3_bit3_1, reg_osc3_bit3_2, GND},
    {reg_osc3_bit3_2, Vcc, reg_osc3_bit3_3},
    {reg_osc3_bit3_1, reg_osc3_bit3_3, GND},
    {reg1B, reg_osc3_bit3_3, db3},

    {sid_clk1, wav3_bit8_out, reg_osc3_bit4_ltc1},
    {reg_osc3_bit4_ltc1, reg_osc3_bit4_1, GND},
    {reg_osc3_bit4_1, reg_osc3_bit4_2, GND},
    {reg_osc3_bit4_2, Vcc, reg_osc3_bit4_3},
    {reg_osc3_bit4_1, reg_osc3_bit4_3, GND},
    {reg1B, reg_osc3_bit4_3, db4},

    {sid_clk1, wav3_bit9_out, reg_osc3_bit5_ltc1},
    {reg_osc3_bit5_ltc1, reg_osc3_bit5_1, GND},
    {reg_osc3_bit5_1, reg_osc3_bit5_2, GND},
    {reg_osc3_bit5_2, Vcc, reg_osc3_bit5_3},
    {reg_osc3_bit5_1, reg_osc3_bit5_3, GND},
    {reg1B, reg_osc3_bit5_3, db5},

    {sid_clk1, wav3_bit10_out, reg_osc3_bit6_ltc1},
    {reg_osc3_bit6_ltc1, reg_osc3_bit6_1, GND},
    {reg_osc3_bit6_1, reg_osc3_bit6_2, GND},
    {reg_osc3_bit6_2, Vcc, reg_osc3_bit6_3},
    {reg_osc3_bit6_1, reg_osc3_bit6_3, GND},
    {reg1B, reg_osc3_bit6_3, db6},

    {sid_clk1, wav3_bit11_out, reg_osc3_bit7_ltc1},
    {reg_osc3_bit7_ltc1, reg_osc3_bit7_1, GND},
    {reg_osc3_bit7_1, reg_osc3_bit7_2, GND},
    {reg_osc3_bit7_2, Vcc, reg_osc3_bit7_3},
    {reg_osc3_bit7_1, reg_osc3_bit7_3, GND},
    {reg1B, reg_osc3_bit7_3, db7},

    // counting direction
    {ctl3_gate, env3_cd01, GND},
    {sid_clk2, env3_cd01, env3_cd02},
    {env3_cd02, env3_gate_cur, GND},
    {sid_clk1, env3_gate_cur, env3_cd03},
    {env3_cd03, env3_cd04, GND},
    {sid_clk2, env3_cd04, env3_gate_prev_inv},
    {env3_gate_cur, env3_cd05, env3_cd06},
    {env3_cd04, env3_cd06, GND},
    {env3_cnt_dir, env3_cd05, GND},
    {sid_clk1, env3_0xFF, env3_cd10},
    {env3_cd10, env3_cd11, GND},
    {sid_clk2, env3_cd11, env3_cd12},
    {env3_cd12, env3_cd13, GND},
    {sid_clk1, env3_cd13, env3_cd14},
    {env3_cd14, env3_cd15, GND},
    {env3_cd13, env3_cnt_dir, env3_cd07},
    {env3_cd15, env3_cd07, GND},
    {env3_cd02, env3_cnt_dir, GND},
    {env3_cd05, env3_cnt_dir, GND},

    {sid_clk1, env3_cnt_dir, env3_cd20},
    {env3_cd20, env3_cd21, GND},
    {env3_cd21, env3_cd50, GND},
    {env3_cd50, Vcc, env3_r0},
    {env3_cd21, env3_r0, GND},
    {sid_clk2, env3_cd21, env3_cd22},
    {env3_cd22, env3_cd23, GND},
    {sid_clk1, env3_cd23, env3_cd24},
    {env3_cd24, env3_cd26, env3_cd27},
    {env3_cd21, env3_cd27, GND},
    {sid_clk1, env3_cnt_dir, env3_cd25},
    {env3_cd25, env3_cd26, env3_cd28},
    {env3_cnt_down, env3_cd28, GND},
    {env3_cd24, env3_cd30, GND},
    {env3_cd30, Vcc, env3_cnt_down},
    {env3_cd24, env3_cnt_down, GND},
    {env3_cnt_down, env3_cd31, GND},
    {env3_cd31, Vcc, env3_cnt_up},
    {env3_cnt_down, env3_cnt_up, GND},
    {env3_cd26, env3_cd40, GND},
    {sid_clk1, env3_cd40, env3_cd41},
    {env3_cd41, sid_clk2, env3_cnt_clk_inv},
    {env3_cd26, env3_cnt_clk_inv, GND},
    {sid_clk1, env3_cnt_clk_inv, GND},
    {sid_clk1, env3_cd26, env3_cd42},
    {env3_cd42, sid_clk2, env3_cnt_clk},
    {env3_cd40, env3_cnt_clk, GND},
    {sid_clk1, env3_cnt_clk, GND},

    {sid_clk1, env3_0x00, env3_ce01},
    {env3_ce01, env3_ce02, GND},
    {sid_clk2, env3_ce02, env3_ce03},
    {env3_ce03, env3_ce04, GND},
    {sid_clk1, env3_ce04, env3_ce05},
    {env3_ce05, env3_ce06, GND},
    {env3_ce04, env3_ce07, env3_ce08},
    {env3_ce06, env3_ce08, GND},
    {env3_ce10, env3_ce07, GND},
    {env3_gate_cur, env3_ce10, env3_ce11},
    {env3_gate_prev_inv, env3_ce11, GND},
    {sid_rst, env3_ce10, GND},
    {env3_ce07, env3_ce10, GND},
    {sid_clk1, env3_ce10, env3_ce12},
    {env3_ce12, env3_cnt_ena, GND},
    {env3_lfsrB_rst_rel, env3_cnt_ena, GND},
    {env3_cnt_sus, env3_cnt_ena, GND},
    {sid_clk2, env3_cnt_ena, env3_ce13},
    {env3_ce13, env3_cnt_cry0, GND},

    // counter
    {env3_cnt_cry0, env3_bit0_Cout, GND},
    {env3_bit0_add6, env3_bit0_Cout, GND},
    {env3_bit0_Cout, env3_bit0_add1, GND},
    {env3_bit0_add6, env3_bit0_add1, env3_bit0_add3},
    {env3_cnt_cry0, env3_bit0_add3, GND},
    {sid_clk1, env3_bit0_add1, env3_bit0_add2},
    {env3_bit0_add2, env3_bit0_add4, GND},
    {env3_cnt_clk, env3_bit0_add4, env3_bit0_add6},
    {env3_bit0_add4, env3_bit0_add5, GND},
    {env3_cnt_clk_inv, env3_bit0_add5, env3_bit0_add6},
    {env3_bit0_add5, env3_bit0_cnt, env3_bit0_xor1},
    {env3_cnt_down, env3_bit0_xor1, GND},
    {env3_cnt_up, env3_bit0_cnt, env3_bit0_xor2},
    {env3_bit0_add4, env3_bit0_xor2, GND},
    {sid_clk2, env3_bit0_cnt, env3_bit0_ltc},
    {env3_bit0_ltc, env3_bit0_out_inv, GND},
    {env3_bit0_out_inv, env3_bit0_out, GND},

    {env3_bit0_Cout, env3_bit1_Cout, env3_bit1_add7},
    {env3_bit1_add6, env3_bit1_add7, GND},
    {env3_bit1_Cout, env3_bit1_add1, env3_bit1_add3},
    {env3_bit1_add6, env3_bit1_add3, GND},
    {env3_bit0_Cout, env3_bit1_add3, GND},
    {sid_clk1, env3_bit1_add1, env3_bit1_add2},
    {env3_bit1_add2, env3_bit1_add4, GND},
    {env3_cnt_clk, env3_bit1_add4, env3_bit1_add6},
    {env3_bit1_add4, env3_bit1_add5, GND},
    {env3_cnt_clk_inv, env3_bit1_add5, env3_bit1_add6},
    {env3_bit1_add5, env3_bit1_cnt, env3_bit1_xor1},
    {env3_cnt_down, env3_bit1_xor1, GND},
    {env3_cnt_up, env3_bit1_cnt, env3_bit1_xor2},
    {env3_bit1_add4, env3_bit1_xor2, GND},
    {sid_clk2, env3_bit1_cnt, env3_bit1_ltc},
    {env3_bit1_ltc, env3_bit1_out, GND},
    {env3_bit1_out, env3_bit1_out_inv, GND},

    {env3_bit1_Cout, env3_bit2_Cout, GND},
    {env3_bit2_add6, env3_bit2_Cout, GND},
    {env3_bit2_Cout, env3_bit2_add1, GND},
    {env3_bit2_add6, env3_bit2_add1, env3_bit2_add3},
    {env3_bit1_Cout, env3_bit2_add3, GND},
    {sid_clk1, env3_bit2_add1, env3_bit2_add2},
    {env3_bit2_add2, env3_bit2_add4, GND},
    {env3_cnt_clk, env3_bit2_add4, env3_bit2_add6},
    {env3_bit2_add4, env3_bit2_add5, GND},
    {env3_cnt_clk_inv, env3_bit2_add5, env3_bit2_add6},
    {env3_bit2_add5, env3_bit2_cnt, env3_bit2_xor1},
    {env3_cnt_down, env3_bit2_xor1, GND},
    {env3_cnt_up, env3_bit2_cnt, env3_bit2_xor2},
    {env3_bit2_add4, env3_bit2_xor2, GND},
    {sid_clk2, env3_bit2_cnt, env3_bit2_ltc},
    {env3_bit2_ltc, env3_bit2_out_inv, GND},
    {env3_bit2_out_inv, env3_bit2_out, GND},

    {env3_bit2_Cout, env3_bit3_Cout, env3_bit3_add7},
    {env3_bit3_add6, env3_bit3_add7, GND},
    {env3_bit3_Cout, env3_bit3_add1, env3_bit3_add3},
    {env3_bit3_add6, env3_bit3_add3, GND},
    {env3_bit2_Cout, env3_bit3_add3, GND},
    {sid_clk1, env3_bit3_add1, env3_bit3_add2},
    {env3_bit3_add2, env3_bit3_add4, GND},
    {env3_cnt_clk, env3_bit3_add4, env3_bit3_add6},
    {env3_bit3_add4, env3_bit3_add5, GND},
    {env3_cnt_clk_inv, env3_bit3_add5, env3_bit3_add6},
    {env3_bit3_add5, env3_bit3_cnt, env3_bit3_xor1},
    {env3_cnt_down, env3_bit3_xor1, GND},
    {env3_cnt_up, env3_bit3_cnt, env3_bit3_xor2},
    {env3_bit3_add4, env3_bit3_xor2, GND},
    {sid_clk2, env3_bit3_cnt, env3_bit3_ltc},
    {env3_bit3_ltc, env3_bit3_out, GND},
    {env3_bit3_out, env3_bit3_out_inv, GND},

    {env3_bit3_Cout, env3_bit4_Cout, GND},
    {env3_bit4_add6, env3_bit4_Cout, GND},
    {env3_bit4_Cout, env3_bit4_add1, GND},
    {env3_bit4_add6, env3_bit4_add1, env3_bit4_add3},
    {env3_bit3_Cout, env3_bit4_add3, GND},
    {sid_clk1, env3_bit4_add1, env3_bit4_add2},
    {env3_bit4_add2, env3_bit4_add4, GND},
    {env3_cnt_clk, env3_bit4_add4, env3_bit4_add6},
    {env3_bit4_add4, env3_bit4_add5, GND},
    {env3_cnt_clk_inv, env3_bit4_add5, env3_bit4_add6},
    {env3_bit4_add5, env3_bit4_cnt, env3_bit4_xor1},
    {env3_cnt_down, env3_bit4_xor1, GND},
    {env3_cnt_up, env3_bit4_cnt, env3_bit4_xor2},
    {env3_bit4_add4, env3_bit4_xor2, GND},
    {sid_clk2, env3_bit4_cnt, env3_bit4_ltc},
    {env3_bit4_ltc, env3_bit4_out_inv, GND},
    {env3_bit4_out_inv, env3_bit4_out, GND},

    {env3_bit4_Cout, env3_bit5_Cout, env3_bit5_add7},
    {env3_bit5_add6, env3_bit5_add7, GND},
    {env3_bit5_Cout, env3_bit5_add1, env3_bit5_add3},
    {env3_bit5_add6, env3_bit5_add3, GND},
    {env3_bit4_Cout, env3_bit5_add3, GND},
    {sid_clk1, env3_bit5_add1, env3_bit5_add2},
    {env3_bit5_add2, env3_bit5_add4, GND},
    {env3_cnt_clk, env3_bit5_add4, env3_bit5_add6},
    {env3_bit5_add4, env3_bit5_add5, GND},
    {env3_cnt_clk_inv, env3_bit5_add5, env3_bit5_add6},
    {env3_bit5_add5, env3_bit5_cnt, env3_bit5_xor1},
    {env3_cnt_down, env3_bit5_xor1, GND},
    {env3_cnt_up, env3_bit5_cnt, env3_bit5_xor2},
    {env3_bit5_add4, env3_bit5_xor2, GND},
    {sid_clk2, env3_bit5_cnt, env3_bit5_ltc},
    {env3_bit5_ltc, env3_bit5_out, GND},
    {env3_bit5_out, env3_bit5_out_inv, GND},

    {env3_bit5_Cout, env3_bit6_Cout, GND},
    {env3_bit6_add6, env3_bit6_Cout, GND},
    {env3_bit6_Cout, env3_bit6_add1, GND},
    {env3_bit6_add6, env3_bit6_add1, env3_bit6_add3},
    {env3_bit5_Cout, env3_bit6_add3, GND},
    {sid_clk1, env3_bit6_add1, env3_bit6_add2},
    {env3_bit6_add2, env3_bit6_add4, GND},
    {env3_cnt_clk, env3_bit6_add4, env3_bit6_add6},
    {env3_bit6_add4, env3_bit6_add5, GND},
    {env3_cnt_clk_inv, env3_bit6_add5, env3_bit6_add6},
    {env3_bit6_add5, env3_bit6_cnt, env3_bit6_xor1},
    {env3_cnt_down, env3_bit6_xor1, GND},
    {env3_cnt_up, env3_bit6_cnt, env3_bit6_xor2},
    {env3_bit6_add4, env3_bit6_xor2, GND},
    {sid_clk2, env3_bit6_cnt, env3_bit6_ltc},
    {env3_bit6_ltc, env3_bit6_out_inv, GND},
    {env3_bit6_out_inv, env3_bit6_out, GND},

    {env3_bit6_Cout, env3_bit7_Cout, env3_bit7_add7},
    {env3_bit7_add6, env3_bit7_add7, GND},
    {env3_bit7_Cout, env3_bit7_add1, env3_bit7_add3},
    {env3_bit7_add6, env3_bit7_add3, GND},
    {env3_bit6_Cout, env3_bit7_add3, GND},
    {sid_clk1, env3_bit7_add1, env3_bit7_add2},
    {env3_bit7_add2, env3_bit7_add4, GND},
    {env3_cnt_clk, env3_bit7_add4, env3_bit7_add6},
    {env3_bit7_add4, env3_bit7_add5, GND},
    {env3_cnt_clk_inv, env3_bit7_add5, env3_bit7_add6},
    {env3_bit7_add5, env3_bit7_cnt, env3_bit7_xor1},
    {env3_cnt_down, env3_bit7_xor1, GND},
    {env3_cnt_up, env3_bit7_cnt, env3_bit7_xor2},
    {env3_bit7_add4, env3_bit7_xor2, GND},
    {sid_clk2, env3_bit7_cnt, env3_bit7_ltc},
    {env3_bit7_ltc, env3_bit7_out, GND},
    {env3_bit7_out, env3_bit7_out_inv, GND},

    {env3_bit0_out, env3_0x00, GND},
    {env3_bit1_out, env3_0x00, GND},
    {env3_bit2_out, env3_0x00, GND},
    {env3_bit3_out, env3_0x00, GND},
    {env3_bit4_out, env3_0x00, GND},
    {env3_bit5_out, env3_0x00, GND},
    {env3_bit6_out, env3_0x00, GND},
    {env3_bit7_out, env3_0x00, GND},

    {env3_bit0_out, env3_0x06, GND},
    {env3_bit1_out_inv, env3_0x06, GND},
    {env3_bit2_out_inv, env3_0x06, GND},
    {env3_bit3_out, env3_0x06, GND},
    {env3_bit4_out, env3_0x06, GND},
    {env3_bit5_out, env3_0x06, GND},
    {env3_bit6_out, env3_0x06, GND},
    {env3_bit7_out, env3_0x06, GND},

    {env3_bit0_out, env3_0x0E, GND},
    {env3_bit1_out_inv, env3_0x0E, GND},
    {env3_bit2_out_inv, env3_0x0E, GND},
    {env3_bit3_out_inv, env3_0x0E, GND},
    {env3_bit4_out, env3_0x0E, GND},
    {env3_bit5_out, env3_0x0E, GND},
    {env3_bit6_out, env3_0x0E, GND},
    {env3_bit7_out, env3_0x0E, GND},

    {env3_bit0_out, env3_0x1A, GND},
    {env3_bit1_out_inv, env3_0x1A, GND},
    {env3_bit2_out, env3_0x1A, GND},
    {env3_bit3_out_inv, env3_0x1A, GND},
    {env3_bit4_out_inv, env3_0x1A, GND},
    {env3_bit5_out, env3_0x1A, GND},
    {env3_bit6_out, env3_0x1A, GND},
    {env3_bit7_out, env3_0x1A, GND},

    {env3_bit0_out, env3_0x36, GND},
    {env3_bit1_out_inv, env3_0x36, GND},
    {env3_bit2_out_inv, env3_0x36, GND},
    {env3_bit3_out, env3_0x36, GND},
    {env3_bit4_out_inv, env3_0x36, GND},
    {env3_bit5_out_inv, env3_0x36, GND},
    {env3_bit6_out, env3_0x36, GND},
    {env3_bit7_out, env3_0x36, GND},

    {env3_bit0_out_inv, env3_0x5D, GND},
    {env3_bit1_out, env3_0x5D, GND},
    {env3_bit2_out_inv, env3_0x5D, GND},
    {env3_bit3_out_inv, env3_0x5D, GND},
    {env3_bit4_out_inv, env3_0x5D, GND},
    {env3_bit5_out, env3_0x5D, GND},
    {env3_bit6_out_inv, env3_0x5D, GND},
    {env3_bit7_out, env3_0x5D, GND},

    {env3_bit0_out_inv, env3_0xFF, GND},
    {env3_bit1_out_inv, env3_0xFF, GND},
    {env3_bit2_out_inv, env3_0xFF, GND},
    {env3_bit3_out_inv, env3_0xFF, GND},
    {env3_bit4_out_inv, env3_0xFF, GND},
    {env3_bit5_out_inv, env3_0xFF, GND},
    {env3_bit6_out_inv, env3_0xFF, GND},
    {env3_bit7_out_inv, env3_0xFF, GND},
    // ADSR gates
    {ctl3_gate, env3_rel_gate, GND},
    {env3_r0, env3_rel_gate, GND},
    {env3_rel_gate, env3_dcy_gate, GND},
    {env3_r0, env3_dcy_gate, GND},
    // ADSR registers
    {cl_a, reg13, GND},

    {reg13, db0, env3_d0_1},
    {env3_d0_1, env3_d0_2, GND},
    {env3_d0_2, env3_d0_3, GND},
    {sid_clk1, env3_d0_3, env3_d0_1},
    {sid_clk1, env3_d0_2, env3_d0_5},
    {env3_d0_5, env3_d0_4, GND},
    {env3_dcy_gate, env3_d0_4, env3_adr0_out},
    {reg13, db1, env3_d1_1},
    {env3_d1_1, env3_d1_2, GND},
    {env3_d1_2, env3_d1_3, GND},
    {sid_clk1, env3_d1_3, env3_d1_1},
    {sid_clk1, env3_d1_2, env3_d1_5},
    {env3_d1_5, env3_d1_4, GND},
    {env3_dcy_gate, env3_d1_4, env3_adr1_out},
    {reg13, db2, env3_d2_1},
    {env3_d2_1, env3_d2_2, GND},
    {env3_d2_2, env3_d2_3, GND},
    {sid_clk1, env3_d2_3, env3_d2_1},
    {sid_clk1, env3_d2_2, env3_d2_5},
    {env3_d2_5, env3_d2_4, GND},
    {env3_dcy_gate, env3_d2_4, env3_adr2_out},
    {reg13, db3, env3_d3_1},
    {env3_d3_1, env3_d3_2, GND},
    {env3_d3_2, env3_d3_3, GND},
    {sid_clk1, env3_d3_3, env3_d3_1},
    {sid_clk1, env3_d3_2, env3_d3_5},
    {env3_d3_5, env3_d3_4, GND},
    {env3_dcy_gate, env3_d3_4, env3_adr3_out},

    {reg13, db4, env3_a0_1},
    {env3_a0_1, env3_a0_2, GND},
    {env3_a0_2, env3_a0_3, GND},
    {sid_clk1, env3_a0_3, env3_a0_1},
    {sid_clk1, env3_a0_2, env3_a0_5},
    {env3_a0_5, env3_a0_4, GND},
    {env3_atk_gate, env3_a0_4, env3_adr0_out},
    {reg13, db5, env3_a1_1},
    {env3_a1_1, env3_a1_2, GND},
    {env3_a1_2, env3_a1_3, GND},
    {sid_clk1, env3_a1_3, env3_a1_1},
    {sid_clk1, env3_a1_2, env3_a1_5},
    {env3_a1_5, env3_a1_4, GND},
    {env3_atk_gate, env3_a1_4, env3_adr1_out},
    {reg13, db6, env3_a2_1},
    {env3_a2_1, env3_a2_2, GND},
    {env3_a2_2, env3_a2_3, GND},
    {sid_clk1, env3_a2_3, env3_a2_1},
    {sid_clk1, env3_a2_2, env3_a2_5},
    {env3_a2_5, env3_a2_4, GND},
    {env3_atk_gate, env3_a2_4, env3_adr2_out},
    {reg13, db7, env3_a3_1},
    {env3_a3_1, env3_a3_2, GND},
    {env3_a3_2, env3_a3_3, GND},
    {sid_clk1, env3_a3_3, env3_a3_1},
    {sid_clk1, env3_a3_2, env3_a3_5},
    {env3_a3_5, env3_a3_4, GND},
    {env3_atk_gate, env3_a3_4, env3_adr3_out},

    {cl_a, reg14, GND},

    {reg14, db0, env3_r0_1},
    {env3_r0_1, env3_r0_2, GND},
    {env3_r0_2, env3_r0_3, GND},
    {sid_clk1, env3_r0_3, env3_r0_1},
    {sid_clk1, env3_r0_2, env3_r0_5},
    {env3_r0_5, env3_r0_4, GND},
    {env3_rel_gate, env3_r0_4, env3_adr0_out},
    {reg14, db1, env3_r1_1},
    {env3_r1_1, env3_r1_2, GND},
    {env3_r1_2, env3_r1_3, GND},
    {sid_clk1, env3_r1_3, env3_r1_1},
    {sid_clk1, env3_r1_2, env3_r1_5},
    {env3_r1_5, env3_r1_4, GND},
    {env3_rel_gate, env3_r1_4, env3_adr1_out},
    {reg14, db2, env3_r2_1},
    {env3_r2_1, env3_r2_2, GND},
    {env3_r2_2, env3_r2_3, GND},
    {sid_clk1, env3_r2_3, env3_r2_1},
    {sid_clk1, env3_r2_2, env3_r2_5},
    {env3_r2_5, env3_r2_4, GND},
    {env3_rel_gate, env3_r2_4, env3_adr2_out},
    {reg14, db3, env3_r3_1},
    {env3_r3_1, env3_r3_2, GND},
    {env3_r3_2, env3_r3_3, GND},
    {sid_clk1, env3_r3_3, env3_r3_1},
    {sid_clk1, env3_r3_2, env3_r3_5},
    {env3_r3_5, env3_r3_4, GND},
    {env3_rel_gate, env3_r3_4, env3_adr3_out},

    {reg14, db4, env3_s0_1},
    {env3_s0_1, env3_s0_2, GND},
    {env3_s0_2, env3_s0_3, GND},
    {sid_clk1, env3_s0_3, env3_s0_1},
    {sid_clk1, env3_s0_2, env3_s0_5},
    {env3_s0_5, env3_s0_out, GND},
    {reg14, db5, env3_s1_1},
    {env3_s1_1, env3_s1_2, GND},
    {env3_s1_2, env3_s1_3, GND},
    {sid_clk1, env3_s1_3, env3_s1_1},
    {sid_clk1, env3_s1_2, env3_s1_5},
    {env3_s1_5, env3_s1_out, GND},
    {reg14, db6, env3_s2_1},
    {env3_s2_1, env3_s2_2, GND},
    {env3_s2_2, env3_s2_3, GND},
    {sid_clk1, env3_s2_3, env3_s2_1},
    {sid_clk1, env3_s2_2, env3_s2_5},
    {env3_s2_5, env3_s2_out, GND},
    {reg14, db7, env3_s3_1},
    {env3_s3_1, env3_s3_2, GND},
    {env3_s3_2, env3_s3_3, GND},
    {sid_clk1, env3_s3_3, env3_s3_1},
    {sid_clk1, env3_s3_2, env3_s3_5},
    {env3_s3_5, env3_s3_out, GND},

    // ADR to LUT
    {env3_adr0_out, env3_adr_00_inv, GND},
    {env3_adr_00_inv, env3_adr_00_out, GND},
    {env3_adr1_out, env3_adr_01_inv, GND},
    {env3_adr_01_inv, env3_adr_01_out, GND},
    {env3_adr2_out, env3_adr_02_inv, GND},
    {env3_adr_02_inv, env3_adr_02_out, GND},
    {env3_adr3_out, env3_adr_03_inv, GND},
    {env3_adr_03_inv, env3_adr_03_out, GND},
    // sustain comparator
    {env3_r0, env3_cnt_sus, GND},
    {env3_r1_inv, env3_cnt_sus, GND},
    {sid_clk1, env3_bit0_out, env3_bit0_cmp01},
    {env3_bit0_cmp01, env3_bit0_cmp02, GND},
    {env3_s0_out, env3_bit0_cmp02, GND},
    {env3_bit0_cmp01, env3_bit0_cmp03, env3_bit0_cmp04},
    {env3_s0_out, env3_bit0_cmp04, GND},
    {env3_bit0_cmp02, env3_bit0_cmp03, GND},
    {env3_bit0_cmp03, env3_cnt_sus, GND},
    {sid_clk1, env3_bit1_out, env3_bit1_cmp01},
    {env3_bit1_cmp01, env3_bit1_cmp02, GND},
    {env3_s1_out, env3_bit1_cmp02, GND},
    {env3_bit1_cmp01, env3_bit1_cmp03, env3_bit1_cmp04},
    {env3_s1_out, env3_bit1_cmp04, GND},
    {env3_bit1_cmp02, env3_bit1_cmp03, GND},
    {env3_bit1_cmp03, env3_cnt_sus, GND},
    {sid_clk1, env3_bit2_out, env3_bit2_cmp01},
    {env3_bit2_cmp01, env3_bit2_cmp02, GND},
    {env3_s2_out, env3_bit2_cmp02, GND},
    {env3_bit2_cmp01, env3_bit2_cmp03, env3_bit2_cmp04},
    {env3_s2_out, env3_bit2_cmp04, GND},
    {env3_bit2_cmp02, env3_bit2_cmp03, GND},
    {env3_bit2_cmp03, env3_cnt_sus, GND},
    {sid_clk1, env3_bit3_out, env3_bit3_cmp01},
    {env3_bit3_cmp01, env3_bit3_cmp02, GND},
    {env3_s3_out, env3_bit3_cmp02, GND},
    {env3_bit3_cmp01, env3_bit3_cmp03, env3_bit3_cmp04},
    {env3_s3_out, env3_bit3_cmp04, GND},
    {env3_bit3_cmp02, env3_bit3_cmp03, GND},
    {env3_bit3_cmp03, env3_cnt_sus, GND},
    {sid_clk1, env3_bit4_out, env3_bit4_cmp01},
    {env3_bit4_cmp01, env3_bit4_cmp02, GND},
    {env3_s0_out, env3_bit4_cmp02, GND},
    {env3_bit4_cmp01, env3_bit4_cmp03, env3_bit4_cmp04},
    {env3_s0_out, env3_bit4_cmp04, GND},
    {env3_bit4_cmp02, env3_bit4_cmp03, GND},
    {env3_bit4_cmp03, env3_cnt_sus, GND},
    {sid_clk1, env3_bit5_out, env3_bit5_cmp01},
    {env3_bit5_cmp01, env3_bit5_cmp02, GND},
    {env3_s1_out, env3_bit5_cmp02, GND},
    {env3_bit5_cmp01, env3_bit5_cmp03, env3_bit5_cmp04},
    {env3_s1_out, env3_bit5_cmp04, GND},
    {env3_bit5_cmp02, env3_bit5_cmp03, GND},
    {env3_bit5_cmp03, env3_cnt_sus, GND},
    {sid_clk1, env3_bit6_out, env3_bit6_cmp01},
    {env3_bit6_cmp01, env3_bit6_cmp02, GND},
    {env3_s2_out, env3_bit6_cmp02, GND},
    {env3_bit6_cmp01, env3_bit6_cmp03, env3_bit6_cmp04},
    {env3_s2_out, env3_bit6_cmp04, GND},
    {env3_bit6_cmp02, env3_bit6_cmp03, GND},
    {env3_bit6_cmp03, env3_cnt_sus, GND},
    {sid_clk1, env3_bit7_out, env3_bit7_cmp01},
    {env3_bit7_cmp01, env3_bit7_cmp02, GND},
    {env3_s3_out, env3_bit7_cmp02, GND},
    {env3_bit7_cmp01, env3_bit7_cmp03, env3_bit7_cmp04},
    {env3_s3_out, env3_bit7_cmp04, GND},
    {env3_bit7_cmp02, env3_bit7_cmp03, GND},
    {env3_bit7_cmp03, env3_cnt_sus, GND},
    // fixpoint found
    {sid_clk1, env3_0x5D, env3_ff0_X},
    {sid_clk1, env3_0x36, env3_ff0_Y},
    {sid_clk1, env3_0xFF, env3_ff0_Z},
    {env3_ff0_Y, env3_ff0_fix, GND},
    {env3_ff0_Z, env3_ff0_fix, GND},
    {sid_rst, env3_ff0_fix, GND},
    {env3_ff0_sel, env3_ff0_fix, GND},
    {env3_ff0_fix, env3_ff0_sel, GND},
    {env3_ff0_X, env3_ff0_sel, GND},
    {env3_ff0_fix, env3_fixpoint, GND},

    {sid_clk1, env3_0x36, env3_ff1_X},
    {sid_clk1, env3_0x1A, env3_ff1_Y},
    {sid_clk1, env3_0x5D, env3_ff1_Z},
    {env3_ff1_Y, env3_ff1_fix, GND},
    {env3_ff1_Z, env3_ff1_fix, GND},
    {sid_rst, env3_ff1_fix, GND},
    {env3_ff1_sel, env3_ff1_fix, GND},
    {env3_ff1_fix, env3_ff1_sel, GND},
    {env3_ff1_X, env3_ff1_sel, GND},
    {env3_ff1_fix, env3_fixpoint, GND},

    {sid_clk1, env3_0x1A, env3_ff2_X},
    {sid_clk1, env3_0x0E, env3_ff2_Y},
    {sid_clk1, env3_0x36, env3_ff2_Z},
    {env3_ff2_Y, env3_ff2_fix, GND},
    {env3_ff2_Z, env3_ff2_fix, GND},
    {sid_rst, env3_ff2_fix, GND},
    {env3_ff2_sel, env3_ff2_fix, GND},
    {env3_ff2_fix, env3_ff2_sel, GND},
    {env3_ff2_X, env3_ff2_sel, GND},
    {env3_ff2_fix, env3_fixpoint, GND},

    {sid_clk1, env3_0x0E, env3_ff3_X},
    {sid_clk1, env3_0x06, env3_ff3_Y},
    {sid_clk1, env3_0x1A, env3_ff3_Z},
    {env3_ff3_Y, env3_ff3_fix, GND},
    {env3_ff3_Z, env3_ff3_fix, GND},
    {sid_rst, env3_ff3_fix, GND},
    {env3_ff3_sel, env3_ff3_fix, GND},
    {env3_ff3_fix, env3_ff3_sel, GND},
    {env3_ff3_X, env3_ff3_sel, GND},
    {env3_ff3_fix, env3_fixpoint, GND},

    {sid_clk1, env3_0x06, env3_ff4_X},
    {sid_clk1, env3_0x00, env3_ff4_Y},
    {sid_clk1, env3_0x0E, env3_ff4_Z},
    {env3_ff4_Y, env3_ff4_fix, GND},
    {env3_ff4_Z, env3_ff4_fix, GND},
    {sid_rst, env3_ff4_fix, GND},
    {env3_ff4_sel, env3_ff4_fix, GND},
    {env3_ff4_fix, env3_ff4_sel, GND},
    {env3_ff4_X, env3_ff4_sel, GND},
    {env3_ff4_fix, env3_fixpoint, GND},
    // LFSR 15
    {env3_lfsrA_bit13_out, env3_lfsrA_fbk01, GND},
    {env3_lfsrA_bit14_out, env3_lfsrA_fbk01, GND},
    {env3_lfsrA_fbk01, env3_lfsrA_fbk_out, GND},
    {env3_lfsrA_bit13_out, env3_lfsrA_fbk_out, env3_lfsrA_fbk02},
    {env3_lfsrA_bit14_out, env3_lfsrA_fbk02, GND},

    {sid_clk2, env3_lfsrA_fbk_out, env3_lfsrA_bit00_01},
    {env3_lfsrA_bit00_01, env3_lfsrA_bit00_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit00_02, GND},
    {sid_clk1, env3_lfsrA_bit00_02, env3_lfsrA_bit00_03},
    {env3_lfsrA_bit00_03, env3_lfsrA_bit00_val, GND},
    {env3_lfsrA_bit00_val, env3_lfsrA_bit00_out_inv, GND},
    {env3_lfsrA_bit00_out_inv, env3_lfsrA_bit00_out, GND},
    {sid_clk2, env3_lfsrA_bit00_val, env3_lfsrA_bit01_01},
    {env3_lfsrA_bit01_01, env3_lfsrA_bit01_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit01_02, GND},
    {sid_clk1, env3_lfsrA_bit01_02, env3_lfsrA_bit01_03},
    {env3_lfsrA_bit01_03, env3_lfsrA_bit01_val, GND},
    {env3_lfsrA_bit01_val, env3_lfsrA_bit01_out_inv, GND},
    {env3_lfsrA_bit01_out_inv, env3_lfsrA_bit01_out, GND},
    {sid_clk2, env3_lfsrA_bit01_val, env3_lfsrA_bit02_01},
    {env3_lfsrA_bit02_01, env3_lfsrA_bit02_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit02_02, GND},
    {sid_clk1, env3_lfsrA_bit02_02, env3_lfsrA_bit02_03},
    {env3_lfsrA_bit02_03, env3_lfsrA_bit02_val, GND},
    {env3_lfsrA_bit02_val, env3_lfsrA_bit02_out_inv, GND},
    {env3_lfsrA_bit02_out_inv, env3_lfsrA_bit02_out, GND},
    {sid_clk2, env3_lfsrA_bit02_val, env3_lfsrA_bit03_01},
    {env3_lfsrA_bit03_01, env3_lfsrA_bit03_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit03_02, GND},
    {sid_clk1, env3_lfsrA_bit03_02, env3_lfsrA_bit03_03},
    {env3_lfsrA_bit03_03, env3_lfsrA_bit03_val, GND},
    {env3_lfsrA_bit03_val, env3_lfsrA_bit03_out_inv, GND},
    {env3_lfsrA_bit03_out_inv, env3_lfsrA_bit03_out, GND},
    {sid_clk2, env3_lfsrA_bit03_val, env3_lfsrA_bit04_01},
    {env3_lfsrA_bit04_01, env3_lfsrA_bit04_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit04_02, GND},
    {sid_clk1, env3_lfsrA_bit04_02, env3_lfsrA_bit04_03},
    {env3_lfsrA_bit04_03, env3_lfsrA_bit04_val, GND},
    {env3_lfsrA_bit04_val, env3_lfsrA_bit04_out_inv, GND},
    {env3_lfsrA_bit04_out_inv, env3_lfsrA_bit04_out, GND},
    {sid_clk2, env3_lfsrA_bit04_val, env3_lfsrA_bit05_01},
    {env3_lfsrA_bit05_01, env3_lfsrA_bit05_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit05_02, GND},
    {sid_clk1, env3_lfsrA_bit05_02, env3_lfsrA_bit05_03},
    {env3_lfsrA_bit05_03, env3_lfsrA_bit05_val, GND},
    {env3_lfsrA_bit05_val, env3_lfsrA_bit05_out_inv, GND},
    {env3_lfsrA_bit05_out_inv, env3_lfsrA_bit05_out, GND},
    {sid_clk2, env3_lfsrA_bit05_val, env3_lfsrA_bit06_01},
    {env3_lfsrA_bit06_01, env3_lfsrA_bit06_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit06_02, GND},
    {sid_clk1, env3_lfsrA_bit06_02, env3_lfsrA_bit06_03},
    {env3_lfsrA_bit06_03, env3_lfsrA_bit06_val, GND},
    {env3_lfsrA_bit06_val, env3_lfsrA_bit06_out_inv, GND},
    {env3_lfsrA_bit06_out_inv, env3_lfsrA_bit06_out, GND},
    {sid_clk2, env3_lfsrA_bit06_val, env3_lfsrA_bit07_01},
    {env3_lfsrA_bit07_01, env3_lfsrA_bit07_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit07_02, GND},
    {sid_clk1, env3_lfsrA_bit07_02, env3_lfsrA_bit07_03},
    {env3_lfsrA_bit07_03, env3_lfsrA_bit07_val, GND},
    {env3_lfsrA_bit07_val, env3_lfsrA_bit07_out_inv, GND},
    {env3_lfsrA_bit07_out_inv, env3_lfsrA_bit07_out, GND},
    {sid_clk2, env3_lfsrA_bit07_val, env3_lfsrA_bit08_01},
    {env3_lfsrA_bit08_01, env3_lfsrA_bit08_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit08_02, GND},
    {sid_clk1, env3_lfsrA_bit08_02, env3_lfsrA_bit08_03},
    {env3_lfsrA_bit08_03, env3_lfsrA_bit08_val, GND},
    {env3_lfsrA_bit08_val, env3_lfsrA_bit08_out_inv, GND},
    {env3_lfsrA_bit08_out_inv, env3_lfsrA_bit08_out, GND},
    {sid_clk2, env3_lfsrA_bit08_val, env3_lfsrA_bit09_01},
    {env3_lfsrA_bit09_01, env3_lfsrA_bit09_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit09_02, GND},
    {sid_clk1, env3_lfsrA_bit09_02, env3_lfsrA_bit09_03},
    {env3_lfsrA_bit09_03, env3_lfsrA_bit09_val, GND},
    {env3_lfsrA_bit09_val, env3_lfsrA_bit09_out_inv, GND},
    {env3_lfsrA_bit09_out_inv, env3_lfsrA_bit09_out, GND},
    {sid_clk2, env3_lfsrA_bit09_val, env3_lfsrA_bit10_01},
    {env3_lfsrA_bit10_01, env3_lfsrA_bit10_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit10_02, GND},
    {sid_clk1, env3_lfsrA_bit10_02, env3_lfsrA_bit10_03},
    {env3_lfsrA_bit10_03, env3_lfsrA_bit10_val, GND},
    {env3_lfsrA_bit10_val, env3_lfsrA_bit10_out_inv, GND},
    {env3_lfsrA_bit10_out_inv, env3_lfsrA_bit10_out, GND},
    {sid_clk2, env3_lfsrA_bit10_val, env3_lfsrA_bit11_01},
    {env3_lfsrA_bit11_01, env3_lfsrA_bit11_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit11_02, GND},
    {sid_clk1, env3_lfsrA_bit11_02, env3_lfsrA_bit11_03},
    {env3_lfsrA_bit11_03, env3_lfsrA_bit11_val, GND},
    {env3_lfsrA_bit11_val, env3_lfsrA_bit11_out_inv, GND},
    {env3_lfsrA_bit11_out_inv, env3_lfsrA_bit11_out, GND},
    {sid_clk2, env3_lfsrA_bit11_val, env3_lfsrA_bit12_01},
    {env3_lfsrA_bit12_01, env3_lfsrA_bit12_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit12_02, GND},
    {sid_clk1, env3_lfsrA_bit12_02, env3_lfsrA_bit12_03},
    {env3_lfsrA_bit12_03, env3_lfsrA_bit12_val, GND},
    {env3_lfsrA_bit12_val, env3_lfsrA_bit12_out_inv, GND},
    {env3_lfsrA_bit12_out_inv, env3_lfsrA_bit12_out, GND},
    {sid_clk2, env3_lfsrA_bit12_val, env3_lfsrA_bit13_01},
    {env3_lfsrA_bit13_01, env3_lfsrA_bit13_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit13_02, GND},
    {sid_clk1, env3_lfsrA_bit13_02, env3_lfsrA_bit13_03},
    {env3_lfsrA_bit13_03, env3_lfsrA_bit13_val, GND},
    {env3_lfsrA_bit13_val, env3_lfsrA_bit13_out_inv, GND},
    {env3_lfsrA_bit13_out_inv, env3_lfsrA_bit13_out, GND},
    {sid_clk2, env3_lfsrA_bit13_val, env3_lfsrA_bit14_01},
    {env3_lfsrA_bit14_01, env3_lfsrA_bit14_02, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_bit14_02, GND},
    {sid_clk1, env3_lfsrA_bit14_02, env3_lfsrA_bit14_03},
    {env3_lfsrA_bit14_03, env3_lfsrA_bit14_val, GND},
    {env3_lfsrA_bit14_val, env3_lfsrA_bit14_out_inv, GND},
    {env3_lfsrA_bit14_out_inv, env3_lfsrA_bit14_out, GND},
    // reset
    {sid_rst, env3_lfsrA_rst01, GND},
    {env3_0x500E, env3_lfsrA_rst01, GND},
    {env3_0x0A93, env3_lfsrA_rst01, GND},
    {env3_0x3800, env3_lfsrA_rst01, GND},
    {env3_0x7625, env3_lfsrA_rst01, GND},
    {env3_0x6755, env3_lfsrA_rst01, GND},
    {env3_0x77E2, env3_lfsrA_rst01, GND},
    {env3_0x20C0, env3_lfsrA_rst01, GND},
    {env3_0x3840, env3_lfsrA_rst01, GND},
    {env3_0x0330, env3_lfsrA_rst01, GND},
    {env3_0x59B8, env3_lfsrA_rst01, GND},
    {env3_0x003C, env3_lfsrA_rst01, GND},
    {env3_0x1848, env3_lfsrA_rst01, GND},
    {env3_0x0006, env3_lfsrA_rst01, GND},
    {env3_0x0222, env3_lfsrA_rst01, GND},
    {env3_0x7F00, env3_lfsrA_rst01, GND},
    {env3_0x1212, env3_lfsrA_rst01, GND},
    {sid_clk2, env3_lfsrA_rst01, env3_lfsrA_rst02},
    {env3_lfsrA_rst02, env3_lfsrA_rst03, GND},
    {env3_lfsrA_rst03, Vcc, env3_lfsrA_rst_A},
    {env3_lfsrA_rst02, env3_lfsrA_rst_A, GND},
    {env3_lfsrA_rst_A, env3_lfsrA_rst04, GND},
    {sid_clk1, env3_lfsrA_rst04, env3_lfsrA_rst05},
    {env3_lfsrA_rst05, env3_lfsrA_rst_B, GND},
    // LUT
    {env3_lfsrA_bit00_out, env3_0x500E, GND},
    {env3_lfsrA_bit01_out_inv, env3_0x500E, GND},
    {env3_lfsrA_bit02_out_inv, env3_0x500E, GND},
    {env3_lfsrA_bit03_out_inv, env3_0x500E, GND},
    {env3_lfsrA_bit04_out, env3_0x500E, GND},
    {env3_lfsrA_bit05_out, env3_0x500E, GND},
    {env3_lfsrA_bit06_out, env3_0x500E, GND},
    {env3_lfsrA_bit07_out, env3_0x500E, GND},
    {env3_lfsrA_bit08_out, env3_0x500E, GND},
    {env3_lfsrA_bit09_out, env3_0x500E, GND},
    {env3_lfsrA_bit10_out, env3_0x500E, GND},
    {env3_lfsrA_bit11_out, env3_0x500E, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x500E, GND},
    {env3_lfsrA_bit13_out, env3_0x500E, GND},
    {env3_lfsrA_bit14_out_inv, env3_0x500E, GND},
    {env3_adr_00_inv, env3_0x500E, GND},
    {env3_adr_01_inv, env3_0x500E, GND},
    {env3_adr_02_inv, env3_0x500E, GND},
    {env3_adr_03_out, env3_0x500E, GND},

    {env3_lfsrA_bit00_out_inv, env3_0x0A93, GND},
    {env3_lfsrA_bit01_out_inv, env3_0x0A93, GND},
    {env3_lfsrA_bit02_out, env3_0x0A93, GND},
    {env3_lfsrA_bit03_out, env3_0x0A93, GND},
    {env3_lfsrA_bit04_out_inv, env3_0x0A93, GND},
    {env3_lfsrA_bit05_out, env3_0x0A93, GND},
    {env3_lfsrA_bit06_out, env3_0x0A93, GND},
    {env3_lfsrA_bit07_out_inv, env3_0x0A93, GND},
    {env3_lfsrA_bit08_out, env3_0x0A93, GND},
    {env3_lfsrA_bit09_out_inv, env3_0x0A93, GND},
    {env3_lfsrA_bit10_out, env3_0x0A93, GND},
    {env3_lfsrA_bit11_out_inv, env3_0x0A93, GND},
    {env3_lfsrA_bit12_out, env3_0x0A93, GND},
    {env3_lfsrA_bit13_out, env3_0x0A93, GND},
    {env3_lfsrA_bit14_out, env3_0x0A93, GND},
    {env3_adr_00_inv, env3_0x0A93, GND},
    {env3_adr_01_inv, env3_0x0A93, GND},
    {env3_adr_02_inv, env3_0x0A93, GND},
    {env3_adr_03_inv, env3_0x0A93, GND},

    {env3_lfsrA_bit00_out, env3_0x3800, GND},
    {env3_lfsrA_bit01_out, env3_0x3800, GND},
    {env3_lfsrA_bit02_out, env3_0x3800, GND},
    {env3_lfsrA_bit03_out, env3_0x3800, GND},
    {env3_lfsrA_bit04_out, env3_0x3800, GND},
    {env3_lfsrA_bit05_out, env3_0x3800, GND},
    {env3_lfsrA_bit06_out, env3_0x3800, GND},
    {env3_lfsrA_bit07_out, env3_0x3800, GND},
    {env3_lfsrA_bit08_out, env3_0x3800, GND},
    {env3_lfsrA_bit09_out, env3_0x3800, GND},
    {env3_lfsrA_bit10_out, env3_0x3800, GND},
    {env3_lfsrA_bit11_out_inv, env3_0x3800, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x3800, GND},
    {env3_lfsrA_bit13_out_inv, env3_0x3800, GND},
    {env3_lfsrA_bit14_out, env3_0x3800, GND},
    {env3_adr_00_out, env3_0x3800, GND},
    {env3_adr_01_inv, env3_0x3800, GND},
    {env3_adr_02_inv, env3_0x3800, GND},
    {env3_adr_03_out, env3_0x3800, GND},

    {env3_lfsrA_bit00_out_inv, env3_0x7625, GND},
    {env3_lfsrA_bit01_out, env3_0x7625, GND},
    {env3_lfsrA_bit02_out_inv, env3_0x7625, GND},
    {env3_lfsrA_bit03_out, env3_0x7625, GND},
    {env3_lfsrA_bit04_out, env3_0x7625, GND},
    {env3_lfsrA_bit05_out_inv, env3_0x7625, GND},
    {env3_lfsrA_bit06_out, env3_0x7625, GND},
    {env3_lfsrA_bit07_out, env3_0x7625, GND},
    {env3_lfsrA_bit08_out, env3_0x7625, GND},
    {env3_lfsrA_bit09_out_inv, env3_0x7625, GND},
    {env3_lfsrA_bit10_out_inv, env3_0x7625, GND},
    {env3_lfsrA_bit11_out, env3_0x7625, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x7625, GND},
    {env3_lfsrA_bit13_out_inv, env3_0x7625, GND},
    {env3_lfsrA_bit14_out_inv, env3_0x7625, GND},
    {env3_adr_00_out, env3_0x7625, GND},
    {env3_adr_01_inv, env3_0x7625, GND},
    {env3_adr_02_inv, env3_0x7625, GND},
    {env3_adr_03_inv, env3_0x7625, GND},

    {env3_lfsrA_bit00_out_inv, env3_0x6755, GND},
    {env3_lfsrA_bit01_out, env3_0x6755, GND},
    {env3_lfsrA_bit02_out_inv, env3_0x6755, GND},
    {env3_lfsrA_bit03_out, env3_0x6755, GND},
    {env3_lfsrA_bit04_out_inv, env3_0x6755, GND},
    {env3_lfsrA_bit05_out, env3_0x6755, GND},
    {env3_lfsrA_bit06_out_inv, env3_0x6755, GND},
    {env3_lfsrA_bit07_out, env3_0x6755, GND},
    {env3_lfsrA_bit08_out_inv, env3_0x6755, GND},
    {env3_lfsrA_bit09_out_inv, env3_0x6755, GND},
    {env3_lfsrA_bit10_out_inv, env3_0x6755, GND},
    {env3_lfsrA_bit11_out, env3_0x6755, GND},
    {env3_lfsrA_bit12_out, env3_0x6755, GND},
    {env3_lfsrA_bit13_out_inv, env3_0x6755, GND},
    {env3_lfsrA_bit14_out_inv, env3_0x6755, GND},
    {env3_adr_00_inv, env3_0x6755, GND},
    {env3_adr_01_out, env3_0x6755, GND},
    {env3_adr_02_inv, env3_0x6755, GND},
    {env3_adr_03_out, env3_0x6755, GND},

    {env3_lfsrA_bit00_out, env3_0x77E2, GND},
    {env3_lfsrA_bit01_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit02_out, env3_0x77E2, GND},
    {env3_lfsrA_bit03_out, env3_0x77E2, GND},
    {env3_lfsrA_bit04_out, env3_0x77E2, GND},
    {env3_lfsrA_bit05_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit06_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit07_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit08_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit09_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit10_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit11_out, env3_0x77E2, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit13_out_inv, env3_0x77E2, GND},
    {env3_lfsrA_bit14_out_inv, env3_0x77E2, GND},
    {env3_adr_00_inv, env3_0x77E2, GND},
    {env3_adr_01_out, env3_0x77E2, GND},
    {env3_adr_02_inv, env3_0x77E2, GND},
    {env3_adr_03_inv, env3_0x77E2, GND},

    {env3_lfsrA_bit00_out, env3_0x20C0, GND},
    {env3_lfsrA_bit01_out, env3_0x20C0, GND},
    {env3_lfsrA_bit02_out, env3_0x20C0, GND},
    {env3_lfsrA_bit03_out, env3_0x20C0, GND},
    {env3_lfsrA_bit04_out, env3_0x20C0, GND},
    {env3_lfsrA_bit05_out, env3_0x20C0, GND},
    {env3_lfsrA_bit06_out_inv, env3_0x20C0, GND},
    {env3_lfsrA_bit07_out_inv, env3_0x20C0, GND},
    {env3_lfsrA_bit08_out, env3_0x20C0, GND},
    {env3_lfsrA_bit09_out, env3_0x20C0, GND},
    {env3_lfsrA_bit10_out, env3_0x20C0, GND},
    {env3_lfsrA_bit11_out, env3_0x20C0, GND},
    {env3_lfsrA_bit12_out, env3_0x20C0, GND},
    {env3_lfsrA_bit13_out_inv, env3_0x20C0, GND},
    {env3_lfsrA_bit14_out, env3_0x20C0, GND},
    {env3_adr_00_out, env3_0x20C0, GND},
    {env3_adr_01_out, env3_0x20C0, GND},
    {env3_adr_02_inv, env3_0x20C0, GND},
    {env3_adr_03_out, env3_0x20C0, GND},

    {env3_lfsrA_bit00_out, env3_0x3840, GND},
    {env3_lfsrA_bit01_out, env3_0x3840, GND},
    {env3_lfsrA_bit02_out, env3_0x3840, GND},
    {env3_lfsrA_bit03_out, env3_0x3840, GND},
    {env3_lfsrA_bit04_out, env3_0x3840, GND},
    {env3_lfsrA_bit05_out, env3_0x3840, GND},
    {env3_lfsrA_bit06_out_inv, env3_0x3840, GND},
    {env3_lfsrA_bit07_out, env3_0x3840, GND},
    {env3_lfsrA_bit08_out, env3_0x3840, GND},
    {env3_lfsrA_bit09_out, env3_0x3840, GND},
    {env3_lfsrA_bit10_out, env3_0x3840, GND},
    {env3_lfsrA_bit11_out_inv, env3_0x3840, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x3840, GND},
    {env3_lfsrA_bit13_out_inv, env3_0x3840, GND},
    {env3_lfsrA_bit14_out, env3_0x3840, GND},
    {env3_adr_00_out, env3_0x3840, GND},
    {env3_adr_01_out, env3_0x3840, GND},
    {env3_adr_02_inv, env3_0x3840, GND},
    {env3_adr_03_inv, env3_0x3840, GND},

    {env3_lfsrA_bit00_out, env3_0x0330, GND},
    {env3_lfsrA_bit01_out, env3_0x0330, GND},
    {env3_lfsrA_bit02_out, env3_0x0330, GND},
    {env3_lfsrA_bit03_out, env3_0x0330, GND},
    {env3_lfsrA_bit04_out_inv, env3_0x0330, GND},
    {env3_lfsrA_bit05_out_inv, env3_0x0330, GND},
    {env3_lfsrA_bit06_out, env3_0x0330, GND},
    {env3_lfsrA_bit07_out, env3_0x0330, GND},
    {env3_lfsrA_bit08_out_inv, env3_0x0330, GND},
    {env3_lfsrA_bit09_out_inv, env3_0x0330, GND},
    {env3_lfsrA_bit10_out, env3_0x0330, GND},
    {env3_lfsrA_bit11_out, env3_0x0330, GND},
    {env3_lfsrA_bit12_out, env3_0x0330, GND},
    {env3_lfsrA_bit13_out, env3_0x0330, GND},
    {env3_lfsrA_bit14_out, env3_0x0330, GND},
    {env3_adr_00_inv, env3_0x0330, GND},
    {env3_adr_01_inv, env3_0x0330, GND},
    {env3_adr_02_out, env3_0x0330, GND},
    {env3_adr_03_out, env3_0x0330, GND},

    {env3_lfsrA_bit00_out, env3_0x59B8, GND},
    {env3_lfsrA_bit01_out, env3_0x59B8, GND},
    {env3_lfsrA_bit02_out, env3_0x59B8, GND},
    {env3_lfsrA_bit03_out_inv, env3_0x59B8, GND},
    {env3_lfsrA_bit04_out_inv, env3_0x59B8, GND},
    {env3_lfsrA_bit05_out_inv, env3_0x59B8, GND},
    {env3_lfsrA_bit06_out, env3_0x59B8, GND},
    {env3_lfsrA_bit07_out_inv, env3_0x59B8, GND},
    {env3_lfsrA_bit08_out_inv, env3_0x59B8, GND},
    {env3_lfsrA_bit09_out, env3_0x59B8, GND},
    {env3_lfsrA_bit10_out, env3_0x59B8, GND},
    {env3_lfsrA_bit11_out_inv, env3_0x59B8, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x59B8, GND},
    {env3_lfsrA_bit13_out, env3_0x59B8, GND},
    {env3_lfsrA_bit14_out_inv, env3_0x59B8, GND},
    {env3_adr_00_inv, env3_0x59B8, GND},
    {env3_adr_01_inv, env3_0x59B8, GND},
    {env3_adr_02_out, env3_0x59B8, GND},
    {env3_adr_03_inv, env3_0x59B8, GND},

    {env3_lfsrA_bit00_out, env3_0x003C, GND},
    {env3_lfsrA_bit01_out, env3_0x003C, GND},
    {env3_lfsrA_bit02_out_inv, env3_0x003C, GND},
    {env3_lfsrA_bit03_out_inv, env3_0x003C, GND},
    {env3_lfsrA_bit04_out_inv, env3_0x003C, GND},
    {env3_lfsrA_bit05_out_inv, env3_0x003C, GND},
    {env3_lfsrA_bit06_out, env3_0x003C, GND},
    {env3_lfsrA_bit07_out, env3_0x003C, GND},
    {env3_lfsrA_bit08_out, env3_0x003C, GND},
    {env3_lfsrA_bit09_out, env3_0x003C, GND},
    {env3_lfsrA_bit10_out, env3_0x003C, GND},
    {env3_lfsrA_bit11_out, env3_0x003C, GND},
    {env3_lfsrA_bit12_out, env3_0x003C, GND},
    {env3_lfsrA_bit13_out, env3_0x003C, GND},
    {env3_lfsrA_bit14_out, env3_0x003C, GND},
    {env3_adr_00_out, env3_0x003C, GND},
    {env3_adr_01_inv, env3_0x003C, GND},
    {env3_adr_02_out, env3_0x003C, GND},
    {env3_adr_03_out, env3_0x003C, GND},

    {env3_lfsrA_bit00_out, env3_0x1848, GND},
    {env3_lfsrA_bit01_out, env3_0x1848, GND},
    {env3_lfsrA_bit02_out, env3_0x1848, GND},
    {env3_lfsrA_bit03_out_inv, env3_0x1848, GND},
    {env3_lfsrA_bit04_out, env3_0x1848, GND},
    {env3_lfsrA_bit05_out, env3_0x1848, GND},
    {env3_lfsrA_bit06_out_inv, env3_0x1848, GND},
    {env3_lfsrA_bit07_out, env3_0x1848, GND},
    {env3_lfsrA_bit08_out, env3_0x1848, GND},
    {env3_lfsrA_bit09_out, env3_0x1848, GND},
    {env3_lfsrA_bit10_out, env3_0x1848, GND},
    {env3_lfsrA_bit11_out_inv, env3_0x1848, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x1848, GND},
    {env3_lfsrA_bit13_out, env3_0x1848, GND},
    {env3_lfsrA_bit14_out, env3_0x1848, GND},
    {env3_adr_00_out, env3_0x1848, GND},
    {env3_adr_01_inv, env3_0x1848, GND},
    {env3_adr_02_out, env3_0x1848, GND},
    {env3_adr_03_inv, env3_0x1848, GND},

    {env3_lfsrA_bit00_out, env3_0x0006, GND},
    {env3_lfsrA_bit01_out_inv, env3_0x0006, GND},
    {env3_lfsrA_bit02_out_inv, env3_0x0006, GND},
    {env3_lfsrA_bit03_out, env3_0x0006, GND},
    {env3_lfsrA_bit04_out, env3_0x0006, GND},
    {env3_lfsrA_bit05_out, env3_0x0006, GND},
    {env3_lfsrA_bit06_out, env3_0x0006, GND},
    {env3_lfsrA_bit07_out, env3_0x0006, GND},
    {env3_lfsrA_bit08_out, env3_0x0006, GND},
    {env3_lfsrA_bit09_out, env3_0x0006, GND},
    {env3_lfsrA_bit10_out, env3_0x0006, GND},
    {env3_lfsrA_bit11_out, env3_0x0006, GND},
    {env3_lfsrA_bit12_out, env3_0x0006, GND},
    {env3_lfsrA_bit13_out, env3_0x0006, GND},
    {env3_lfsrA_bit14_out, env3_0x0006, GND},
    {env3_adr_00_inv, env3_0x0006, GND},
    {env3_adr_01_out, env3_0x0006, GND},
    {env3_adr_02_out, env3_0x0006, GND},
    {env3_adr_03_out, env3_0x0006, GND},

    {env3_lfsrA_bit00_out, env3_0x0222, GND},
    {env3_lfsrA_bit01_out_inv, env3_0x0222, GND},
    {env3_lfsrA_bit02_out, env3_0x0222, GND},
    {env3_lfsrA_bit03_out, env3_0x0222, GND},
    {env3_lfsrA_bit04_out, env3_0x0222, GND},
    {env3_lfsrA_bit05_out_inv, env3_0x0222, GND},
    {env3_lfsrA_bit06_out, env3_0x0222, GND},
    {env3_lfsrA_bit07_out, env3_0x0222, GND},
    {env3_lfsrA_bit08_out, env3_0x0222, GND},
    {env3_lfsrA_bit09_out_inv, env3_0x0222, GND},
    {env3_lfsrA_bit10_out, env3_0x0222, GND},
    {env3_lfsrA_bit11_out, env3_0x0222, GND},
    {env3_lfsrA_bit12_out, env3_0x0222, GND},
    {env3_lfsrA_bit13_out, env3_0x0222, GND},
    {env3_lfsrA_bit14_out, env3_0x0222, GND},
    {env3_adr_00_inv, env3_0x0222, GND},
    {env3_adr_01_out, env3_0x0222, GND},
    {env3_adr_02_out, env3_0x0222, GND},
    {env3_adr_03_inv, env3_0x0222, GND},

    {env3_lfsrA_bit00_out, env3_0x7F00, GND},
    {env3_lfsrA_bit01_out, env3_0x7F00, GND},
    {env3_lfsrA_bit02_out, env3_0x7F00, GND},
    {env3_lfsrA_bit03_out, env3_0x7F00, GND},
    {env3_lfsrA_bit04_out, env3_0x7F00, GND},
    {env3_lfsrA_bit05_out, env3_0x7F00, GND},
    {env3_lfsrA_bit06_out, env3_0x7F00, GND},
    {env3_lfsrA_bit07_out, env3_0x7F00, GND},
    {env3_lfsrA_bit08_out_inv, env3_0x7F00, GND},
    {env3_lfsrA_bit09_out_inv, env3_0x7F00, GND},
    {env3_lfsrA_bit10_out_inv, env3_0x7F00, GND},
    {env3_lfsrA_bit11_out_inv, env3_0x7F00, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x7F00, GND},
    {env3_lfsrA_bit13_out_inv, env3_0x7F00, GND},
    {env3_lfsrA_bit14_out_inv, env3_0x7F00, GND},
    {env3_adr_00_out, env3_0x7F00, GND},
    {env3_adr_01_out, env3_0x7F00, GND},
    {env3_adr_02_out, env3_0x7F00, GND},
    {env3_adr_03_out, env3_0x7F00, GND},

    {env3_lfsrA_bit00_out, env3_0x1212, GND},
    {env3_lfsrA_bit01_out_inv, env3_0x1212, GND},
    {env3_lfsrA_bit02_out, env3_0x1212, GND},
    {env3_lfsrA_bit03_out, env3_0x1212, GND},
    {env3_lfsrA_bit04_out_inv, env3_0x1212, GND},
    {env3_lfsrA_bit05_out, env3_0x1212, GND},
    {env3_lfsrA_bit06_out, env3_0x1212, GND},
    {env3_lfsrA_bit07_out, env3_0x1212, GND},
    {env3_lfsrA_bit08_out, env3_0x1212, GND},
    {env3_lfsrA_bit09_out_inv, env3_0x1212, GND},
    {env3_lfsrA_bit10_out, env3_0x1212, GND},
    {env3_lfsrA_bit11_out, env3_0x1212, GND},
    {env3_lfsrA_bit12_out_inv, env3_0x1212, GND},
    {env3_lfsrA_bit13_out, env3_0x1212, GND},
    {env3_lfsrA_bit14_out, env3_0x1212, GND},
    {env3_adr_00_out, env3_0x1212, GND},
    {env3_adr_01_out, env3_0x1212, GND},
    {env3_adr_02_out, env3_0x1212, GND},
    {env3_adr_03_inv, env3_0x1212, GND},
    // LFSR 5
    {env3_lfsrB_bit02_out, env3_lfsrB_fbk01, GND},
    {env3_lfsrB_bit04_out, env3_lfsrB_fbk01, GND},
    {env3_lfsrB_fbk01, env3_lfsrB_fbk_out, GND},
    {env3_lfsrB_bit04_out, env3_lfsrB_fbk_out, env3_lfsrB_fbk02},
    {env3_lfsrB_bit02_out, env3_lfsrB_fbk02, GND},

    {env3_lfsrB_clk_shift, env3_lfsrB_fbk_out, env3_lfsrB_bit00_01},
    {env3_lfsrB_bit00_01, env3_lfsrB_bit00_02, GND},
    {env3_lfsrB_rst, env3_lfsrB_bit00_02, GND},
    {sid_clk1, env3_lfsrB_bit00_02, env3_lfsrB_bit00_03},
    {env3_lfsrB_bit00_03, env3_lfsrB_bit00_val, GND},
    {env3_lfsrB_clk_hold, env3_lfsrB_bit00_val, env3_lfsrB_bit00_01},
    {env3_lfsrB_bit00_val, env3_lfsrB_bit00_out_inv, GND},
    {env3_lfsrB_bit00_out_inv, env3_lfsrB_bit00_out, GND},

    {env3_lfsrB_clk_shift, env3_lfsrB_bit00_val, env3_lfsrB_bit01_01},
    {env3_lfsrB_bit01_01, env3_lfsrB_bit01_02, GND},
    {env3_lfsrB_rst, env3_lfsrB_bit01_02, GND},
    {sid_clk1, env3_lfsrB_bit01_02, env3_lfsrB_bit01_03},
    {env3_lfsrB_bit01_03, env3_lfsrB_bit01_val, GND},
    {env3_lfsrB_clk_hold, env3_lfsrB_bit01_val, env3_lfsrB_bit01_01},
    {env3_lfsrB_bit01_val, env3_lfsrB_bit01_out_inv, GND},
    {env3_lfsrB_bit01_out_inv, env3_lfsrB_bit01_out, GND},

    {env3_lfsrB_clk_shift, env3_lfsrB_bit01_val, env3_lfsrB_bit02_01},
    {env3_lfsrB_bit02_01, env3_lfsrB_bit02_02, GND},
    {env3_lfsrB_rst, env3_lfsrB_bit02_02, GND},
    {sid_clk1, env3_lfsrB_bit02_02, env3_lfsrB_bit02_03},
    {env3_lfsrB_bit02_03, env3_lfsrB_bit02_val, GND},
    {env3_lfsrB_clk_hold, env3_lfsrB_bit02_val, env3_lfsrB_bit02_01},
    {env3_lfsrB_bit02_val, env3_lfsrB_bit02_out_inv, GND},
    {env3_lfsrB_bit02_out_inv, env3_lfsrB_bit02_out, GND},

    {env3_lfsrB_clk_shift, env3_lfsrB_bit02_val, env3_lfsrB_bit03_01},
    {env3_lfsrB_bit03_01, env3_lfsrB_bit03_02, GND},
    {env3_lfsrB_rst, env3_lfsrB_bit03_02, GND},
    {sid_clk1, env3_lfsrB_bit03_02, env3_lfsrB_bit03_03},
    {env3_lfsrB_bit03_03, env3_lfsrB_bit03_val, GND},
    {env3_lfsrB_clk_hold, env3_lfsrB_bit03_val, env3_lfsrB_bit03_01},
    {env3_lfsrB_bit03_val, env3_lfsrB_bit03_out_inv, GND},
    {env3_lfsrB_bit03_out_inv, env3_lfsrB_bit03_out, GND},

    {env3_lfsrB_clk_shift, env3_lfsrB_bit03_val, env3_lfsrB_bit04_01},
    {env3_lfsrB_bit04_01, env3_lfsrB_bit04_02, GND},
    {env3_lfsrB_rst, env3_lfsrB_bit04_02, GND},
    {sid_clk1, env3_lfsrB_bit04_02, env3_lfsrB_bit04_03},
    {env3_lfsrB_bit04_03, env3_lfsrB_bit04_val, GND},
    {env3_lfsrB_clk_hold, env3_lfsrB_bit04_val, env3_lfsrB_bit04_01},
    {env3_lfsrB_bit04_val, env3_lfsrB_bit04_out_inv, GND},
    {env3_lfsrB_bit04_out_inv, env3_lfsrB_bit04_out, GND},
    // reset
    {env3_r0, env3_lfsrB_rst01, env3_lfsrB_rst05},
    {env3_fixpoint, env3_lfsrB_rst01, env3_lfsrB_rst05},
    {env3_lfsrA_rst_B, env3_lfsrB_rst05, GND},
    {sid_rst, env3_lfsrB_rst01, GND},
    {env3_0x1B, env3_lfsrB_rst01, GND},
    {env3_0x0F, env3_lfsrB_rst01, GND},
    {env3_0x11, env3_lfsrB_rst01, GND},
    {env3_0x08, env3_lfsrB_rst01, GND},
    {env3_0x1C, env3_lfsrB_rst01, GND},
    {sid_clk2, env3_lfsrB_rst01, env3_lfsrB_rst02},
    {env3_lfsrB_rst02, env3_lfsrB_rst03, GND},
    {env3_lfsrB_rst03, Vcc, env3_lfsrB_rst},
    {env3_lfsrB_rst02, env3_lfsrB_rst, GND},
    {sid_clk1, env3_lfsrB_rst, env3_lfsrB_rst04},
    {env3_lfsrB_rst04, env3_lfsrB_rst_rel, GND},
    // clock
    {env3_lfsrA_rst_B, env3_lfsrB_clk01, GND},
    {sid_clk1, env3_lfsrA_rst_B, env3_lfsrB_clk03},
    {env3_lfsrB_clk03, sid_clk2, env3_lfsrB_clk_shift},
    {env3_lfsrB_clk01, env3_lfsrB_clk_shift, GND},
    {sid_clk1, env3_lfsrB_clk_shift, GND},
    {env3_lfsrA_rst_B, env3_lfsrB_clk02, GND},
    {sid_clk1, env3_lfsrB_clk02, env3_lfsrB_clk04},
    {env3_lfsrB_clk04, sid_clk2, env3_lfsrB_clk_hold},
    {env3_lfsrA_rst_B, env3_lfsrB_clk_hold, GND},
    {sid_clk1, env3_lfsrB_clk_hold, GND},
    // LUT
    {env3_lfsrB_bit00_out_inv, env3_0x1B, GND},
    {env3_lfsrB_bit01_out_inv, env3_0x1B, GND},
    {env3_lfsrB_bit02_out, env3_0x1B, GND},
    {env3_lfsrB_bit03_out_inv, env3_0x1B, GND},
    {env3_lfsrB_bit04_out_inv, env3_0x1B, GND},
    {env3_ff2_sel, env3_0x1B, GND},

    {env3_lfsrB_bit00_out_inv, env3_0x0F, GND},
    {env3_lfsrB_bit01_out_inv, env3_0x0F, GND},
    {env3_lfsrB_bit02_out_inv, env3_0x0F, GND},
    {env3_lfsrB_bit03_out_inv, env3_0x0F, GND},
    {env3_lfsrB_bit04_out, env3_0x0F, GND},
    {env3_ff4_sel, env3_0x0F, GND},

    {env3_lfsrB_bit00_out_inv, env3_0x11, GND},
    {env3_lfsrB_bit01_out, env3_0x11, GND},
    {env3_lfsrB_bit02_out, env3_0x11, GND},
    {env3_lfsrB_bit03_out, env3_0x11, GND},
    {env3_lfsrB_bit04_out_inv, env3_0x11, GND},
    {env3_ff1_sel, env3_0x11, GND},

    {env3_lfsrB_bit00_out, env3_0x08, GND},
    {env3_lfsrB_bit01_out, env3_0x08, GND},
    {env3_lfsrB_bit02_out, env3_0x08, GND},
    {env3_lfsrB_bit03_out_inv, env3_0x08, GND},
    {env3_lfsrB_bit04_out, env3_0x08, GND},
    {env3_ff3_sel, env3_0x08, GND},

    {env3_lfsrB_bit00_out, env3_0x1C, GND},
    {env3_lfsrB_bit01_out, env3_0x1C, GND},
    {env3_lfsrB_bit02_out_inv, env3_0x1C, GND},
    {env3_lfsrB_bit03_out_inv, env3_0x1C, GND},
    {env3_lfsrB_bit04_out_inv, env3_0x1C, GND},
    {env3_ff0_sel, env3_0x1C, GND},

    // ENV3 register
    {sid_clk1, env3_bit0_out, reg_env3_bit0_ltc1},
    {reg_env3_bit0_ltc1, reg_env3_bit0_1, GND},
    {reg_env3_bit0_1, reg_env3_bit0_2, GND},
    {reg_env3_bit0_2, Vcc, reg_env3_bit0_3},
    {reg_env3_bit0_1, reg_env3_bit0_3, GND},
    {reg1C, reg_env3_bit0_3, db0},

    {sid_clk1, env3_bit1_out, reg_env3_bit1_ltc1},
    {reg_env3_bit1_ltc1, reg_env3_bit1_1, GND},
    {reg_env3_bit1_1, reg_env3_bit1_2, GND},
    {reg_env3_bit1_2, Vcc, reg_env3_bit1_3},
    {reg_env3_bit1_1, reg_env3_bit1_3, GND},
    {reg1C, reg_env3_bit1_3, db1},

    {sid_clk1, env3_bit2_out, reg_env3_bit2_ltc1},
    {reg_env3_bit2_ltc1, reg_env3_bit2_1, GND},
    {reg_env3_bit2_1, reg_env3_bit2_2, GND},
    {reg_env3_bit2_2, Vcc, reg_env3_bit2_3},
    {reg_env3_bit2_1, reg_env3_bit2_3, GND},
    {reg1C, reg_env3_bit2_3, db2},

    {sid_clk1, env3_bit3_out, reg_env3_bit3_ltc1},
    {reg_env3_bit3_ltc1, reg_env3_bit3_1, GND},
    {reg_env3_bit3_1, reg_env3_bit3_2, GND},
    {reg_env3_bit3_2, Vcc, reg_env3_bit3_3},
    {reg_env3_bit3_1, reg_env3_bit3_3, GND},
    {reg1C, reg_env3_bit3_3, db3},

    {sid_clk1, env3_bit4_out, reg_env3_bit4_ltc1},
    {reg_env3_bit4_ltc1, reg_env3_bit4_1, GND},
    {reg_env3_bit4_1, reg_env3_bit4_2, GND},
    {reg_env3_bit4_2, Vcc, reg_env3_bit4_3},
    {reg_env3_bit4_1, reg_env3_bit4_3, GND},
    {reg1C, reg_env3_bit4_3, db4},

    {sid_clk1, env3_bit5_out, reg_env3_bit5_ltc1},
    {reg_env3_bit5_ltc1, reg_env3_bit5_1, GND},
    {reg_env3_bit5_1, reg_env3_bit5_2, GND},
    {reg_env3_bit5_2, Vcc, reg_env3_bit5_3},
    {reg_env3_bit5_1, reg_env3_bit5_3, GND},
    {reg1C, reg_env3_bit5_3, db5},

    {sid_clk1, env3_bit6_out, reg_env3_bit6_ltc1},
    {reg_env3_bit6_ltc1, reg_env3_bit6_1, GND},
    {reg_env3_bit6_1, reg_env3_bit6_2, GND},
    {reg_env3_bit6_2, Vcc, reg_env3_bit6_3},
    {reg_env3_bit6_1, reg_env3_bit6_3, GND},
    {reg1C, reg_env3_bit6_3, db6},

    {sid_clk1, env3_bit7_out, reg_env3_bit7_ltc1},
    {reg_env3_bit7_ltc1, reg_env3_bit7_1, GND},
    {reg_env3_bit7_1, reg_env3_bit7_2, GND},
    {reg_env3_bit7_2, Vcc, reg_env3_bit7_3},
    {reg_env3_bit7_1, reg_env3_bit7_3, GND},
    {reg1C, reg_env3_bit7_3, db7},
};
