/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2018 Red Hat, Inc.
 */

#ifndef __NM_LIBNM_BASE_H__
#define __NM_LIBNM_BASE_H__

/*****************************************************************************/

/* this must be the same as NM_UTILS_HWADDR_LEN_MAX from libnm. */
#define _NM_UTILS_HWADDR_LEN_MAX 20

/*****************************************************************************/

typedef enum {
    NM_ETHTOOL_ID_UNKNOWN = -1,

    _NM_ETHTOOL_ID_FIRST = 0,

    _NM_ETHTOOL_ID_COALESCE_FIRST      = _NM_ETHTOOL_ID_FIRST,
    NM_ETHTOOL_ID_COALESCE_ADAPTIVE_RX = _NM_ETHTOOL_ID_COALESCE_FIRST,
    NM_ETHTOOL_ID_COALESCE_ADAPTIVE_TX,
    NM_ETHTOOL_ID_COALESCE_PKT_RATE_HIGH,
    NM_ETHTOOL_ID_COALESCE_PKT_RATE_LOW,
    NM_ETHTOOL_ID_COALESCE_RX_FRAMES,
    NM_ETHTOOL_ID_COALESCE_RX_FRAMES_HIGH,
    NM_ETHTOOL_ID_COALESCE_RX_FRAMES_IRQ,
    NM_ETHTOOL_ID_COALESCE_RX_FRAMES_LOW,
    NM_ETHTOOL_ID_COALESCE_RX_USECS,
    NM_ETHTOOL_ID_COALESCE_RX_USECS_HIGH,
    NM_ETHTOOL_ID_COALESCE_RX_USECS_IRQ,
    NM_ETHTOOL_ID_COALESCE_RX_USECS_LOW,
    NM_ETHTOOL_ID_COALESCE_SAMPLE_INTERVAL,
    NM_ETHTOOL_ID_COALESCE_STATS_BLOCK_USECS,
    NM_ETHTOOL_ID_COALESCE_TX_FRAMES,
    NM_ETHTOOL_ID_COALESCE_TX_FRAMES_HIGH,
    NM_ETHTOOL_ID_COALESCE_TX_FRAMES_IRQ,
    NM_ETHTOOL_ID_COALESCE_TX_FRAMES_LOW,
    NM_ETHTOOL_ID_COALESCE_TX_USECS,
    NM_ETHTOOL_ID_COALESCE_TX_USECS_HIGH,
    NM_ETHTOOL_ID_COALESCE_TX_USECS_IRQ,
    NM_ETHTOOL_ID_COALESCE_TX_USECS_LOW,
    _NM_ETHTOOL_ID_COALESCE_LAST = NM_ETHTOOL_ID_COALESCE_TX_USECS_LOW,

    _NM_ETHTOOL_ID_FEATURE_FIRST         = _NM_ETHTOOL_ID_COALESCE_LAST + 1,
    NM_ETHTOOL_ID_FEATURE_ESP_HW_OFFLOAD = _NM_ETHTOOL_ID_FEATURE_FIRST,
    NM_ETHTOOL_ID_FEATURE_ESP_TX_CSUM_HW_OFFLOAD,
    NM_ETHTOOL_ID_FEATURE_FCOE_MTU,
    NM_ETHTOOL_ID_FEATURE_GRO,
    NM_ETHTOOL_ID_FEATURE_GSO,
    NM_ETHTOOL_ID_FEATURE_HIGHDMA,
    NM_ETHTOOL_ID_FEATURE_HW_TC_OFFLOAD,
    NM_ETHTOOL_ID_FEATURE_L2_FWD_OFFLOAD,
    NM_ETHTOOL_ID_FEATURE_LOOPBACK,
    NM_ETHTOOL_ID_FEATURE_LRO,
    NM_ETHTOOL_ID_FEATURE_MACSEC_HW_OFFLOAD,
    NM_ETHTOOL_ID_FEATURE_NTUPLE,
    NM_ETHTOOL_ID_FEATURE_RX,
    NM_ETHTOOL_ID_FEATURE_RXHASH,
    NM_ETHTOOL_ID_FEATURE_RXVLAN,
    NM_ETHTOOL_ID_FEATURE_RX_ALL,
    NM_ETHTOOL_ID_FEATURE_RX_FCS,
    NM_ETHTOOL_ID_FEATURE_RX_GRO_HW,
    NM_ETHTOOL_ID_FEATURE_RX_GRO_LIST,
    NM_ETHTOOL_ID_FEATURE_RX_UDP_GRO_FORWARDING,
    NM_ETHTOOL_ID_FEATURE_RX_UDP_TUNNEL_PORT_OFFLOAD,
    NM_ETHTOOL_ID_FEATURE_RX_VLAN_FILTER,
    NM_ETHTOOL_ID_FEATURE_RX_VLAN_STAG_FILTER,
    NM_ETHTOOL_ID_FEATURE_RX_VLAN_STAG_HW_PARSE,
    NM_ETHTOOL_ID_FEATURE_SG,
    NM_ETHTOOL_ID_FEATURE_TLS_HW_RECORD,
    NM_ETHTOOL_ID_FEATURE_TLS_HW_RX_OFFLOAD,
    NM_ETHTOOL_ID_FEATURE_TLS_HW_TX_OFFLOAD,
    NM_ETHTOOL_ID_FEATURE_TSO,
    NM_ETHTOOL_ID_FEATURE_TX,
    NM_ETHTOOL_ID_FEATURE_TXVLAN,
    NM_ETHTOOL_ID_FEATURE_TX_CHECKSUM_FCOE_CRC,
    NM_ETHTOOL_ID_FEATURE_TX_CHECKSUM_IPV4,
    NM_ETHTOOL_ID_FEATURE_TX_CHECKSUM_IPV6,
    NM_ETHTOOL_ID_FEATURE_TX_CHECKSUM_IP_GENERIC,
    NM_ETHTOOL_ID_FEATURE_TX_CHECKSUM_SCTP,
    NM_ETHTOOL_ID_FEATURE_TX_ESP_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_FCOE_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_GRE_CSUM_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_GRE_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_GSO_LIST,
    NM_ETHTOOL_ID_FEATURE_TX_GSO_PARTIAL,
    NM_ETHTOOL_ID_FEATURE_TX_GSO_ROBUST,
    NM_ETHTOOL_ID_FEATURE_TX_IPXIP4_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_IPXIP6_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_NOCACHE_COPY,
    NM_ETHTOOL_ID_FEATURE_TX_SCATTER_GATHER,
    NM_ETHTOOL_ID_FEATURE_TX_SCATTER_GATHER_FRAGLIST,
    NM_ETHTOOL_ID_FEATURE_TX_SCTP_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_TCP6_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_TCP_ECN_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_TCP_MANGLEID_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_TCP_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_TUNNEL_REMCSUM_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_UDP_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_UDP_TNL_CSUM_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_UDP_TNL_SEGMENTATION,
    NM_ETHTOOL_ID_FEATURE_TX_VLAN_STAG_HW_INSERT,
    _NM_ETHTOOL_ID_FEATURE_LAST = NM_ETHTOOL_ID_FEATURE_TX_VLAN_STAG_HW_INSERT,

    _NM_ETHTOOL_ID_RING_FIRST = _NM_ETHTOOL_ID_FEATURE_LAST + 1,
    NM_ETHTOOL_ID_RING_RX     = _NM_ETHTOOL_ID_RING_FIRST,
    NM_ETHTOOL_ID_RING_RX_JUMBO,
    NM_ETHTOOL_ID_RING_RX_MINI,
    NM_ETHTOOL_ID_RING_TX,
    _NM_ETHTOOL_ID_RING_LAST = NM_ETHTOOL_ID_RING_TX,

    _NM_ETHTOOL_ID_LAST = _NM_ETHTOOL_ID_RING_LAST,

    _NM_ETHTOOL_ID_COALESCE_NUM =
        (_NM_ETHTOOL_ID_COALESCE_LAST - _NM_ETHTOOL_ID_COALESCE_FIRST + 1),
    _NM_ETHTOOL_ID_FEATURE_NUM = (_NM_ETHTOOL_ID_FEATURE_LAST - _NM_ETHTOOL_ID_FEATURE_FIRST + 1),
    _NM_ETHTOOL_ID_RING_NUM    = (_NM_ETHTOOL_ID_RING_LAST - _NM_ETHTOOL_ID_RING_FIRST + 1),
    _NM_ETHTOOL_ID_NUM         = (_NM_ETHTOOL_ID_LAST - _NM_ETHTOOL_ID_FIRST + 1),
} NMEthtoolID;

#define _NM_ETHTOOL_ID_FEATURE_AS_IDX(ethtool_id)  ((ethtool_id) -_NM_ETHTOOL_ID_FEATURE_FIRST)
#define _NM_ETHTOOL_ID_COALESCE_AS_IDX(ethtool_id) ((ethtool_id) -_NM_ETHTOOL_ID_COALESCE_FIRST)

typedef enum {
    NM_ETHTOOL_TYPE_UNKNOWN,
    NM_ETHTOOL_TYPE_COALESCE,
    NM_ETHTOOL_TYPE_FEATURE,
    NM_ETHTOOL_TYPE_RING,
} NMEthtoolType;

/****************************************************************************/

static inline gboolean
nm_ethtool_id_is_feature(NMEthtoolID id)
{
    return id >= _NM_ETHTOOL_ID_FEATURE_FIRST && id <= _NM_ETHTOOL_ID_FEATURE_LAST;
}

static inline gboolean
nm_ethtool_id_is_coalesce(NMEthtoolID id)
{
    return id >= _NM_ETHTOOL_ID_COALESCE_FIRST && id <= _NM_ETHTOOL_ID_COALESCE_LAST;
}

static inline gboolean
nm_ethtool_id_is_ring(NMEthtoolID id)
{
    return id >= _NM_ETHTOOL_ID_RING_FIRST && id <= _NM_ETHTOOL_ID_RING_LAST;
}

/*****************************************************************************/

typedef enum {
    _NM_SETTING_WIRED_WAKE_ON_LAN_NONE      = 0,
    _NM_SETTING_WIRED_WAKE_ON_LAN_PHY       = 0x2,
    _NM_SETTING_WIRED_WAKE_ON_LAN_UNICAST   = 0x4,
    _NM_SETTING_WIRED_WAKE_ON_LAN_MULTICAST = 0x8,
    _NM_SETTING_WIRED_WAKE_ON_LAN_BROADCAST = 0x10,
    _NM_SETTING_WIRED_WAKE_ON_LAN_ARP       = 0x20,
    _NM_SETTING_WIRED_WAKE_ON_LAN_MAGIC     = 0x40,

    _NM_SETTING_WIRED_WAKE_ON_LAN_ALL = 0x7E,

    _NM_SETTING_WIRED_WAKE_ON_LAN_DEFAULT         = 0x1,
    _NM_SETTING_WIRED_WAKE_ON_LAN_IGNORE          = 0x8000,
    _NM_SETTING_WIRED_WAKE_ON_LAN_EXCLUSIVE_FLAGS = 0x8001,
} _NMSettingWiredWakeOnLan;

/*****************************************************************************/

typedef enum {
    /* In priority order; higher number == higher priority */

    NM_IP_CONFIG_SOURCE_UNKNOWN = 0,

    /* for routes, the source is mapped to the uint8 field rtm_protocol.
     * Reserve the range [1,0x100] for native RTPROT values. */

    NM_IP_CONFIG_SOURCE_RTPROT_UNSPEC   = 1 + 0,
    NM_IP_CONFIG_SOURCE_RTPROT_REDIRECT = 1 + 1,
    NM_IP_CONFIG_SOURCE_RTPROT_KERNEL   = 1 + 2,
    NM_IP_CONFIG_SOURCE_RTPROT_BOOT     = 1 + 3,
    NM_IP_CONFIG_SOURCE_RTPROT_STATIC   = 1 + 4,
    NM_IP_CONFIG_SOURCE_RTPROT_RA       = 1 + 9,
    NM_IP_CONFIG_SOURCE_RTPROT_DHCP     = 1 + 16,
    _NM_IP_CONFIG_SOURCE_RTPROT_LAST    = 1 + 0xFF,

    NM_IP_CONFIG_SOURCE_KERNEL,
    NM_IP_CONFIG_SOURCE_SHARED,
    NM_IP_CONFIG_SOURCE_IP4LL,
    NM_IP_CONFIG_SOURCE_IP6LL,
    NM_IP_CONFIG_SOURCE_PPP,
    NM_IP_CONFIG_SOURCE_WWAN,
    NM_IP_CONFIG_SOURCE_VPN,
    NM_IP_CONFIG_SOURCE_DHCP,
    NM_IP_CONFIG_SOURCE_NDISC,
    NM_IP_CONFIG_SOURCE_USER,
} NMIPConfigSource;

static inline gboolean
NM_IS_IP_CONFIG_SOURCE_RTPROT(NMIPConfigSource source)
{
    return source > NM_IP_CONFIG_SOURCE_UNKNOWN && source <= _NM_IP_CONFIG_SOURCE_RTPROT_LAST;
}

/****************************************************************************/

#endif /* __NM_LIBNM_BASE_H__ */
