//-----------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
//-----------------------------------------------------------------------------
namespace System.IdentityModel.Selectors
{
    using System;
    using System.Runtime.InteropServices;
    using System.Threading;
    using IDT = Microsoft.InfoCards.Diagnostics.InfoCardTrace;

    //
    // Summary:
    //  Wraps a TransformCryptoSession
    //
    internal class TransformCryptoHandle : CryptoHandle
    {
        public TransformCryptoHandle(InternalRefCountedHandle nativeHandle, DateTime expiration, IntPtr parameters)
            : base(nativeHandle, expiration, parameters, typeof(RpcTransformCryptoParameters))
        {
        }
        private TransformCryptoHandle(InternalRefCountedHandle internalHandle) : base(internalHandle) { }

        protected override CryptoHandle OnDuplicate()
        {
            return new TransformCryptoHandle(InternalHandle);
        }

    }
}

