/***************************** LICENSE START ***********************************

 Copyright 2016 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "GribExaminer.h"

#include <iostream>
#include "Metview.h"
#include "MvQService.h"
#include "MvQServiceApplication.h"
#include "MvQKeyManager.h"
#include "GribMetaData.h"


using namespace std;

// Globals
int          ac;
char       **av;

class Base : public MvQService
{
protected:
	Base(char* a) : MvQService(a) {};
};

class MvGribExaminer : public Base
{
public:
	MvGribExaminer(char* type) : Base(type) {};
	void serve(MvRequest&,MvRequest&);
};

void MvGribExaminer::serve( MvRequest& in, MvRequest& /*out*/)
{
  	cout << "--------------MvGribBrowser::serve()--------------" << endl;
  	in.print();

	//Get grib file name
	const char* tmpc = in("PATH");

	//Set grib file name
	string fgrib(tmpc);

	//Set tmpfile name
	string ftmp=marstmp();

	//Filter
	const char* temporary= (const char*)in("TEMPORARY");

	//const char *offset=in("TEMPORARY");

	//Reading the offset values following the techique
	// used in function  "_request_to_fieldset" in field.c in MARS
	int cnt = in.countValues("OFFSET");
	vector<off_t> offset;
	for(int i=0; i< cnt; i++)
	{
		const char* cval;
		in.getValue(cval,"OFFSET",i);
#ifdef LARGE_FILES_SUPPORT
		offset.push_back(atoll(cval));
#else
		offset.push_back(atol(cval));
#endif
	}

	cnt = in.countValues("LENGTH");
	vector<int> len;
	for(int i=0; i< cnt; i++)
	{
		int ival;
		in.getValue(ival,"LENGTH",i);
		len.push_back(ival);
	}

	//Create the qt application
	MvQServiceApplication app(ac, av);

	//Initialise resorces from a static library (libMvQtGui)
	Q_INIT_RESOURCE(examiner);
	Q_INIT_RESOURCE(keyDialog);
	Q_INIT_RESOURCE(window);
	Q_INIT_RESOURCE(find);
	
	//Create the grib key manager and initialize it
	MvQKeyManager *manager = new MvQKeyManager(MvQKeyManager::GribType);
	manager->loadProfiles();

	//Create the grib metadata object and initialize it
	GribMetaData *grib = new GribMetaData;
	grib->setFileName(fgrib);

	if(temporary && strcmp(temporary,"0") == 0 &&
	   offset.size() > 0)
	{
		grib->setFilter(offset,len);
	}

	//Create the grib browser and initialize it
	GribExaminer *browser = new GribExaminer(ftmp);
    browser->init(grib,manager,0);
   	browser->show();

	//Listen to the mars event loop!
	setupSocketNotifier();
	
    // Send message to Desktop (but not to MvExamineManager)
    // to turn the icon green; otherwise, it will stay orange.
    if( strcmp( getenv("METVIEW_MODE"), "examine" ) != 0 )
    {
        acknowledgeGuiStartup();
    }

	//Enter the app loop
 	app.exec();
}

int main( int argc, char **argv )
{
	ac = argc;
  	av = argv;

	MvApplication theApp( argc, argv );

	MvGribExaminer grib ("GRIB");
	MvGribExaminer image("IMAGE");

	theApp.run();
}



