; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/ArrSize/100/g' %s | llc -mtriple=riscv32 -riscv-enable-global-merge \
; RUN:   -verify-machineinstrs | FileCheck %s
; RUN: sed 's/ArrSize/100/g' %s | llc -mtriple=riscv64 -riscv-enable-global-merge \
; RUN:   -verify-machineinstrs | FileCheck %s
; RUN: sed 's/ArrSize/101/g' %s | llc -mtriple=riscv32 -riscv-enable-global-merge \
; RUN:   -verify-machineinstrs | FileCheck %s -check-prefix=CHECK-TOOBIG
; RUN: sed 's/ArrSize/101/g' %s | llc -mtriple=riscv64 -riscv-enable-global-merge \
; RUN:   -verify-machineinstrs | FileCheck %s -check-prefix=CHECK-TOOBIG

; This test demonstrates that the MaxOffset is set correctly for RISC-V by
; constructing an input that is at the limit and comparing.

@ga1 = dso_local global [410 x i32] zeroinitializer, align 4
@ga2 = dso_local global [ArrSize x i32] zeroinitializer, align 4
@gi = dso_local global i32 0, align 4

; TODO: It would be better for codesize if the final store below was
; `sw a0, 0(a2)`.

define void @f1(i32 %a) nounwind {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(.L_MergedGlobals)
; CHECK-NEXT:    addi a2, a1, %lo(.L_MergedGlobals)
; CHECK-NEXT:    sw a0, 2044(a2)
; CHECK-NEXT:    sw a0, 404(a2)
; CHECK-NEXT:    sw a0, %lo(.L_MergedGlobals)(a1)
; CHECK-NEXT:    ret
;
; CHECK-TOOBIG-LABEL: f1:
; CHECK-TOOBIG:       # %bb.0:
; CHECK-TOOBIG-NEXT:    lui a1, %hi(ga1+1640)
; CHECK-TOOBIG-NEXT:    lui a2, %hi(.L_MergedGlobals)
; CHECK-TOOBIG-NEXT:    addi a3, a2, %lo(.L_MergedGlobals)
; CHECK-TOOBIG-NEXT:    sw a0, %lo(ga1+1640)(a1)
; CHECK-TOOBIG-NEXT:    sw a0, 408(a3)
; CHECK-TOOBIG-NEXT:    sw a0, %lo(.L_MergedGlobals)(a2)
; CHECK-TOOBIG-NEXT:    ret
  %ga1_end = getelementptr inbounds [410 x i32], ptr @ga1, i32 0, i64 410
  %ga2_end = getelementptr inbounds [ArrSize x i32], ptr @ga2, i32 0, i64 ArrSize
  store i32 %a, ptr %ga1_end, align 4
  store i32 %a, ptr %ga2_end, align 4
  store i32 %a, ptr @gi, align 4
  ret void
}
