# -*- coding: utf-8 -*-
#
# graph-tool documentation build configuration file, created by
# sphinx-quickstart on Sun Oct 26 18:29:16 2008.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# The contents of this file are pickled, so don't put values in the namespace
# that aren't pickleable (module imports are okay, they're removed
# automatically).
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys, os

# If your extensions are in another directory, add it here. If the directory
# is relative to the documentation root, use os.path.abspath to make it
# absolute, like shown here.
sys.path.append(os.path.abspath('.'))

# General configuration
# ---------------------

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.doctest',
              'sphinx.ext.intersphinx', 'sphinx.ext.mathjax',
              'sphinx.ext.autosummary',
              'numpydoc',
              'sphinx.ext.extlinks',
              'sphinx.ext.viewcode',
              'extlinks_fancy',
              #'sphinx.ext.linkcode'
              #'matplotlib.sphinxext.plot_directive'
              ]

mathjax_path = "MathJax/tex-chtml-full.js"

# Add any paths that contain templates here, relative to this directory.
templates_path = ['.templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'graph-tool'
copyright = u'2006-2023, Tiago de Paula Peixoto <tiago@skewed.de>'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
from graph_tool import __version__ as gt_version
version = gt_version.split()[0]
# The full version, including alpha/beta/rc tags.
release = gt_version.split()[0]

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = ['.build']

exclude_patterns = ['**/_*.rst']

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# doctest

doctest_global_setup = open("pyenv.py").read()
doctest_global_setup += "os.chdir('%s')\n" % os.getcwd()

# Options for HTML outputs
# -----------------------

# The style sheet to use for HTML and HTML Help pages. A file of that name
# must exist either in Sphinx' static/ path, or in one of the custom paths
# given in html_static_path.
# html_style = 'default.css'

html_theme = "pydata_sphinx_theme"
#html_theme = "gt_theme"
#html_theme_path = ["."]

html_theme_options = {
    "gitlab_url": "https://git.skewed.de/count0/graph-tool",
    "icon_links": [
        {
            "name": "Mastodon",
            "url": "https://social.skewed.de/@graph_tool",
            "icon": "fa-brands fa-mastodon",
        },
        {
            "name": "Discourse",
            "url": "https://forum.skewed.de/c/graph-tool/5",
            "icon": "fa-brands fa-discourse",
        },
        {
            "name": "graph-tool",
            "url": "https://graph-tool.skewed.de",
            "icon": "_static/graph-tool-logo.svg",
            "type": "local",
        },
    ],
    "primary_sidebar_end": ["indices.html"],
    "use_edit_page_button": True,
    "logo": {
        "image_light": "graph-tool-logo.svg",
        "image_dark": "graph-tool-logo.svg",
        "text": f"graph-tool docs ({version})"
    }
}

html_context = {
    "gitlab_url": "https://git.skewed.de",
    "gitlab_user": "count0",
    "gitlab_repo": "graph-tool",
    "gitlab_version": "master",
    "doc_path": "/doc"
}

html_logo = "graph-tool-logo.svg"

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "graph-icon.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['.static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%b %d, %Y'

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_use_modindex = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, the reST sources are included in the HTML build as _sources/<name>.
html_copy_source = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
html_use_opensearch = 'http://graph-tool.skewed.de/doc/'

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'graph-tooldoc'


# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'python': ('https://docs.python.org/3', None),
                       'numpy': ('https://numpy.org/doc/stable/', None),
                       'scipy': ('https://docs.scipy.org/doc/scipy/reference', None),
                       'matplotlib': ('https://matplotlib.org', None),
                       'cairo': ('https://www.cairographics.org/documentation/pycairo/3', None),
                       'ipython': ('https://ipython.org/ipython-doc/stable/', None),
                       'panda': ('https://pandas.pydata.org/pandas-docs/stable/', None)}

extlinks_fancy = {'issue': (['https://git.skewed.de/count0/graph-tool/issues/{0}'],
                             ['issue #{0}']),
                  'doi': (['https://dx.doi.org/{0}',
                           'https://sci-hub.ru/{0}',
                           'https://scihub22266oqcxt.onion.link/{0}'],
                          ['DOI: {0}', "sci-hub", "@tor"]),
                  'arxiv': (['https://arxiv.org/abs/{0}'], ['arXiv: {0}']),
                  'ns': (['https://networks.skewed.de/net/{0}'], ['{0}'])}

# plot directive
import pyenv
plot_rcparams = pyenv.rcParams
#plot_pre_code = open("pyenv.py").read()


autodoc_default_options = {
    'members': True,
    'member-order': 'bysource',
    'undoc-members': True
}

autosummary_gerenerate = True
autosummary_imported_members = True
autosummary_ignore_module_all = False
numpydoc_show_class_members = False
autodoc_docstring_signature = False
autoclass_content = 'both'
imported_members = True

def linkcode_resolve(domain, info):
    if domain != 'py':
        return None
    if not info['module']:
        return None
    modname = info['module'].replace('.', '/')
    return "https://git.skewed.de/count0/graph-tool/tree/master/src/%s/__init__.py" % modname

nitpicky = True
