#!/usr/bin/perl -w
#
# cp2iso.pl
# Translates CP1250 to ISO8859-2 in incoming messages
#
# Written by Jakub Jankowski <shasta@atn.pl>
# for Irssi 0.7.98.4+
#
# Code looks much prettier now, thanks to Ion's euro.pl :)
#
# Use at your own risk, though ;)

use strict;
use vars qw($VERSION %IRSSI);

$VERSION = "1.1";
%IRSSI = (
    authors     => 'Jakub Jankowski',
    contact     => 'shasta@atn.pl',
    name        => 'cp2iso',
    description => 'Translates CP1250 to ISO8859-2 in incoming messages',
    license     => 'GNU GPLv2 or later',
    url         => 'http://irssi.atn.pl/',
);

use Irssi;

my $cp1250_notifier = " [cp1250]";

sub message_public {
	return unless $_[1] =~ tr/\214\234\217\237\245\271/\246\266\254\274\241\261/;
	$_[1] .= $cp1250_notifier;
	Irssi::signal_stop();
	Irssi::signal_emit("message public", @_);
}

sub message_private {
	return unless $_[1] =~ tr/\214\234\217\237\245\271/\246\266\254\274\241\261/;
	$_[1] .= $cp1250_notifier;
	Irssi::signal_stop();
	Irssi::signal_emit("message private", @_);
}

sub message_irc_action {
	return unless $_[1] =~ tr/\214\234\217\237\245\271/\246\266\254\274\241\261/;
	$_[1] .= $cp1250_notifier;
	Irssi::signal_stop();
	Irssi::signal_emit("message irc action", @_);
}

sub message_part {
	return unless $_[4] =~ tr/\214\234\217\237\245\271/\246\266\254\274\241\261/;
	$_[4] .= $cp1250_notifier;
	Irssi::signal_stop();
	Irssi::signal_emit("message part", @_);
}

sub message_quit {
	return unless $_[3] =~ tr/\214\234\217\237\245\271/\246\266\254\274\241\261/;
	$_[3] .= $cp1250_notifier;
	Irssi::signal_stop();
	Irssi::signal_emit("message quit", @_);
}

sub message_kick {
	return unless $_[5] =~ tr/\214\234\217\237\245\271/\246\266\254\274\241\261/;
	$_[5] .= $cp1250_notifier;
	Irssi::signal_stop();
	Irssi::signal_emit("message kick", @_);
}

sub message_topic {
	return unless $_[2] =~ tr/\214\234\217\237\245\271/\246\266\254\274\241\261/;
	$_[2] .= $cp1250_notifier;
	Irssi::signal_stop();
	Irssi::signal_emit("message topic", @_);
}

Irssi::signal_add("message public", "message_public");
Irssi::signal_add("message private", "message_private");
Irssi::signal_add("message irc action", "message_irc_action");
Irssi::signal_add("message part", "message_part");
Irssi::signal_add("message quit", "message_quit");
Irssi::signal_add("message kick", "message_kick");
Irssi::signal_add("message topic", "message_topic");
