# $Id: libchipcard.m4,v 1.4 2003/05/08 00:55:26 aquamaniac Exp $
# Author of this file: Martin Preuss<martin@libchipcard.de>

AC_DEFUN(AC_LIBCHIPCARD, [
dnl searches for libchipcard
dnl Arguments: 
dnl   $1: major version minimum
dnl   $2: minor version minimum
dnl   $3: patchlevel version minimum
dnl   $4: build version minimum
dnl Returns: libchipcard_dir
dnl          libchipcard_libs
dnl          libchipcard_includes
dnl          have_libchipcard (set to yes if libchipcard is available)

if test -z "$1"; then vma="0"; else vma="$1"; fi
if test -z "$2"; then vmi="7"; else vmi="$2"; fi
if test -z "$3"; then vpl="0"; else vpl="$3"; fi
if test -z "$4"; then vbld="0"; else vbld="$4"; fi

AC_MSG_CHECKING(if libchipcard support desired)
AC_ARG_ENABLE(libchipcard,
  [  --enable-libchipcard      enable libchipcard support (default=yes)],
  enable_libchipcard="$enableval",
  enable_libchipcard="yes")
AC_MSG_RESULT($enable_libchipcard)

libchipcard_dir=""
libchipcard_libs=""
libchipcard_includes=""
if test "$enable_libchipcard" != "no"; then
  AC_MSG_CHECKING(for libchipcard)
  AC_ARG_WITH(chipcard-dir, [  --with-chipcard-dir=DIR
                            uses libchipcard from given dir],
    [lcc_dir="$withval"],
    [lcc_dir="/usr/local/libchipcard \
             /usr/local \
             /usr/libchipcard \
             /usr \
             /"])

  for li in $lcc_dir; do
      if test -x "$li/bin/libchipcard-config"; then
          libchipcard_dir="$li"
      fi
  done
  if test -z "$libchipcard_dir"; then
      AC_MSG_RESULT([not found (chipcard support disabled)])
  else
      libchipcard_libs="`$libchipcard_dir/bin/libchipcard-config --libraries`"
      libchipcard_includes="`$libchipcard_dir/bin/libchipcard-config --includes`"
      AC_MSG_RESULT($libchipcard_dir)
  fi
  AC_MSG_CHECKING(if libchipcard support desired)
  AC_ARG_ENABLE(libchipcard,
    [  --enable-libchipcard-test   enable libchipcard-test (default=yes)],
     enable_libchipcard_test="$enableval",
     enable_libchipcard_test="yes")
  AC_MSG_RESULT($enable_libchipcard_test)
  AC_MSG_CHECKING(for LibChipCard version >=$vma.$vmi.$vpl)
  if test "$vma" -gt "`$libchipcard_dir/bin/libchipcard-config --vmajor`"; then
    AC_MSG_ERROR([Your LibChipCard version is way too old.
    Please update from www.libchipcard.de])
  elif test "$vma" = "`$libchipcard_dir/bin/libchipcard-config --vmajor`"; then
    if test "$vmi" -gt "`$libchipcard_dir/bin/libchipcard-config --vminor`"; then
      AC_MSG_ERROR([Your LibChipCard version is too old.
        Please update from www.libchipcard.de])
    elif test "$vmi" = "`$libchipcard_dir/bin/libchipcard-config --vminor`"; then
        if test "$vpl" -gt "`$libchipcard_dir/bin/libchipcard-config --vpatchlevel`"; then
          AC_MSG_ERROR([Your LibChipCard version is a little bit too old.
          Please update from www.libchipcard.de])
        elif test "$vpl" = "`$libchipcard_dir/bin/libchipcard-config --vpatchlevel`"; then
          if test "$vbld" -gt "`$libchipcard_dir/bin/libchipcard-config --vbuild`"; then
            AC_MSG_ERROR([Your LibChipCard version is a little bit too old.
            Please update from www.libchipcard.de])
          fi
        fi
    fi
  fi
  AC_MSG_RESULT(yes)
  have_libchipcard="yes"
dnl end of "if enable-libchipcard"
fi
AC_SUBST(libchipcard_dir)
AC_SUBST(libchipcard_libs)
AC_SUBST(libchipcard_includes)
])


