/***************************************************************************
 $RCSfile: ctprocessorcard.cpp,v $
                             -------------------
    cvs         : $Id: ctprocessorcard.cpp,v 1.8 2003/04/24 01:43:29 aquamaniac Exp $
    begin       : Wed Aug 29 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_CHIPCARD_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* Not BUILDING_CHIPCARD_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_CHIPCARD_DLL */
#else
# define CHIPCARD_API
#endif

#include "cterror.h"
#include "ctpointer.h"
#include "ctcommand.h"
#include "ctcard.h"
#include "ctmisc.h"
#include "ctprocessorcard.h"
#include <engine/chameleon/error.h>
#include <engine/chameleon/debug.h>


CTProcessorCard::CTProcessorCard(const CTCard &c)
:CTCard(c)
{
}


CTProcessorCard::~CTProcessorCard(){

}


CTError CTProcessorCard::_selectMF(string &fcp){
  return execCommand("select_mf",
		   _cmdSelectMF,
		   fcp);
}


CTError CTProcessorCard::selectMF(string &fcp){
  CTError err;

  err=_selectMF(fcp);
  if (err.isOk())
    return err;

  return selectFile(fcp,0x3f00);
}


CTError CTProcessorCard::selectParent(string &fcp){
  return execCommand("select_parent",
		   _cmdSelectParent,
		   fcp);
}


CTError CTProcessorCard::_selectDF(string &fcp, unsigned short fid){
  return execCommand("select_df",
		   _cmdSelectDF,
		   fcp,
		   CTMisc::num2string(fid));
}


CTError CTProcessorCard::selectDF(string &fcp, unsigned short fid){
  CTError err;

  err=_selectDF(fcp,fid);
  if (err.isOk(0x6a,0x82))
    return err;

  return selectFile(fcp,fid);
}


CTError CTProcessorCard::_selectEF(string &fcp, unsigned short fid){
  return execCommand("select_ef",
		   _cmdSelectEF,
		   fcp,
		   CTMisc::num2string(fid));
}


CTError CTProcessorCard::selectEF(string &fcp, unsigned short fid){
  CTError err;

  err=_selectEF(fcp,fid);
  if (err.isOk(0x6a,0x82))
    return err;

  return selectFile(fcp,fid);
}


CTError CTProcessorCard::_selectById(string &fcp, string id){
  return execCommand("select_file_id",
		   _cmdSelectId,
		   fcp,
		   CTMisc::bin2hex(id));
}


CTError CTProcessorCard::selectById(string &fcp, string id){
  CTError err;

  err=_selectById(fcp,id);
  if (err.isOk(0x6a,0x82))
    return err;

  return selectFile(fcp,id);
}


CTError CTProcessorCard::readRecord(string &data,
				    unsigned char num,
				    unsigned char bytes){
  if (bytes==0)
    return execCommand("read_record",
		     _cmdReadRecord,
		     data,
		     CTMisc::num2string(num),
		     "256");
  else
    return execCommand("read_record",
		     _cmdReadRecord,
		     data,
		     CTMisc::num2string(num),
		     CTMisc::num2string(bytes));
}


CTError CTProcessorCard::updateRecord(string &data,unsigned char num){
  string response;

  return execCommand("update_record",
		   _cmdUpdateRecord,
		   response,
		   CTMisc::num2string(num),
		   CTMisc::bin2hex(data));
}


CTError CTProcessorCard::reopenCard(){
  DBG_INFO("LIBCHIPCARD: The method \"CTProcessorCard::reopenCard()\"\n"
	   "has been called. Since THIS class does nothing on this method\n"
	   "I guess you have an error in your program.\n");
  return CTError();
}


string CTProcessorCard::cardType(){
  return "CTProcessorCard";
}


string CTProcessorCard::cardTypes(){
  return CTCard::cardTypes()+",CTProcessorCard";
}





