/***************************************************************************
 $RCSfile: ctcommand.h,v $
                             -------------------
    cvs         : $Id: ctcommand.h,v 1.3 2003/01/10 20:02:11 aquamaniac Exp $
    begin       : Thu May 30 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */


#ifndef CTCOMMAND_H
#define CTCOMMAND_H

class CTCommand;


#include <string>
using namespace std;


/**
 * This is the command struct for an iso command.
 * @author Martin Preuss<martin@libchipcard.de>
 * @short Describes a APDU (command for a chip card)
 * @ingroup misc
 */
class CHIPCARD_API CTCommand {
private:
    unsigned char _cla;
    unsigned char _ins;
    unsigned char _p1;
    unsigned char _p2;
    string _data;
    unsigned short _lr;
    unsigned char _sw1;
    unsigned char _sw2;


public:
    /**
     * command class 0x20 for terminal, 0x00 for card. some cards may define
     * other classes, so have a look at the documentation for the card you
     * want to write classes for
     */
    unsigned char cla() const { return _cla;};
    void setCla(unsigned char c) { _cla=c;};

    /**
     * @short command (depends on your chip card)
     */
    unsigned char ins() const { return _ins;};
    void setIns(unsigned char c) { _ins=c;};

    /**
     * @short some commands have parameters which are stored in p1 and p2.
     */
    unsigned char p1() const { return _p1;};
    void setP1(unsigned char c) { _p1=c;};

    /**
     * @short some commands have parameters which are stored in p1 and p2.
     */
    unsigned char p2() const { return _p2;};
    void setP2(unsigned char c) { _p2=c;};

    /**
     * @short data to be send and data received, respectively.
     * Please note
     * that this field gets overwritten upon transmission to the chip card
     * or terminal.
     */
    const string &data() const { return _data;};
    void setData(const string &s) { _data=s;};
    void setData(const char *p, unsigned int s) { _data.assign(p,s);};
    void setData(char c) { _data=c;};
    void setData(unsigned char c) { _data=(char)c;};
    void addData(const string &s) { _data+=s;};
    void addData(char c) { _data+=c;};
    void addData(unsigned char c) { _data+=(char)c;};

    /**
     * @short expected maxmimum length of card's answer.
     * This field is somewhat tricky. The reason is, that this field MAY
     * occur, it may have a valid value and/or it may have the value 0 for
     * CTAPI. To reflect this I gave this field special handling for some
     * values:
     * - 0 means that no answer from the card is expected
     * - 1-255 tell the precise number of bytes expected
     * - 256 or higher mean: no limit (256 or more bytes)
     */
    unsigned short lr() const { return _lr;};
    void setLr(unsigned short s) { _lr=s;};

    /**
     * All commands return a two byte result code, if they were processed
     * by the card. The first one is here.
     * @short general processing status
     */
    unsigned char sw1() const { return _sw1;};
    void setSw1(unsigned char c) { _sw1=c;};

    /**
     * All commands return a two byte result code, if they were processed
     * by the card. This is the second one (processing qualifier, tells you
     * more precise about the result)
     * @short processing qualifier
     */
    unsigned char sw2() const { return _sw2;};
    void setSw2(unsigned char c) { _sw2=c;};

    CTCommand();
    ~CTCommand();

    /**
     * Creates an APDU from this command object.
     */
    string toString();

};




#endif


