/*****************************************************************************
 *                              SdbSignal.h
 * 
 * Author: Matthew Ballance
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#ifndef INCLUDED_SDB_SIGNAL_H
#define INCLUDED_SDB_SIGNAL_H
#include "CmdSwitcher.h"
#include "ivi_String.h"
#include "IviUintHashTab.h"
#include <tcl.h>
#include <tk.h>


extern "C" unsigned ivi_format_dec(const unsigned char *bits, 
        unsigned int nbits, char *buf, unsigned int nbuf, int signed_flag);


typedef enum {
    SDS_Config  = 1,
    SDS_Cget,
    SDS_Delete,
    SDS_Index,
    SDS_GetValue,
    SDS_NextEdge,
    SDS_PrevEdge,
    SDS_SetEnum,
    SDS_ClrEnum,
    SDS_GetEnum,
    SDS_LastCmd
} SdbSignalCmds;

static CmdSwitchStruct    sdbSignalCmds[] = {
    {"config",            SDS_Config        },
    {"configure",         SDS_Config        },
    {"cget",              SDS_Cget          },
    {"delete",            SDS_Delete        },
    {"index",             SDS_Index         },
    {"get_value",         SDS_GetValue      },
    {"next_edge",         SDS_NextEdge      },
    {"prev_edge",         SDS_PrevEdge      },
    {"set_enum",          SDS_SetEnum       },
    {"clr_enum",          SDS_ClrEnum       },
    {"get_enum",          SDS_GetEnum       },
    {"",                  0                 }
};

class SdbReader;
class DFIOTrace;
class DFIOValChg;
struct  DFIOVal;

class SdbSignal {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * SdbSignal()
         ************************************************************/
        SdbSignal(
              SdbReader  *sdbr,
              Tcl_Interp *interp, 
              Char       *id, 
              Char       *name, 
              Uint32      msb, 
              Uint32      lsb, 
              DFIOTrace  *dfioTrace);

        /************************************************************
         * ~SdbSignal()
         ************************************************************/
        virtual ~SdbSignal(void);

    inline Uint32 getVisTraces(void) {
        return (expanded)?(len+1):1;
    }

    inline Uint32 isExpanded(void) {
        return expanded;
    }

    inline Uint32 isSeparator(void) {
        return separator;
    }

    inline void Separator(Uint32 sep) {
        separator = sep;
    }
   
    inline void expandTrace(void) {
        expanded = 1;
    }

    inline void contractTrace(void) {
        expanded = 0;
    }

    inline Uint32 traceMin(void) {
        return 0;
    }

    inline Uint32 traceMax(void) {
        return (expanded)?(len):0;
    }

    inline Uint32 length(void) { return len; }

    inline Char *getFullName(void) {return fullName;}
    inline Char *getDispName(void) {return dispName;}


    SdbReader        *sdbr;
    DFIOTrace        *dfioTrace;
    Char             *id;

    enum ValueFormat {
        ValFmt_BitStr,
        ValFmt_Hex,
        ValFmt_Dec,
        ValFmt_Oct,
        ValFmt_String,
        ValFmt_Enum
    };

    void SetFormat(Uint32    valueFormat) {
        this->valueFormat = valueFormat;
    }

    inline const char *GetFormat(void) {
        return (valueFormat == ValFmt_BitStr)?"bin":
           (valueFormat == ValFmt_Hex)?"hex":
           (valueFormat == ValFmt_Dec)?"dec":
           (valueFormat == ValFmt_Enum)?"enum":"unknown";
    }


    void FormatValue(DFIOValChg *value, String &fmtVal);
    void FormatValue(DFIOValChg *value, String &fmtVal, Uint32 &flags);

    void FormatValueStr(DFIOValChg *value, Char *formattedVal);
    void FormatValueHex(DFIOValChg *value, Char *formattedVal);
    void FormatValueDec(DFIOValChg *value, Char *formattedVal);

    void fmtEnum(const DFIOVal *value, String &fmtVal, Uint32 &flags);

    Int32 InstCmd(Uint32 argc, Char **argv);

    void setSdbName(char *name) { sdbName = name; }

    Uint32 getMsb() { return msb; }
    Uint32 getLsb() { return lsb; }

private:
    Int32 Configure(Uint32 argc, Char **argv, Uint32 flags);
    Int32 getValue(Uint32 argc, Char **argv);
    void  findEdge(Uint32 time, Uint32 fwd, Uint32 *nextTime);

    Tcl_Interp       *interp;
    Uint32            expanded;      /*** true if trace is expanded    ***/
    Uint32            separator;     /*** true if trace is a separator ***/
    Uint32            valueFormat;
    Char             *radix;
    Uint32            visEl;         /*** currently-visible path elements ***/
    Uint32            msb;
    Uint32            lsb;
    Uint32            len;
    Char             *fullName;
    Char             *dispName;    
    Char             *sdbName;
    Int32             hasEnum;
    String            tmpValStr;

    IviUintHashTab<String *>  *d_EnumHash;

    enum {
        Opt_Radix,
        Opt_Separator,
        Opt_Visel,
        Opt_Msb,          /**** Read-only                                ****/
        Opt_Lsb,          /**** Read-only                                ****/
        Opt_Fullname,     /**** Full signal-name path                    ****/
        Opt_Dispname,     /**** Derivative of fullName or user-specified ****/
        Opt_Expanded,     /**** R/W                                      ****/
        Opt_NumOpts
    };

    /*************************************************************************
     * getConfigSpec()
     *************************************************************************/
    Tk_ConfigSpec *getConfigSpec() ;

    /*************************************************************************
     * optionSpecified()
     *************************************************************************/
    Uint32 optionSpecified(Uint32 idx) {
        return (getConfigSpec()[idx].specFlags & TK_CONFIG_OPTION_SPECIFIED);
    }

    /****************************************************************
     * setEnum()
     ****************************************************************/
    int setEnum(int argc, char **argv);

    /****************************************************************
     * clrEnum()
     ****************************************************************/
    int clrEnum(int argc, char **argv);
  
    /****************************************************************
     * getEnum()
     ****************************************************************/
    int getEnum(int argc, char **argv);
};

#endif /* INCLUDED_SDB_SIGNAL_H */


