/****************************************************************************
 *                            RemoteAppServer.h
 *
 * Author: Matthew Ballance
 * Desc:   Data structures for a remote socket server. This server listens
 *         on a given socket and listens for connections from a remote
 *         process.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_REMOTE_APP_SERVER_H
#define INCLUDED_REMOTE_APP_SERVER_H
#include "types.h"
#include <tcl.h>

class RemoteAppServer {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * RemoteAppServer()
         ************************************************************/
        RemoteAppServer(Tcl_Interp *interp);

        /************************************************************
         * getServerPort()
         ************************************************************/
        Int32 getServerPort() const { return d_port; }

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * AcceptProc()
         ************************************************************/
        static void AcceptProc(
                ClientData         clientData,
                Tcl_Channel        channel,
                char              *hostname,
                int                port) {
            ((RemoteAppServer *)clientData)->Accept(channel, hostname, port);
        }
        void Accept(Tcl_Channel channel, char *hostname, int port);

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        Tcl_Interp             *d_interp;
        Tcl_Channel             d_channel;

        Int32                   d_skt;
        Int32                   d_port;
};

#endif /* INCLUDED_REMOTE_APP_SERVER_H */

