/****************************************************************************
 *                           IviRemoteAppIdx.h
 *
 * Author: Matthew Ballance
 * Desc:   Defines comm-channel indexes
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_IVI_REMOTE_APP_IDX_H
#define INCLUDED_IVI_REMOTE_APP_IDX_H

#define IVI_CMD_CH_IDX_INTERNAL        0
#define IVI_CMD_CH_IDX_TCL_CMD         1
#define IVI_CMD_CH_IDX_TCL_CMD_RESP    2

/********************************************************************
 * Private data
 ********************************************************************/

/***************************************************************
 * IVI_INT_CMD_CONNECT
 *
 * Command from client to master. Indicates that a connection 
 * should be initiated.
 *
 * Data packet layout:
 * Command    - 4 bytes
 * Client PID - 4 bytes
 ***************************************************************/
#define IVI_INT_CMD_CONNECT            0

/***************************************************************
 * IVI_INT_CMD_CONNECT_ACK
 *
 * Command from master to client. Sent once the channel user
 * has added its index handlers.
 *
 * Data packet layout:
 * Command   - 4 bytes
 ***************************************************************/
#define IVI_INT_CMD_CONNECT_ACK        1

#endif /* INCLUDED_IVI_REMOTE_APP_IDX_H */


