/****************************************************************************
 *                                 Fifo.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements a simple FIFO
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "Fifo.h"
#include <memory.h>
#include <string.h>


/********************************************************************
 * Fifo()
 ********************************************************************/
Fifo::Fifo(void)
{
    buffer = new Char[512];
    max_len = 512;
    len = 0;
}

/********************************************************************
 * append
 ********************************************************************/
void Fifo::append(Char *str)
{
    Uint32 strl = strlen(str);

    if ((strl+len) > max_len) {
        Char *tmp = buffer;
        buffer = new Char[(strl+len)*2];
        memcpy(buffer, tmp, len);
        delete[] tmp;
        max_len = (strl+len)*2;
    }

    memcpy(&buffer[len], str, strl);
    len += strl;
}

/********************************************************************
 * dequeue()
 ********************************************************************/
Uint32 Fifo::dequeue(Char *buf, Uint32 buf_len)
{
    Uint32 out_len = (buf_len>len)?len:buf_len;

    memcpy(buf, buffer, out_len);
    memmove(buffer, &buffer[out_len], out_len);
    len -= out_len;

    return out_len;
}

/********************************************************************
 * operator <<
 ********************************************************************/
void Fifo::operator << (Char *str)
{
    append(str);
}

/********************************************************************
 * length()
 ********************************************************************/
Uint32 Fifo::length(void) 
{
    return len;
}


