/*****************************************************************************
 *                            CallbackType.h
 * 
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *****************************************************************************/
#ifndef INCLUDED_CALLBACK_TYPE_H
#define INCLUDED_CALLBACK_TYPE_H
#include "types.h"
#include <tcl.h>
#include "ivi_String.h"

class CallbackMgr;
class Callback;
class CallbackList;
class CallbackType {
    public:
        CallbackType(const char *typeName, CallbackMgr *mgr);
        void AddCb(const char *cbInstName, Callback *cb);
        Tcl_Interp *get_interp();
        int Invoke(const char *cbInst, Uint32 argc, Tcl_Obj *const objv[]);
        int Disable(const char *cbInst);
        int Enable(const char *cbInst);

        CallbackList *GetCbList(const char *cbInstName);

    private:
        String              d_typeName;
        CallbackMgr        *mgr;
        Tcl_HashTable       instHashTab;
};

#endif /* INCLUDED_CALLBACK_TYPE_H */

