import re
import cgi
import urllib

from dosage.util import fetchManyMatches, fetchMatch
from dosage.comic import Comic

class KingFeatures:
    baseUrl = 'http://kingfeatures.com/features/comics/%s/aboutMaina.php'
    imageUrl = 'http://est.rbma.com/content/%s?date=%%s'
    imageSearch = re.compile(r"<img src='(http://est\.rbma\.com/content/[^?]+\?date=\d{8})'>")
    dateSearch = re.compile(r'<option value="(\d{8})">')
    help = 'Index format: yyyymmdd'

    submodules = {
        'spidermn': 'Spiderman',
        'apt3g': 'Apartment_3-G',
        'babyblue': 'Baby_Blues',
        'bgoogle': 'Barney_Google',
        'bbailey': 'Beetle_Bailey',
        'bethalf': 'Better_Half',
        'bfriends': 'Between_Friends',
        'bizarro': 'Bizarro',
        'blondie': 'Blondie',
        'buckles': 'Buckles',
        'crank': 'Crankshaft',
        'crock': 'Crock',
        'curtis': 'Curtis',
        'dennis': 'Dennis_The_Menace',
        'edgecity': 'Edge_City',
        'familyc': 'Family_Circus',
        'fgordon': 'Flash',
        'fibbs': 'None',
        'fwinker': 'Funky_Winkerbean',
        'grinbear': 'Grin_and_Bear_It',
        'hagar': 'Hagar_The_Horrible',
        'hazel': 'Hazel',
        'henry': 'Henry',
        'hi_lois': 'Hi_and_Lois',
        'jparker': 'Judge_Parker',
        'katzkids': 'Katzenjammer_Kids',
        'lockhorn': 'Lockhorns',
        'mallard': 'Mallard_Fillmore',
        'mandrake': 'Mandrake',
        'mtrail': 'Mark_Trail',
        'marvin': 'Marvin',
        'mworth': 'Mary_Worth',
        'moosemol': 'Moose',
        'grimmy': 'Mgoose',
        'mutts': 'Mutts',
        'fastrack': 'Fast_Track',
        'pardonpl': 'Pardon_My_Planet',
        'phantom': 'Phantom',
        'piranha': 'Piranha',
        'popeye': 'Popeye',
        'pvaliant': 'Prince_Valiant',
        'redeye': 'Redeye',
        'rmorgan': 'Rex_Morgan',
        'orange': 'Rhymes_with_Orange',
        'safehavn': 'Safe_Havens',
        'sforth': 'Sally_Forth',
        'sam_silo': 'Sam',
        'lagoon': 'Shermans_Lagoon',
        'sixchix': '6Chix',
        'slylock': 'Slylock',
        'sroper': 'Steve_Roper',
        'theydoit': 'TDIE',
        'tiger': 'Tiger',
        'tgroove': 'Tinas_Groove',
        'todd': 'Todd',
        'trudy': 'Trudy',
        'tumblewd': 'Tumbleweeds',
        'zippy': 'Zippy_the_Pinhead',
        'zits': 'Zits',
    }

    def __init__(self, submodule):
        self.baseUrl = self.baseUrl % (submodule)
        self.imageUrl = self.imageUrl % (self.submodules[submodule],)
        self.name = 'KingFeatures' + '/' + submodule

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % (index,)

    def getFilename(self, imageUrl):
        queryString = urllib.splitquery(imageUrl)[1]
        attribs = cgi.parse_qs(queryString)
        return attribs['date'][0]

    def getCurrentComics(self):
        date = fetchMatch(self.baseUrl, self.dateSearch)
        self.setStrip(date)
        return self.getNextComics()
        
    def getNextComics(self):
        return [Comic(self.name, self.currentUrl, filename=self.getFilename(self.currentUrl), referrer=self.baseUrl)]

    def __iter__(self):
        dates = fetchManyMatches(self.baseUrl, (self.dateSearch,))[0]
        for date in dates:
            self.setStrip(date)
            comics = self.getNextComics()
            if comics:
                yield comics
