import re
import urllib
import cgi
from dosage.util import urlopen
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class InkTank(BasicComicModule):
    imageUrl = 'd/%s.html'
    imageSearch = re.compile(r'<IMG SRC="(/images/[^/]+/cartoons/\d{2}-\d{2}-\d{2}.+?)"')
    prevSearch = re.compile(r'<A HREF="(/[^/]+/index.cfm\?nav=\d+?)"><IMG SRC="/images/nav_last.gif"')
    currentIndexSearch = re.compile(r'<a href=".+?email\.cfm\?send=(\d+)">')
    help = 'Index format: n (unpadded)'

    submodules = {
        'AngstTechnology': 'http://www.inktank.com/AT/',
        'WeakEndWarriors': 'http://www.inktank.com/WW/',
        'SorryWereOpen': 'http://www.inktank.com/SWO/',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = self.submodules[submodule]
        self.latestUrl = baseUrl
        self.imageUrl = baseUrl + self.imageUrl
        self.name = 'InkTank' + '/' + submodule

    def getFilename(self, imageUrl, pageUrl):
        if pageUrl in self.submodules.values():
            page = urlopen(pageUrl)
            data = page.read()

            match = self.currentIndexSearch.search(data)
            if match:
                return match.group(1)
            
        queryString = urllib.splitquery(pageUrl)[1]
        attribs = cgi.parse_qs(queryString)
        return attribs['nav'][0]
